/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.collections.BeanMap;
import org.apache.dolphinscheduler.api.dto.resources.filter.ResourceFilter;
import org.apache.dolphinscheduler.api.dto.resources.visitor.ResourceTreeVisitor;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.ResourcesUser;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.utils.ResourceProcessDefinitionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesService.class);
    @Autowired
    private ResourceMapper resourcesMapper;
    @Autowired
    private UdfFuncMapper udfFunctionMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;

    @Transactional(rollbackFor={Exception.class})
    public Result createDirectory(User loginUser, String name, String description, ResourceType type, int pid, String currentDir) {
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        String fullName = currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
        result = this.verifyResourceName(fullName, type, loginUser);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        if (pid != -1) {
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(pid));
            if (parentResource == null) {
                this.putMsg(result, Status.PARENT_RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, parentResource.getUserId())) {
                this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, true, description, name, loginUser.getId(), type, 0L, now, now);
        try {
            this.resourcesMapper.insert((Object)resource);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (DuplicateKeyException e) {
            logger.error("resource directory {} has exist, can't recreate", (Object)fullName);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        catch (Exception e) {
            logger.error("resource already exists, can't recreate ", (Throwable)e);
            throw new RuntimeException("resource already exists, can't recreate");
        }
        this.createDirecotry(loginUser, fullName, type, result);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result createResource(User loginUser, String name, String desc, ResourceType type, MultipartFile file, int pid, String currentDir) {
        String fullName;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (pid != -1) {
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(pid));
            if (parentResource == null) {
                this.putMsg(result, Status.PARENT_RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, parentResource.getUserId())) {
                this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
        }
        if (file.isEmpty()) {
            logger.error("file is empty: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_FILE_IS_EMPTY, new Object[0]);
            return result;
        }
        String fileSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)file.getOriginalFilename());
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)name);
        if (!StringUtils.isNotEmpty((CharSequence)fileSuffix) || !fileSuffix.equalsIgnoreCase(nameSuffix)) {
            logger.error("rename file suffix and original suffix must be consistent: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_SUFFIX_FORBID_CHANGE, new Object[0]);
            return result;
        }
        if ("UDF".equals(type.name()) && !"jar".equalsIgnoreCase(fileSuffix)) {
            logger.error(Status.UDF_RESOURCE_SUFFIX_NOT_JAR.getMsg());
            this.putMsg(result, Status.UDF_RESOURCE_SUFFIX_NOT_JAR, new Object[0]);
            return result;
        }
        if (file.getSize() > 0x40000000L) {
            logger.error("file size is too large: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_SIZE_EXCEED_LIMIT, new Object[0]);
            return result;
        }
        String string = fullName = currentDir.equals("/") ? String.format("%s%s", currentDir, name) : String.format("%s/%s", currentDir, name);
        if (this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource {} has exist, can't recreate", (Object)name);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, false, desc, file.getOriginalFilename(), loginUser.getId(), type, file.getSize(), now, now);
        try {
            this.resourcesMapper.insert((Object)resource);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error("resource already exists, can't recreate ", (Throwable)e);
            throw new RuntimeException("resource already exists, can't recreate");
        }
        if (!this.upload(loginUser, fullName, file, type)) {
            logger.error("upload resource: {} file: {} failed.", (Object)name, (Object)file.getOriginalFilename());
            this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            throw new RuntimeException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
        }
        return result;
    }

    private boolean checkResourceExists(String fullName, int userId, int type) {
        List resources = this.resourcesMapper.queryResourceList(fullName, userId, type);
        return resources != null && resources.size() > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateResource(User loginUser, int resourceId, String name, String desc, ResourceType type, MultipartFile file) {
        String tenantCode;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (file == null && name.equals(resource.getAlias()) && desc.equals(resource.getDescription())) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        String originFullName = resource.getFullName();
        String originResourceName = resource.getAlias();
        String fullName = String.format("%s%s", originFullName.substring(0, originFullName.lastIndexOf("/") + 1), name);
        if (!originResourceName.equals(name) && this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource {} already exists, can't recreate", (Object)name);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        if (file != null) {
            if (file.isEmpty()) {
                logger.error("file is empty: {}", (Object)file.getOriginalFilename());
                this.putMsg(result, Status.RESOURCE_FILE_IS_EMPTY, new Object[0]);
                return result;
            }
            String fileSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)file.getOriginalFilename());
            String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)name);
            if (!StringUtils.isNotEmpty((CharSequence)fileSuffix) || !fileSuffix.equalsIgnoreCase(nameSuffix)) {
                logger.error("rename file suffix and original suffix must be consistent: {}", (Object)file.getOriginalFilename());
                this.putMsg(result, Status.RESOURCE_SUFFIX_FORBID_CHANGE, new Object[0]);
                return result;
            }
            if ("UDF".equals(type.name()) && !"jar".equalsIgnoreCase(org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)originFullName))) {
                logger.error(Status.UDF_RESOURCE_SUFFIX_NOT_JAR.getMsg());
                this.putMsg(result, Status.UDF_RESOURCE_SUFFIX_NOT_JAR, new Object[0]);
                return result;
            }
            if (file.getSize() > 0x40000000L) {
                logger.error("file size is too large: {}", (Object)file.getOriginalFilename());
                this.putMsg(result, Status.RESOURCE_SIZE_EXCEED_LIMIT, new Object[0]);
                return result;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(tenantCode = this.getTenantCode(resource.getUserId(), result)))) {
            return result;
        }
        String originHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)originFullName);
        try {
            if (!HadoopUtils.getInstance().exists(originHdfsFileName)) {
                logger.error("{} not exist", (Object)originHdfsFileName);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(Status.HDFS_OPERATION_ERROR);
        }
        if (!resource.isDirectory()) {
            String originSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)originFullName);
            String suffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)fullName);
            boolean suffixIsChanged = false;
            if (StringUtils.isBlank((String)suffix) && StringUtils.isNotBlank((String)originSuffix)) {
                suffixIsChanged = true;
            }
            if (StringUtils.isNotBlank((String)suffix) && !suffix.equals(originSuffix)) {
                suffixIsChanged = true;
            }
            if (suffixIsChanged) {
                HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
                columnMap.put("resources_id", resourceId);
                List resourcesUsers = this.resourceUserMapper.selectByMap(columnMap);
                if (CollectionUtils.isNotEmpty((Collection)resourcesUsers)) {
                    List userIds = resourcesUsers.stream().map(ResourcesUser::getUserId).collect(Collectors.toList());
                    List users = this.userMapper.selectBatchIds(userIds);
                    String userNames = users.stream().map(User::getUserName).collect(Collectors.toList()).toString();
                    logger.error("resource is authorized to user {},suffix not allowed to be modified", (Object)userNames);
                    this.putMsg(result, Status.RESOURCE_IS_AUTHORIZED, userNames);
                    return result;
                }
            }
        }
        Date now = new Date();
        resource.setAlias(name);
        resource.setFullName(fullName);
        resource.setDescription(desc);
        resource.setUpdateTime(now);
        if (file != null) {
            resource.setFileName(file.getOriginalFilename());
            resource.setSize(file.getSize());
        }
        try {
            List udfFuncs;
            this.resourcesMapper.updateById((Object)resource);
            if (resource.isDirectory()) {
                List<Integer> childrenResource = this.listAllChildren(resource, false);
                if (CollectionUtils.isNotEmpty(childrenResource)) {
                    List udfFuncs2;
                    String matcherFullName = Matcher.quoteReplacement(fullName);
                    List<Object> childResourceList = new ArrayList();
                    Integer[] childResIdArray = childrenResource.toArray(new Integer[childrenResource.size()]);
                    List resourceList = this.resourcesMapper.listResourceByIds(childResIdArray);
                    childResourceList = resourceList.stream().map(t -> {
                        t.setFullName(t.getFullName().replaceFirst(originFullName, matcherFullName));
                        t.setUpdateTime(now);
                        return t;
                    }).collect(Collectors.toList());
                    this.resourcesMapper.batchUpdateResource(childResourceList);
                    if (ResourceType.UDF.equals((Object)resource.getType()) && CollectionUtils.isNotEmpty((Collection)(udfFuncs2 = this.udfFunctionMapper.listUdfByResourceId(childResIdArray)))) {
                        udfFuncs2 = udfFuncs2.stream().map(t -> {
                            t.setResourceName(t.getResourceName().replaceFirst(originFullName, matcherFullName));
                            t.setUpdateTime(now);
                            return t;
                        }).collect(Collectors.toList());
                        this.udfFunctionMapper.batchUpdateUdfFunc(udfFuncs2);
                    }
                }
            } else if (ResourceType.UDF.equals((Object)resource.getType()) && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceId(new Integer[]{resourceId})))) {
                udfFuncs = udfFuncs.stream().map(t -> {
                    t.setResourceName(fullName);
                    t.setUpdateTime(now);
                    return t;
                }).collect(Collectors.toList());
                this.udfFunctionMapper.batchUpdateUdfFunc(udfFuncs);
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap(5);
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            throw new ServiceException(Status.UPDATE_RESOURCE_ERROR);
        }
        if (originResourceName.equals(name) && file == null) {
            return result;
        }
        if (file != null) {
            if (!this.upload(loginUser, fullName, file, type)) {
                logger.error("upload resource: {} file: {} failed.", (Object)name, (Object)file.getOriginalFilename());
                this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                throw new RuntimeException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
            }
            if (!fullName.equals(originFullName)) {
                try {
                    HadoopUtils.getInstance().delete(originHdfsFileName, false);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(String.format("delete resource: %s failed.", originFullName));
                }
            }
            return result;
        }
        String destHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)fullName);
        try {
            logger.info("start hdfs copy {} -> {}", (Object)originHdfsFileName, (Object)destHdfsFileName);
            HadoopUtils.getInstance().copy(originHdfsFileName, destHdfsFileName, true, true);
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("hdfs copy {0} -> {1} fail", originHdfsFileName, destHdfsFileName), (Throwable)e);
            this.putMsg(result, Status.HDFS_COPY_FAIL, new Object[0]);
            throw new ServiceException(Status.HDFS_COPY_FAIL);
        }
        return result;
    }

    public Map<String, Object> queryResourceListPaging(User loginUser, int direcotryId, ResourceType type, String searchVal, Integer pageNo, Integer pageSize) {
        Resource directory;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        if (direcotryId != -1 && (directory = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(direcotryId))) == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        IPage resourceIPage = this.resourcesMapper.queryResourcePaging((IPage)page, userId, direcotryId, type.ordinal(), searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)resourceIPage.getTotal());
        pageInfo.setLists(resourceIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void createDirecotry(User loginUser, String fullName, ResourceType type, Result result) {
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String directoryName = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
        String resourceRootPath = HadoopUtils.getHdfsDir((ResourceType)type, (String)tenantCode);
        try {
            if (!HadoopUtils.getInstance().exists(resourceRootPath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            if (!HadoopUtils.getInstance().mkdir(directoryName)) {
                logger.error("create resource directory {} of hdfs failed", (Object)directoryName);
                this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                throw new RuntimeException(String.format("create resource directory: %s failed.", directoryName));
            }
        }
        catch (Exception e) {
            logger.error("create resource directory {} of hdfs failed", (Object)directoryName);
            this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            throw new RuntimeException(String.format("create resource directory: %s failed.", directoryName));
        }
    }

    private boolean upload(User loginUser, String fullName, MultipartFile file, ResourceType type) {
        String fileSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)file.getOriginalFilename());
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)fullName);
        if (!StringUtils.isNotEmpty((CharSequence)fileSuffix) || !fileSuffix.equalsIgnoreCase(nameSuffix)) {
            return false;
        }
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
        String resourcePath = HadoopUtils.getHdfsDir((ResourceType)type, (String)tenantCode);
        try {
            if (!HadoopUtils.getInstance().exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            FileUtils.copyFile(file, localFilename);
            HadoopUtils.getInstance().copyLocalToHdfs(localFilename, hdfsFilename, true, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, Object> queryResourceList(User loginUser, ResourceType type) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        List allResourceList = this.resourcesMapper.queryResourceListAuthored(userId, type.ordinal(), 0);
        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(allResourceList);
        result.put("data", resourceTreeVisitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryResourceByProgramType(User loginUser, ResourceType type, ProgramType programType) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String suffix = ".jar";
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        if (programType != null) {
            switch (programType) {
                case JAVA: {
                    break;
                }
                case SCALA: {
                    break;
                }
                case PYTHON: {
                    suffix = ".py";
                }
            }
        }
        List allResourceList = this.resourcesMapper.queryResourceListAuthored(userId, type.ordinal(), 0);
        List<Resource> resources = new ResourceFilter(suffix, new ArrayList<Resource>(allResourceList)).filter();
        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(resources);
        result.put("data", resourceTreeVisitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delete(User loginUser, int resourceId) throws Exception {
        Object udfFuncs;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resource file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return result;
        }
        List list = this.processDefinitionMapper.listResources();
        Map resourceProcessMap = ResourceProcessDefinitionUtils.getResourceProcessDefinitionMap((List)list);
        Set resourceIdSet = resourceProcessMap.keySet();
        List<Integer> allChildren = this.listAllChildren(resource, true);
        Integer[] needDeleteResourceIdArray = allChildren.toArray(new Integer[allChildren.size()]);
        if (resource.getType() == ResourceType.UDF && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceId(needDeleteResourceIdArray)))) {
            logger.error("can't be deleted,because it is bound by UDF functions:{}", (Object)udfFuncs.toString());
            this.putMsg(result, Status.UDF_RESOURCE_IS_BOUND, ((UdfFunc)udfFuncs.get(0)).getFuncName());
            return result;
        }
        if (resourceIdSet.contains(resource.getPid())) {
            logger.error("can't be deleted,because it is used of process definition");
            this.putMsg(result, Status.RESOURCE_IS_USED, new Object[0]);
            return result;
        }
        resourceIdSet.retainAll(allChildren);
        if (CollectionUtils.isNotEmpty(resourceIdSet)) {
            logger.error("can't be deleted,because it is used of process definition");
            for (Integer resId : resourceIdSet) {
                logger.error("resource id:{} is used of process definition {}", (Object)resId, resourceProcessMap.get(resId));
            }
            this.putMsg(result, Status.RESOURCE_IS_USED, new Object[0]);
            return result;
        }
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getFullName());
        this.resourcesMapper.deleteIds(needDeleteResourceIdArray);
        this.resourceUserMapper.deleteResourceUserArray(0, needDeleteResourceIdArray);
        HadoopUtils.getInstance().delete(hdfsFilename, true);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Result verifyResourceName(String fullName, ResourceType type, User loginUser) {
        Result result = new Result();
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        if (this.checkResourceExists(fullName, 0, type.ordinal())) {
            logger.error("resource type:{} name:{} has exist, can't create again.", (Object)type, (Object)fullName);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
        } else {
            Tenant tenant = this.tenantMapper.queryById(loginUser.getTenantId());
            if (tenant != null) {
                String tenantCode = tenant.getTenantCode();
                try {
                    String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)fullName);
                    if (HadoopUtils.getInstance().exists(hdfsFilename)) {
                        logger.error("resource type:{} name:{} has exist in hdfs {}, can't create again.", new Object[]{type, fullName, hdfsFilename});
                        this.putMsg(result, Status.RESOURCE_FILE_EXIST, hdfsFilename);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                }
            } else {
                this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            }
        }
        return result;
    }

    public Result queryResource(String fullName, Integer id, ResourceType type) {
        Result<Object> result = new Result<Object>();
        if (StringUtils.isBlank((String)fullName) && id == null) {
            logger.error("You must input one of fullName and pid");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[0]);
            return result;
        }
        if (StringUtils.isNotBlank((String)fullName)) {
            List resourceList = this.resourcesMapper.queryResource(fullName, type.ordinal());
            if (CollectionUtils.isEmpty((Collection)resourceList)) {
                logger.error("resource file not exist,  resource full name {} ", (Object)fullName);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.setData(resourceList.get(0));
        } else {
            Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)id);
            if (resource == null) {
                logger.error("resource file not exist,  resource id {}", (Object)id);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resource.getPid()));
            if (parentResource == null) {
                logger.error("parent resource file not exist,  resource id {}", (Object)id);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.setData(parentResource);
        }
        return result;
    }

    public Result readResource(int resourceId, int skipLineNum, int limit) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resource file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resource suffix {} not support view,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return result;
        }
        String hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resource.getFullName());
        logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
        try {
            if (HadoopUtils.getInstance().exists(hdfsFileName)) {
                List content = HadoopUtils.getInstance().catFile(hdfsFileName, skipLineNum, limit);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", resource.getAlias());
                map.put("content", String.join((CharSequence)"\n", content));
                result.setData(map);
            } else {
                logger.error("read file {} not exist in hdfs", (Object)hdfsFileName);
                this.putMsg(result, Status.RESOURCE_FILE_NOT_EXIST, hdfsFileName);
            }
        }
        catch (Exception e) {
            logger.error("Resource {} read failed", (Object)hdfsFileName, (Object)e);
            this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result onlineCreateResource(User loginUser, ResourceType type, String fileName, String fileSuffix, String desc, String content, int pid, String currentDirectory) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        String nameSuffix = fileSuffix.trim();
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resouce suffix {} not support create", (Object)nameSuffix);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String name = fileName.trim() + "." + nameSuffix;
        String fullName = currentDirectory.equals("/") ? String.format("%s%s", currentDirectory, name) : String.format("%s/%s", currentDirectory, name);
        result = this.verifyResourceName(fullName, type, loginUser);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        if (pid != -1) {
            Resource parentResource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(pid));
            if (parentResource == null) {
                this.putMsg(result, Status.PARENT_RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, parentResource.getUserId())) {
                this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
        }
        Date now = new Date();
        Resource resource = new Resource(pid, name, fullName, false, desc, name, loginUser.getId(), type, (long)content.getBytes().length, now, now);
        this.resourcesMapper.insert((Object)resource);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        BeanMap dataMap = new BeanMap((Object)resource);
        HashMap resultMap = new HashMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
            resultMap.put(entry.getKey().toString(), entry.getValue());
        }
        result.setData(resultMap);
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        result = this.uploadContentToHdfs(fullName, tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new RuntimeException(result.getMsg());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateResourceContent(int resourceId, String content) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("read file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((CharSequence)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resource suffix {} not support updateProcessInstance,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String tenantCode = this.getTenantCode(resource.getUserId(), result);
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return result;
        }
        resource.setSize((long)content.getBytes().length);
        resource.setUpdateTime(new Date());
        this.resourcesMapper.updateById((Object)resource);
        result = this.uploadContentToHdfs(resource.getFullName(), tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new RuntimeException(result.getMsg());
        }
        return result;
    }

    private Result uploadContentToHdfs(String resourceName, String tenantCode, String content) {
        Result result = new Result();
        String localFilename = "";
        String hdfsFileName = "";
        try {
            localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
            if (!org.apache.dolphinscheduler.common.utils.FileUtils.writeContent2File((String)content, (String)localFilename)) {
                logger.error("file {} fail, content is {}", (Object)localFilename, (Object)content);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resourceName);
            String resourcePath = HadoopUtils.getHdfsResDir((String)tenantCode);
            logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
            HadoopUtils hadoopUtils = HadoopUtils.getInstance();
            if (!hadoopUtils.exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            if (hadoopUtils.exists(hdfsFileName)) {
                hadoopUtils.delete(hdfsFileName, false);
            }
            hadoopUtils.copyLocalToHdfs(localFilename, hdfsFileName, true, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setCode(Status.HDFS_OPERATION_ERROR.getCode());
            result.setMsg(String.format("copy %s to hdfs %s fail", localFilename, hdfsFileName));
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public org.springframework.core.io.Resource downloadResource(int resourceId) throws Exception {
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            throw new RuntimeException("hdfs not startup");
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("download file not exist,  resource id {}", (Object)resourceId);
            return null;
        }
        if (resource.isDirectory()) {
            logger.error("resource id {} is directory,can't download it", (Object)resourceId);
            throw new RuntimeException("cant't download directory");
        }
        int userId = resource.getUserId();
        User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
        if (user == null) {
            logger.error("user id {} not exists", (Object)userId);
            throw new RuntimeException(String.format("resource owner id %d not exist", userId));
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            logger.error("tenant id {} not exists", (Object)user.getTenantId());
            throw new RuntimeException(String.format("The tenant id %d of resource owner not exist", user.getTenantId()));
        }
        String tenantCode = tenant.getTenantCode();
        String hdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getFullName());
        String localFileName = org.apache.dolphinscheduler.common.utils.FileUtils.getDownloadFilename((String)resource.getAlias());
        logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
        HadoopUtils.getInstance().copyHdfsToLocal(hdfsFileName, localFileName, false, true);
        return FileUtils.file2Resource(localFileName);
    }

    public Map<String, Object> authorizeResourceTree(User loginUser, Integer userId) {
        List<Object> list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List resourceList = this.resourcesMapper.queryResourceExceptUserId(userId.intValue());
        if (CollectionUtils.isNotEmpty((Collection)resourceList)) {
            ResourceTreeVisitor visitor = new ResourceTreeVisitor(resourceList);
            list = visitor.visit().getChildren();
        } else {
            list = new ArrayList(0);
        }
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> unauthorizedFile(User loginUser, Integer userId) {
        ArrayList<Object> list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List resourceList = this.resourcesMapper.queryResourceExceptUserId(userId.intValue());
        if (resourceList != null && resourceList.size() > 0) {
            HashSet resourceSet = new HashSet(resourceList);
            List authedResourceList = this.resourcesMapper.queryAuthorizedResourceList(userId.intValue());
            this.getAuthorizedResourceList(resourceSet, authedResourceList);
            list = new ArrayList(resourceSet);
        } else {
            list = new ArrayList<Resource>(0);
        }
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(list);
        result.put("data", visitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> unauthorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncList = this.udfFunctionMapper.queryUdfFuncExceptUserId(userId.intValue());
        ArrayList resultList = new ArrayList();
        HashSet udfFuncSet = null;
        if (CollectionUtils.isNotEmpty((Collection)udfFuncList)) {
            udfFuncSet = new HashSet(udfFuncList);
            List authedUDFFuncList = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
            this.getAuthorizedResourceList(udfFuncSet, authedUDFFuncList);
            resultList = new ArrayList(udfFuncSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> authorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncs = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
        result.put("data", udfFuncs);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> authorizedFile(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List authedResources = this.resourcesMapper.queryAuthorizedResourceList(userId.intValue());
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(authedResources);
        logger.info(JSON.toJSONString((Object)visitor.visit(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField}));
        String jsonTreeStr = JSON.toJSONString(visitor.visit().getChildren(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField});
        logger.info(jsonTreeStr);
        result.put("data", visitor.visit().getChildren());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void getAuthorizedResourceList(Set<?> resourceSet, List<?> authedResourceList) {
        HashSet authedResourceSet = null;
        if (CollectionUtils.isNotEmpty(authedResourceList)) {
            authedResourceSet = new HashSet(authedResourceList);
            resourceSet.removeAll(authedResourceSet);
        }
    }

    private String getTenantCode(int userId, Result result) {
        User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(userId));
        if (user == null) {
            logger.error("user {} not exists", (Object)userId);
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return null;
        }
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        if (tenant == null) {
            logger.error("tenant not exists");
            this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            return null;
        }
        return tenant.getTenantCode();
    }

    List<Integer> listAllChildren(Resource resource, boolean containSelf) {
        ArrayList<Integer> childList = new ArrayList<Integer>();
        if (resource.getId() != -1 && containSelf) {
            childList.add(resource.getId());
        }
        if (resource.isDirectory()) {
            this.listAllChildren(resource.getId(), childList);
        }
        return childList;
    }

    void listAllChildren(int resourceId, List<Integer> childList) {
        List children = this.resourcesMapper.listChildren(resourceId);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            int chlidId = (Integer)iterator.next();
            childList.add(chlidId);
            this.listAllChildren(chlidId, childList);
        }
    }
}

