/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.service.zk.ZookeeperCachedOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerGroupService
extends BaseService {
    @Autowired
    ProcessInstanceMapper processInstanceMapper;
    @Autowired
    protected ZookeeperCachedOperator zookeeperCachedOperator;

    public Map<String, Object> queryAllGroupPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        Integer fromIndex = (pageNo - 1) * pageSize;
        Integer toIndex = (pageNo - 1) * pageSize + pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List<WorkerGroup> workerGroups = this.getWorkerGroups(true);
        List<Object> resultDataList = new ArrayList();
        if (CollectionUtils.isNotEmpty(workerGroups)) {
            List<Object> searchValDataList = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)searchVal)) {
                for (WorkerGroup workerGroup : workerGroups) {
                    if (!workerGroup.getName().contains(searchVal)) continue;
                    searchValDataList.add(workerGroup);
                }
            } else {
                searchValDataList = workerGroups;
            }
            if (searchValDataList.size() < pageSize) {
                toIndex = (pageNo - 1) * pageSize + searchValDataList.size();
            }
            resultDataList = searchValDataList.subList(fromIndex, toIndex);
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount(resultDataList.size());
        pageInfo.setLists(resultDataList);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryAllGroup() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<WorkerGroup> workerGroups = this.getWorkerGroups(false);
        Set availableWorkerGroupSet = workerGroups.stream().map(workerGroup -> workerGroup.getName()).collect(Collectors.toSet());
        result.put("data", availableWorkerGroupSet);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<WorkerGroup> getWorkerGroups(boolean isPaging) {
        String workerPath = this.zookeeperCachedOperator.getZookeeperConfig().getDsRoot() + "/nodes/worker";
        List workerGroupList = this.zookeeperCachedOperator.getChildrenKeys(workerPath);
        ArrayList<String> availableWorkerGroupList = new ArrayList<String>();
        ArrayList<WorkerGroup> workerGroups = new ArrayList<WorkerGroup>();
        for (String workerGroup : workerGroupList) {
            String workerGroupPath = workerPath + "/" + workerGroup;
            List childrenNodes = this.zookeeperCachedOperator.getChildrenKeys(workerGroupPath);
            if (!CollectionUtils.isNotEmpty((Collection)childrenNodes)) continue;
            availableWorkerGroupList.add(workerGroup);
            WorkerGroup wg = new WorkerGroup();
            wg.setName(workerGroup);
            if (isPaging) {
                wg.setIpList(childrenNodes);
                String registeredIpValue = this.zookeeperCachedOperator.get(workerGroupPath + "/" + (String)childrenNodes.get(0));
                wg.setCreateTime(DateUtils.stringToDate((String)registeredIpValue.split(",")[6]));
                wg.setUpdateTime(DateUtils.stringToDate((String)registeredIpValue.split(",")[7]));
            }
            workerGroups.add(wg);
        }
        return workerGroups;
    }
}

