/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils.exportprocess;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import org.apache.dolphinscheduler.api.utils.exportprocess.ProcessAddTaskParam;
import org.apache.dolphinscheduler.api.utils.exportprocess.TaskNodeParamFactory;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceParam
implements ProcessAddTaskParam,
InitializingBean {
    @Autowired
    private DataSourceMapper dataSourceMapper;

    @Override
    public JSONObject addExportSpecialParam(JSONObject taskNode) {
        JSONObject sqlParameters = JSONUtils.parseObject((String)taskNode.getString("params"));
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)((Integer)sqlParameters.get((Object)"datasource")));
        if (null != dataSource) {
            sqlParameters.put("datasourceName", (Object)dataSource.getName());
        }
        taskNode.put("params", (Object)sqlParameters);
        return taskNode;
    }

    @Override
    public JSONObject addImportSpecialParam(JSONObject taskNode) {
        JSONObject sqlParameters = JSONUtils.parseObject((String)taskNode.getString("params"));
        List dataSources = this.dataSourceMapper.queryDataSourceByName(sqlParameters.getString("datasourceName"));
        if (!dataSources.isEmpty()) {
            DataSource dataSource = (DataSource)dataSources.get(0);
            sqlParameters.put("datasource", (Object)dataSource.getId());
        }
        taskNode.put("params", (Object)sqlParameters);
        return taskNode;
    }

    public void afterPropertiesSet() {
        TaskNodeParamFactory.register(TaskType.SQL.name(), this);
        TaskNodeParamFactory.register(TaskType.PROCEDURE.name(), this);
    }
}

