/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.interceptor;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LocaleChangeInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Cookie cookie = BaseService.getCookie(request, "language");
        if (cookie != null) {
            return true;
        }
        String newLocale = request.getHeader("language");
        if (newLocale != null) {
            LocaleContextHolder.setLocale((Locale)this.parseLocaleValue(newLocale));
        }
        return true;
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return StringUtils.parseLocale((String)localeValue);
    }
}

