/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskInstanceService
extends BaseService {
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    ProcessInstanceService processInstanceService;
    @Autowired
    UsersService usersService;

    public Map<String, Object> queryTaskListPaging(User loginUser, String projectName, Integer processInstanceId, String taskName, String executorName, String startDate, String endDate, String searchVal, ExecutionStatus stateType, String host, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.ordinal()};
        }
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startDate)) {
                start = DateUtils.getScheduleDate((String)startDate);
            }
            if (StringUtils.isNotEmpty((CharSequence)endDate)) {
                end = DateUtils.getScheduleDate((String)endDate);
            }
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "startDate,endDate"));
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        int executorId = this.usersService.getUserIdByName(executorName);
        IPage taskInstanceIPage = this.taskInstanceMapper.queryTaskInstanceListPaging((IPage)page, project.getId(), processInstanceId, searchVal, taskName, executorId, statusArray, host, start, end);
        HashSet<String> exclusionSet = new HashSet<String>();
        exclusionSet.add("class");
        exclusionSet.add("taskJson");
        List taskInstanceList = taskInstanceIPage.getRecords();
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstance.setDuration(Long.valueOf(DateUtils.differSec((Date)taskInstance.getStartTime(), (Date)taskInstance.getEndTime())));
            User executor = this.usersService.queryUser(taskInstance.getExecutorId());
            if (null == executor) continue;
            taskInstance.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotalCount((int)taskInstanceIPage.getTotal());
        pageInfo.setLists(CollectionUtils.getListByExclusion((List)taskInstanceIPage.getRecords(), exclusionSet));
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

