/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"DATA_ANALYSIS_TAG"}, position=1)
@RestController
@RequestMapping(value={"projects/analysis"})
public class DataAnalysisController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(DataAnalysisController.class);
    @Autowired
    DataAnalysisService dataAnalysisService;

    @ApiOperation(value="countTaskState", notes="COUNT_TASK_STATE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", value="START_DATE", dataType="String"), @ApiImplicitParam(name="endDate", value="END_DATE", dataType="String"), @ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/task-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_INSTANCE_STATE_COUNT_ERROR)
    public Result countTaskState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="projectId", required=false, defaultValue="0") int projectId) {
        logger.info("count task state, user:{}, start date: {}, end date:{}, project id {}", new Object[]{loginUser.getUserName(), startDate, endDate, projectId});
        Map<String, Object> result = this.dataAnalysisService.countTaskStateByProject(loginUser, projectId, startDate, endDate);
        return this.returnDataList(result);
    }

    @ApiOperation(value="countProcessInstanceState", notes="COUNT_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", value="START_DATE", dataType="String"), @ApiImplicitParam(name="endDate", value="END_DATE", dataType="String"), @ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/process-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_INSTANCE_STATE_ERROR)
    public Result countProcessInstanceState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="projectId", required=false, defaultValue="0") int projectId) {
        logger.info("count process instance state, user:{}, start date: {}, end date:{}, project id:{}", new Object[]{loginUser.getUserName(), startDate, endDate, projectId});
        Map<String, Object> result = this.dataAnalysisService.countProcessInstanceStateByProject(loginUser, projectId, startDate, endDate);
        return this.returnDataList(result);
    }

    @ApiOperation(value="countDefinitionByUser", notes="COUNT_PROCESS_DEFINITION_BY_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/define-user-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_PROCESS_DEFINITION_USER_ERROR)
    public Result countDefinitionByUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId", required=false, defaultValue="0") int projectId) {
        logger.info("count process definition , user:{}, project id:{}", (Object)loginUser.getUserName(), (Object)projectId);
        Map<String, Object> result = this.dataAnalysisService.countDefinitionByUser(loginUser, projectId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="countCommandState", notes="COUNT_COMMAND_STATE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", value="START_DATE", dataType="String"), @ApiImplicitParam(name="endDate", value="END_DATE", dataType="String"), @ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/command-state-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COMMAND_STATE_COUNT_ERROR)
    public Result countCommandState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="projectId", required=false, defaultValue="0") int projectId) {
        logger.info("count command state, user:{}, start date: {}, end date:{}, project id {}", new Object[]{loginUser.getUserName(), startDate, endDate, projectId});
        Map<String, Object> result = this.dataAnalysisService.countCommandState(loginUser, projectId, startDate, endDate);
        return this.returnDataList(result);
    }

    @ApiOperation(value="countQueueState", notes="COUNT_QUEUE_STATE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="PROJECT_ID", dataType="Int", example="100")})
    @GetMapping(value={"/queue-count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUEUE_COUNT_ERROR)
    public Result countQueueState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectId", required=false, defaultValue="0") int projectId) {
        logger.info("count command state, user:{}, project id {}", (Object)loginUser.getUserName(), (Object)projectId);
        Map<String, Object> result = this.dataAnalysisService.countQueueState(loginUser, projectId);
        return this.returnDataList(result);
    }
}

