/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.DbConnectType;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"DATA_SOURCE_TAG"}, position=3)
@RestController
@RequestMapping(value={"datasources"})
public class DataSourceController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceController.class);
    @Autowired
    private DataSourceService dataSourceService;

    @ApiOperation(value="createDataSource", notes="CREATE_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="DATA_SOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="note", value="DATA_SOURCE_NOTE", dataType="String"), @ApiImplicitParam(name="type", value="DB_TYPE", required=true, dataType="DbType"), @ApiImplicitParam(name="host", value="DATA_SOURCE_HOST", required=true, dataType="String"), @ApiImplicitParam(name="port", value="DATA_SOURCE_PORT", required=true, dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="userName", value="USER_NAME", required=true, dataType="String"), @ApiImplicitParam(name="password", value="PASSWORD", dataType="String"), @ApiImplicitParam(name="connectType", value="CONNECT_TYPE", dataType="DbConnectType"), @ApiImplicitParam(name="other", value="DATA_SOURCE_OTHER", dataType="String")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_DATASOURCE_ERROR)
    public Result createDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="note", required=false) String note, @RequestParam(value="type") DbType type, @RequestParam(value="host") String host, @RequestParam(value="port") String port, @RequestParam(value="database") String database, @RequestParam(value="principal") String principal, @RequestParam(value="userName") String userName, @RequestParam(value="password") String password, @RequestParam(value="connectType") DbConnectType connectType, @RequestParam(value="other") String other) {
        logger.info("login user {} create datasource name: {}, note: {}, type: {}, host: {}, port: {}, database : {}, principal: {}, userName : {}, connectType: {}, other: {}", new Object[]{loginUser.getUserName(), name, note, type, host, port, database, principal, userName, connectType, other});
        String parameter = this.dataSourceService.buildParameter(name, note, type, host, port, database, principal, userName, password, connectType, other);
        Map<String, Object> result = this.dataSourceService.createDataSource(loginUser, name, note, type, parameter);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateDataSource", notes="UPDATE_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="name", value="DATA_SOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="note", value="DATA_SOURCE_NOTE", dataType="String"), @ApiImplicitParam(name="type", value="DB_TYPE", required=true, dataType="DbType"), @ApiImplicitParam(name="host", value="DATA_SOURCE_HOST", required=true, dataType="String"), @ApiImplicitParam(name="port", value="DATA_SOURCE_PORT", required=true, dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="userName", value="USER_NAME", required=true, dataType="String"), @ApiImplicitParam(name="password", value="PASSWORD", dataType="String"), @ApiImplicitParam(name="connectType", value="CONNECT_TYPE", dataType="DbConnectType"), @ApiImplicitParam(name="other", value="DATA_SOURCE_OTHER", dataType="String")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_DATASOURCE_ERROR)
    public Result updateDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="name") String name, @RequestParam(value="note", required=false) String note, @RequestParam(value="type") DbType type, @RequestParam(value="host") String host, @RequestParam(value="port") String port, @RequestParam(value="database") String database, @RequestParam(value="principal") String principal, @RequestParam(value="userName") String userName, @RequestParam(value="password") String password, @RequestParam(value="connectType") DbConnectType connectType, @RequestParam(value="other") String other) {
        logger.info("login user {} updateProcessInstance datasource name: {}, note: {}, type: {}, connectType: {}, other: {}", new Object[]{loginUser.getUserName(), name, note, type, connectType, other});
        String parameter = this.dataSourceService.buildParameter(name, note, type, host, port, database, principal, userName, password, connectType, other);
        Map<String, Object> dataSource = this.dataSourceService.updateDataSource(id, loginUser, name, note, type, parameter);
        return this.returnDataList(dataSource);
    }

    @ApiOperation(value="queryDataSource", notes="QUERY_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/update-ui"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result queryDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, query datasource: {}", (Object)loginUser.getUserName(), (Object)id);
        Map<String, Object> result = this.dataSourceService.queryDataSource(id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryDataSourceList", notes="QUERY_DATA_SOURCE_LIST_BY_TYPE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="DB_TYPE", required=true, dataType="DbType")})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result queryDataSourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") DbType type) {
        Map<String, Object> result = this.dataSourceService.queryDataSourceList(loginUser, type.ordinal());
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryDataSourceListPaging", notes="QUERY_DATA_SOURCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result queryDataSourceListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataListPaging(result);
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.dataSourceService.queryDataSourceListPaging(loginUser, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="connectDataSource", notes="CONNECT_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="DATA_SOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="note", value="DATA_SOURCE_NOTE", dataType="String"), @ApiImplicitParam(name="type", value="DB_TYPE", required=true, dataType="DbType"), @ApiImplicitParam(name="host", value="DATA_SOURCE_HOST", required=true, dataType="String"), @ApiImplicitParam(name="port", value="DATA_SOURCE_PORT", required=true, dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="userName", value="USER_NAME", required=true, dataType="String"), @ApiImplicitParam(name="password", value="PASSWORD", dataType="String"), @ApiImplicitParam(name="connectType", value="CONNECT_TYPE", dataType="DbConnectType"), @ApiImplicitParam(name="other", value="DATA_SOURCE_OTHER", dataType="String")})
    @PostMapping(value={"/connect"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECT_DATASOURCE_FAILURE)
    public Result connectDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="note", required=false) String note, @RequestParam(value="type") DbType type, @RequestParam(value="host") String host, @RequestParam(value="port") String port, @RequestParam(value="database") String database, @RequestParam(value="principal") String principal, @RequestParam(value="userName") String userName, @RequestParam(value="password") String password, @RequestParam(value="connectType") DbConnectType connectType, @RequestParam(value="other") String other) {
        logger.info("login user {}, connect datasource: {}, note: {}, type: {}, connectType: {}, other: {}", new Object[]{loginUser.getUserName(), name, note, type, connectType, other});
        String parameter = this.dataSourceService.buildParameter(name, note, type, host, port, database, principal, userName, password, connectType, other);
        Boolean isConnection = this.dataSourceService.checkConnection(type, parameter);
        Result result = new Result();
        if (isConnection.booleanValue()) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CONNECT_DATASOURCE_FAILURE, new Object[0]);
        }
        return result;
    }

    @ApiOperation(value="connectionTest", notes="CONNECT_DATA_SOURCE_TEST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/connect-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECTION_TEST_FAILURE)
    public Result connectionTest(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("connection test, login user:{}, id:{}", (Object)loginUser.getUserName(), (Object)id);
        Boolean isConnection = this.dataSourceService.connectionTest(loginUser, id);
        Result result = new Result();
        if (isConnection.booleanValue()) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CONNECTION_TEST_FAILURE, new Object[0]);
        }
        return result;
    }

    @ApiOperation(value="delete", notes="DELETE_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="DATA_SOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_DATA_SOURCE_FAILURE)
    public Result delete(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("delete datasource,login user:{}, id:{}", (Object)loginUser.getUserName(), (Object)id);
        return this.dataSourceService.delete(loginUser, id);
    }

    @ApiOperation(value="verifyDataSourceName", notes="VERIFY_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="DATA_SOURCE_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_DATASOURCE_NAME_FAILURE)
    public Result verifyDataSourceName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        logger.info("login user {}, verfiy datasource name: {}", (Object)loginUser.getUserName(), (Object)name);
        return this.dataSourceService.verifyDataSourceName(loginUser, name);
    }

    @ApiOperation(value="unauthDatasource", notes="UNAUTHORIZED_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/unauth-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UNAUTHORIZED_DATASOURCE)
    public Result unauthDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("unauthorized datasource, login user:{}, unauthorized userId:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.dataSourceService.unauthDatasource(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authedDatasource", notes="AUTHORIZED_DATA_SOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.AUTHORIZED_DATA_SOURCE)
    public Result authedDatasource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("authorized data source, login user:{}, authorized useId:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.dataSourceService.authedDatasource(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getKerberosStartupState", notes="GET_USER_INFO_NOTES")
    @GetMapping(value={"/kerberos-startup-state"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.KERBEROS_STARTUP_STATE)
    public Result getKerberosStartupState(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login user {}", (Object)loginUser.getUserName());
        return this.success(Status.SUCCESS.getMsg(), CommonUtils.getKerberosStartupState());
    }
}

