/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.api.dto.TaskStateCount;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;

public class TaskCountDto {
    private int totalCount;
    private List<TaskStateCount> taskCountDtos;

    public TaskCountDto(List<ExecuteStatusCount> taskInstanceStateCounts) {
        this.countTaskDtos(taskInstanceStateCounts);
    }

    private void countTaskDtos(List<ExecuteStatusCount> taskInstanceStateCounts) {
        int submittedSuccess = 0;
        int runningExecution = 0;
        int readyPause = 0;
        int pause = 0;
        int readyStop = 0;
        int stop = 0;
        int failure = 0;
        int success = 0;
        int needFaultTolerance = 0;
        int kill = 0;
        int waittingThread = 0;
        for (ExecuteStatusCount taskInstanceStateCount : taskInstanceStateCounts) {
            ExecutionStatus status = taskInstanceStateCount.getExecutionStatus();
            this.totalCount += taskInstanceStateCount.getCount();
            switch (status) {
                case SUBMITTED_SUCCESS: {
                    submittedSuccess += taskInstanceStateCount.getCount();
                    break;
                }
                case RUNNING_EXECUTION: {
                    runningExecution += taskInstanceStateCount.getCount();
                    break;
                }
                case READY_PAUSE: {
                    readyPause += taskInstanceStateCount.getCount();
                    break;
                }
                case PAUSE: {
                    pause += taskInstanceStateCount.getCount();
                    break;
                }
                case READY_STOP: {
                    readyStop += taskInstanceStateCount.getCount();
                    break;
                }
                case STOP: {
                    stop += taskInstanceStateCount.getCount();
                    break;
                }
                case FAILURE: {
                    failure += taskInstanceStateCount.getCount();
                    break;
                }
                case SUCCESS: {
                    success += taskInstanceStateCount.getCount();
                    break;
                }
                case NEED_FAULT_TOLERANCE: {
                    needFaultTolerance += taskInstanceStateCount.getCount();
                    break;
                }
                case KILL: {
                    kill += taskInstanceStateCount.getCount();
                    break;
                }
                case WAITTING_THREAD: {
                    waittingThread += taskInstanceStateCount.getCount();
                    break;
                }
            }
        }
        this.taskCountDtos = new ArrayList<TaskStateCount>();
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.SUBMITTED_SUCCESS, submittedSuccess));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.RUNNING_EXECUTION, runningExecution));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.READY_PAUSE, readyPause));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.PAUSE, pause));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.READY_STOP, readyStop));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.STOP, stop));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.FAILURE, failure));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.SUCCESS, success));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.NEED_FAULT_TOLERANCE, needFaultTolerance));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.KILL, kill));
        this.taskCountDtos.add(new TaskStateCount(ExecutionStatus.WAITTING_THREAD, waittingThread));
    }

    public List<TaskStateCount> getTaskCountDtos() {
        return this.taskCountDtos;
    }

    public void setTaskCountDtos(List<TaskStateCount> taskCountDtos) {
        this.taskCountDtos = taskCountDtos;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

