/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.DbConnectType;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.ClickHouseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DB2ServerDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.dao.datasource.HiveDataSource;
import org.apache.dolphinscheduler.dao.datasource.MySQLDataSource;
import org.apache.dolphinscheduler.dao.datasource.OracleDataSource;
import org.apache.dolphinscheduler.dao.datasource.PostgreDataSource;
import org.apache.dolphinscheduler.dao.datasource.SQLServerDataSource;
import org.apache.dolphinscheduler.dao.datasource.SparkDataSource;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceService.class);
    public static final String NAME = "name";
    public static final String NOTE = "note";
    public static final String TYPE = "type";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String PRINCIPAL = "principal";
    public static final String DATABASE = "database";
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";
    public static final String OTHER = "other";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.]+$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.\\:\\[\\]]+$");
    private static final Pattern DATABASE_PATTER = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.]+$");
    private static final Pattern PARAMS_PATTER = Pattern.compile("^[a-zA-Z0-9]+$");
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;

    public Map<String, Object> createDataSource(User loginUser, String name, String desc, DbType type, String parameter) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkName(name)) {
            this.putMsg(result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        Boolean isConnection = this.checkConnection(type, parameter);
        if (!isConnection.booleanValue()) {
            logger.info("connect failed, type:{}, parameter:{}", (Object)type, (Object)parameter);
            this.putMsg(result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
            return result;
        }
        BaseDataSource datasource = DataSourceFactory.getDatasource((DbType)type, (String)parameter);
        if (datasource == null) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, parameter);
            return result;
        }
        DataSource dataSource = new DataSource();
        Date now = new Date();
        dataSource.setName(name.trim());
        dataSource.setNote(desc);
        dataSource.setUserId(loginUser.getId());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(type);
        dataSource.setConnectionParams(parameter);
        dataSource.setCreateTime(now);
        dataSource.setUpdateTime(now);
        this.dataSourceMapper.insert((Object)dataSource);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> updateDataSource(int id, User loginUser, String name, String desc, DbType type, String parameter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, dataSource.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!name.trim().equals(dataSource.getName()) && this.checkName(name)) {
            this.putMsg(result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        Boolean isConnection = this.checkConnection(type, parameter);
        if (!isConnection.booleanValue()) {
            logger.info("connect failed, type:{}, parameter:{}", (Object)type, (Object)parameter);
            this.putMsg(result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
            return result;
        }
        Date now = new Date();
        dataSource.setName(name.trim());
        dataSource.setNote(desc);
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(type);
        dataSource.setConnectionParams(parameter);
        dataSource.setUpdateTime(now);
        this.dataSourceMapper.updateById((Object)dataSource);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkName(String name) {
        List queryDataSource = this.dataSourceMapper.queryDataSourceByName(name.trim());
        return queryDataSource != null && queryDataSource.size() > 0;
    }

    public Map<String, Object> queryDataSource(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String dataSourceType = dataSource.getType().toString();
        String dataSourceName = dataSource.getName();
        String desc = dataSource.getNote();
        String parameter = dataSource.getConnectionParams();
        BaseDataSource datasourceForm = DataSourceFactory.getDatasource((DbType)dataSource.getType(), (String)parameter);
        DbConnectType connectType = null;
        String hostSeperator = "//";
        if (DbType.ORACLE.equals((Object)dataSource.getType()) && DbConnectType.ORACLE_SID.equals((Object)(connectType = ((OracleDataSource)datasourceForm).getConnectType()))) {
            hostSeperator = "@";
        }
        String database = datasourceForm.getDatabase();
        String other = datasourceForm.getOther();
        String address = datasourceForm.getAddress();
        String[] hostsPorts = this.getHostsAndPort(address, hostSeperator);
        String host = hostsPorts[0];
        String port = hostsPorts[1];
        String separator = "";
        switch (dataSource.getType()) {
            case HIVE: 
            case SQLSERVER: {
                separator = ";";
                break;
            }
            case MYSQL: 
            case POSTGRESQL: 
            case CLICKHOUSE: 
            case ORACLE: {
                separator = "&";
                break;
            }
            default: {
                separator = "&";
            }
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        if (other != null) {
            String[] configs;
            for (String config : configs = other.split(separator)) {
                otherMap.put(config.split("=")[0], config.split("=")[1]);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(NAME, dataSourceName);
        map.put(NOTE, desc);
        map.put(TYPE, dataSourceType);
        if (connectType != null) {
            map.put("connectType", connectType);
        }
        map.put(HOST, host);
        map.put(PORT, port);
        map.put(PRINCIPAL, datasourceForm.getPrincipal());
        map.put(DATABASE, database);
        map.put(USER_NAME, datasourceForm.getUser());
        map.put(PASSWORD, datasourceForm.getPassword());
        map.put(OTHER, otherMap);
        result.put("data", map);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryDataSourceListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IPage dataSourceList = null;
        Page dataSourcePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        dataSourceList = this.isAdmin(loginUser) ? this.dataSourceMapper.selectPaging((IPage)dataSourcePage, 0, searchVal) : this.dataSourceMapper.selectPaging((IPage)dataSourcePage, loginUser.getId(), searchVal);
        List dataSources = dataSourceList.getRecords();
        this.handlePasswd(dataSources);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)dataSourceList.getTotal());
        pageInfo.setLists(dataSources);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void handlePasswd(List<DataSource> dataSourceList) {
        for (DataSource dataSource : dataSourceList) {
            String connectionParams = dataSource.getConnectionParams();
            JSONObject object = JSON.parseObject((String)connectionParams);
            object.put(PASSWORD, (Object)"******");
            dataSource.setConnectionParams(JSONUtils.toJson((Object)object));
        }
    }

    public Map<String, Object> queryDataSourceList(User loginUser, Integer type) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List datasourceList = this.isAdmin(loginUser) ? this.dataSourceMapper.listAllDataSourceByType(type) : this.dataSourceMapper.queryDataSourceByType(loginUser.getId(), type);
        result.put("data", datasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Result verifyDataSourceName(User loginUser, String name) {
        Result result = new Result();
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(name);
        if (dataSourceList != null && dataSourceList.size() > 0) {
            logger.error("datasource name:{} has exist, can't create again.", (Object)name);
            this.putMsg(result, Status.DATASOURCE_EXIST, new Object[0]);
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private Connection getConnection(DbType dbType, String parameter) {
        Connection connection = null;
        BaseDataSource datasource = null;
        try {
            switch (dbType) {
                case POSTGRESQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, PostgreDataSource.class);
                    Class.forName("org.postgresql.Driver");
                    break;
                }
                case MYSQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, MySQLDataSource.class);
                    Class.forName("com.mysql.jdbc.Driver");
                    break;
                }
                case HIVE: 
                case SPARK: {
                    if (CommonUtils.getKerberosStartupState()) {
                        System.setProperty("java.security.krb5.conf", PropertyUtils.getString((String)"java.security.krb5.conf.path"));
                        Configuration configuration = new Configuration();
                        configuration.set("hadoop.security.authentication", "kerberos");
                        UserGroupInformation.setConfiguration((Configuration)configuration);
                        UserGroupInformation.loginUserFromKeytab((String)PropertyUtils.getString((String)"login.user.keytab.username"), (String)PropertyUtils.getString((String)"login.user.keytab.path"));
                    }
                    if (dbType == DbType.HIVE) {
                        datasource = (BaseDataSource)JSON.parseObject((String)parameter, HiveDataSource.class);
                    } else if (dbType == DbType.SPARK) {
                        datasource = (BaseDataSource)JSON.parseObject((String)parameter, SparkDataSource.class);
                    }
                    Class.forName("org.apache.hive.jdbc.HiveDriver");
                    break;
                }
                case CLICKHOUSE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, ClickHouseDataSource.class);
                    Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                    break;
                }
                case ORACLE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, OracleDataSource.class);
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    break;
                }
                case SQLSERVER: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, SQLServerDataSource.class);
                    Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    break;
                }
                case DB2: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, DB2ServerDataSource.class);
                    Class.forName("com.ibm.db2.jcc.DB2Driver");
                    break;
                }
            }
            if (datasource != null) {
                connection = DriverManager.getConnection(datasource.getJdbcUrl(), datasource.getUser(), datasource.getPassword());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return connection;
    }

    public boolean checkConnection(DbType type, String parameter) {
        Boolean isConnection = false;
        Connection con = this.getConnection(type, parameter);
        if (con != null) {
            isConnection = true;
            try {
                con.close();
            }
            catch (SQLException e) {
                logger.error("close connection fail at DataSourceService::checkConnection()", (Throwable)e);
            }
        }
        return isConnection;
    }

    public boolean connectionTest(User loginUser, int id) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        return this.checkConnection(dataSource.getType(), dataSource.getConnectionParams());
    }

    public String buildParameter(String name, String desc, DbType type, String host, String port, String database, String principal, String userName, String password, DbConnectType connectType, String other) {
        this.checkParams(type, port, host, database, other);
        String address = this.buildAddress(type, host, port, connectType);
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>(6);
        String jdbcUrl = address + "/" + database;
        if ("ORACLE".equals(type.name())) {
            parameterMap.put("connectType", connectType);
        }
        if (CommonUtils.getKerberosStartupState() && (type == DbType.HIVE || type == DbType.SPARK)) {
            jdbcUrl = jdbcUrl + ";principal=" + principal;
        }
        String separator = "";
        if ("MYSQL".equals(type.name()) || "POSTGRESQL".equals(type.name()) || "CLICKHOUSE".equals(type.name()) || "ORACLE".equals(type.name())) {
            separator = "&";
        } else if ("HIVE".equals(type.name()) || "SPARK".equals(type.name()) || "DB2".equals(type.name()) || "SQLSERVER".equals(type.name())) {
            separator = ";";
        }
        parameterMap.put("address", address);
        parameterMap.put(DATABASE, database);
        parameterMap.put("jdbcUrl", jdbcUrl);
        parameterMap.put("user", userName);
        parameterMap.put(PASSWORD, password);
        if (CommonUtils.getKerberosStartupState() && (type == DbType.HIVE || type == DbType.SPARK)) {
            parameterMap.put(PRINCIPAL, principal);
        }
        if (other != null && !"".equals(other)) {
            LinkedHashMap map = (LinkedHashMap)JSON.parseObject((String)other, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
            if (type == DbType.MYSQL) {
                map = (LinkedHashMap)MySQLDataSource.buildOtherParams((Map)map);
            }
            if (MapUtils.isNotEmpty((Map)map)) {
                StringBuilder otherSb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    otherSb.append(String.format("%s=%s%s", entry.getKey(), entry.getValue(), separator));
                }
                if (!"DB2".equals(type.name())) {
                    otherSb.deleteCharAt(otherSb.length() - 1);
                }
                parameterMap.put(OTHER, otherSb);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info("parameters map-----" + JSON.toJSONString(parameterMap));
        }
        return JSON.toJSONString(parameterMap);
    }

    private String buildAddress(DbType type, String host, String port, DbConnectType connectType) {
        StringBuilder sb = new StringBuilder();
        if ("MYSQL".equals(type.name())) {
            sb.append("jdbc:mysql://");
            sb.append(host).append(":").append(port);
        } else if ("POSTGRESQL".equals(type.name())) {
            sb.append("jdbc:postgresql://");
            sb.append(host).append(":").append(port);
        } else if ("HIVE".equals(type.name()) || "SPARK".equals(type.name())) {
            sb.append("jdbc:hive2://");
            String[] hostArray = host.split(",");
            if (hostArray.length > 0) {
                for (String zkHost : hostArray) {
                    sb.append(String.format("%s:%s,", zkHost, port));
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        } else if ("CLICKHOUSE".equals(type.name())) {
            sb.append("jdbc:clickhouse://");
            sb.append(host).append(":").append(port);
        } else if ("ORACLE".equals(type.name())) {
            if (connectType == DbConnectType.ORACLE_SID) {
                sb.append("jdbc:oracle:thin:@");
            } else {
                sb.append("jdbc:oracle:thin:@//");
            }
            sb.append(host).append(":").append(port);
        } else if ("SQLSERVER".equals(type.name())) {
            sb.append("jdbc:sqlserver://");
            sb.append(host).append(":").append(port);
        } else if ("DB2".equals(type.name())) {
            sb.append("jdbc:db2://");
            sb.append(host).append(":").append(port);
        }
        return sb.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delete(User loginUser, int datasourceId) {
        Result result = new Result();
        try {
            DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(datasourceId));
            if (dataSource == null) {
                logger.error("resource id {} not exist", (Object)datasourceId);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, dataSource.getUserId())) {
                this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
            this.dataSourceMapper.deleteById((Serializable)Integer.valueOf(datasourceId));
            this.datasourceUserMapper.deleteByDatasourceId(datasourceId);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            logger.error("delete datasource error", (Throwable)e);
            throw new RuntimeException("delete datasource error");
        }
        return result;
    }

    public Map<String, Object> unauthDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        ArrayList resultList = new ArrayList();
        List datasourceList = this.dataSourceMapper.queryDatasourceExceptUserId(userId.intValue());
        HashSet datasourceSet = null;
        if (datasourceList != null && datasourceList.size() > 0) {
            datasourceSet = new HashSet(datasourceList);
            List authedDataSourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
            HashSet authedDataSourceSet = null;
            if (authedDataSourceList != null && authedDataSourceList.size() > 0) {
                authedDataSourceSet = new HashSet(authedDataSourceList);
                datasourceSet.removeAll(authedDataSourceSet);
            }
            resultList = new ArrayList(datasourceSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> authedDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        List authedDatasourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
        result.put("data", authedDatasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private String[] getHostsAndPort(String address) {
        return this.getHostsAndPort(address, "//");
    }

    private String[] getHostsAndPort(String address, String separator) {
        String[] result = new String[2];
        String[] tmpArray = address.split(separator);
        String hostsAndPorts = tmpArray[tmpArray.length - 1];
        StringBuilder hosts = new StringBuilder();
        String[] hostPortArray = hostsAndPorts.split(",");
        String port = hostPortArray[0].split(":")[1];
        for (String hostPort : hostPortArray) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        result[0] = hosts.toString();
        result[1] = port;
        return result;
    }

    private void checkParams(DbType type, String port, String host, String database, String other) {
        if (null == DbType.of((int)type.getCode())) {
            throw new ServiceException(Status.DATASOURCE_DB_TYPE_ILLEGAL);
        }
        if (!DataSourceService.isNumeric(port)) {
            throw new ServiceException(Status.DATASOURCE_PORT_ILLEGAL);
        }
        if (!IPV4_PATTERN.matcher(host).matches() || !IPV6_PATTERN.matcher(host).matches()) {
            throw new ServiceException(Status.DATASOURCE_HOST_ILLEGAL);
        }
        if (!DATABASE_PATTER.matcher(database).matches()) {
            throw new ServiceException(Status.DATASOURCE_NAME_ILLEGAL);
        }
        if (StringUtils.isBlank((String)other)) {
            return;
        }
        Map map = JSONUtils.toMap((String)other);
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        boolean paramsCheck = map.entrySet().stream().allMatch(p -> PARAMS_PATTER.matcher((CharSequence)p.getValue()).matches());
        if (!paramsCheck) {
            throw new ServiceException(Status.DATASOURCE_OTHER_PARAMS_ILLEGAL);
        }
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

