/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"RESOURCES_TAG"}, position=1)
@RestController
@RequestMapping(value={"resources"})
public class ResourcesController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesController.class);
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private UdfFuncService udfFuncService;

    @ApiOperation(value="createDirctory", notes="CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/directory/create"})
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    public Result createDirectory(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        logger.info("login user {}, create resource, type: {}, resource alias: {}, desc: {}, file: {},{}", new Object[]{loginUser.getUserName(), type, alias, description, pid, currentDir});
        return this.resourceService.createDirectory(loginUser, alias, description, type, pid, currentDir);
    }

    @ApiOperation(value="createResource", notes="CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/create"})
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    public Result createResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="file") MultipartFile file, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        logger.info("login user {}, create resource, type: {}, resource alias: {}, desc: {}, file: {},{}", new Object[]{loginUser.getUserName(), type, alias, description, file.getName(), file.getOriginalFilename()});
        return this.resourceService.createResource(loginUser, alias, description, type, file, pid, currentDir);
    }

    @ApiOperation(value="updateResource", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/update"})
    @ApiException(value=Status.UPDATE_RESOURCE_ERROR)
    public Result updateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="file", required=false) MultipartFile file) {
        logger.info("login user {}, update resource, type: {}, resource alias: {}, desc: {}, file: {}", new Object[]{loginUser.getUserName(), type, alias, description, file});
        return this.resourceService.updateResource(loginUser, resourceId, alias, description, type, file);
    }

    @ApiOperation(value="queryResourceList", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType")})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    public Result queryResourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type) {
        logger.info("query resource list, login user:{}, resource type:{}", (Object)loginUser.getUserName(), (Object)type);
        Map<String, Object> result = this.resourceService.queryResourceList(loginUser, type);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryResourceListPaging", notes="QUERY_RESOURCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="int"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_PAGING)
    public Result queryResourceListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="id") int id, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("query resource list, login user:{}, resource type:{}, search value:{}", new Object[]{loginUser.getUserName(), type, searchVal});
        Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataListPaging(result);
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.resourceService.queryResourceListPaging(loginUser, id, type, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="deleteResource", notes="DELETE_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_RESOURCE_ERROR)
    public Result deleteResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId) throws Exception {
        logger.info("login user {}, delete resource id: {}", (Object)loginUser.getUserName(), (Object)resourceId);
        return this.resourceService.delete(loginUser, resourceId);
    }

    @ApiOperation(value="verifyResourceName", notes="VERIFY_RESOURCE_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fullName", value="RESOURCE_FULL_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR)
    public Result verifyResourceName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="type") ResourceType type) {
        logger.info("login user {}, verfiy resource alias: {},resource type: {}", new Object[]{loginUser.getUserName(), fullName, type});
        return this.resourceService.verifyResourceName(fullName, type, loginUser);
    }

    @ApiOperation(value="queryResourceByProgramType", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType")})
    @GetMapping(value={"/list/jar"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    public Result queryResourceJarList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="programType", required=false) ProgramType programType) {
        String programTypeName = programType == null ? "" : programType.name();
        String userName = loginUser.getUserName();
        userName = userName.replaceAll("[\n|\r|\t]", "_");
        logger.info("query resource list, login user:{}, resource type:{}, program type:{}", (Object)userName, (Object)programTypeName);
        Map<String, Object> result = this.resourceService.queryResourceByProgramType(loginUser, type, programType);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryResource", notes="QUERY_BY_RESOURCE_NAME")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fullName", value="RESOURCE_FULL_NAME", required=true, dataType="String")})
    @GetMapping(value={"/queryResource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RESOURCE_NOT_EXIST)
    public Result queryResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName", required=false) String fullName, @RequestParam(value="id", required=false) Integer id, @RequestParam(value="type") ResourceType type) {
        logger.info("login user {}, query resource by full name: {} or id: {},resource type: {}", new Object[]{loginUser.getUserName(), fullName, id, type});
        return this.resourceService.queryResource(fullName, id, type);
    }

    @ApiOperation(value="viewResource", notes="VIEW_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="skipLineNum", value="SKIP_LINE_NUM", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/view"})
    @ApiException(value=Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR)
    public Result viewResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="skipLineNum") int skipLineNum, @RequestParam(value="limit") int limit) {
        logger.info("login user {}, view resource : {}, skipLineNum {} , limit {}", new Object[]{loginUser.getUserName(), resourceId, skipLineNum, limit});
        return this.resourceService.readResource(resourceId, skipLineNum, limit);
    }

    @ApiOperation(value="onlineCreateResource", notes="ONLINE_CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fileName", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="SUFFIX", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String")})
    @PostMapping(value={"/online-create"})
    @ApiException(value=Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR)
    public Result onlineCreateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fileName") String fileName, @RequestParam(value="suffix") String fileSuffix, @RequestParam(value="description", required=false) String description, @RequestParam(value="content") String content, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        logger.info("login user {}, online create resource! fileName : {}, type : {}, suffix : {},desc : {},content : {}", new Object[]{loginUser.getUserName(), fileName, type, fileSuffix, description, content, pid, currentDir});
        if (StringUtils.isEmpty((String)content)) {
            logger.error("resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.onlineCreateResource(loginUser, type, fileName, fileSuffix, description, content, pid, currentDir);
    }

    @ApiOperation(value="updateResourceContent", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String")})
    @PostMapping(value={"/update-content"})
    @ApiException(value=Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR)
    public Result updateResourceContent(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId, @RequestParam(value="content") String content) {
        logger.info("login user {}, updateProcessInstance resource : {}", (Object)loginUser.getUserName(), (Object)resourceId);
        if (StringUtils.isEmpty((String)content)) {
            logger.error("The resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.updateResourceContent(resourceId, content);
    }

    @ApiOperation(value="downloadResource", notes="DOWNLOAD_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/download"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_RESOURCE_FILE_ERROR)
    public ResponseEntity downloadResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int resourceId) throws Exception {
        logger.info("login user {}, download resource : {}", (Object)loginUser.getUserName(), (Object)resourceId);
        Resource file = this.resourceService.downloadResource(resourceId);
        if (file == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.RESOURCE_NOT_EXIST.getMsg());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    @ApiOperation(value="createUdfFunc", notes="CREATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/udf-func/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_UDF_FUNCTION_ERROR)
    public Result createUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @RequestParam(value="resourceId") int resourceId) {
        logger.info("login user {}, create udf function, type: {},  funcName: {},argTypes: {} ,database: {},desc: {},resourceId: {}", new Object[]{loginUser.getUserName(), type, funcName, argTypes, database, description, resourceId});
        return this.udfFuncService.createUdfFunction(loginUser, funcName, className, argTypes, database, description, type, resourceId);
    }

    @ApiOperation(value="viewUIUdfFunction", notes="VIEW_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/udf-func/update-ui"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VIEW_UDF_FUNCTION_ERROR)
    public Result viewUIUdfFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, query udf{}", (Object)loginUser.getUserName(), (Object)id);
        Map<String, Object> map = this.udfFuncService.queryUdfFuncDetail(id);
        return this.returnDataList(map);
    }

    @ApiOperation(value="updateUdfFunc", notes="UPDATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/udf-func/update"})
    @ApiException(value=Status.UPDATE_UDF_FUNCTION_ERROR)
    public Result updateUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int udfFuncId, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @RequestParam(value="resourceId") int resourceId) {
        logger.info("login user {}, updateProcessInstance udf function id: {},type: {},  funcName: {},argTypes: {} ,database: {},desc: {},resourceId: {}", new Object[]{loginUser.getUserName(), udfFuncId, type, funcName, argTypes, database, description, resourceId});
        Map<String, Object> result = this.udfFuncService.updateUdfFunc(udfFuncId, funcName, className, argTypes, database, description, type, resourceId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUdfFuncListPaging", notes="QUERY_UDF_FUNCTION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/udf-func/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR)
    public Result<Object> queryUdfFuncListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("query udf functions list, login user:{},search value:{}", (Object)loginUser.getUserName(), (Object)searchVal);
        Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataListPaging(result);
        }
        result = this.udfFuncService.queryUdfFuncListPaging(loginUser, searchVal, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="queryUdfFuncList", notes="QUERY_UDF_FUNC_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType")})
    @GetMapping(value={"/udf-func/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_BY_TYPE_ERROR)
    public Result<Object> queryUdfFuncList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type) {
        String userName = loginUser.getUserName();
        userName = userName.replaceAll("[\n|\r|\t]", "_");
        logger.info("query udf func list, user:{}, type:{}", (Object)userName, (Object)type);
        Map<String, Object> result = this.udfFuncService.queryUdfFuncList(loginUser, type.ordinal());
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyUdfFuncName", notes="VERIFY_UDF_FUNCTION_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="FUNC_NAME", required=true, dataType="String")})
    @GetMapping(value={"/udf-func/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_UDF_FUNCTION_NAME_ERROR)
    public Result verifyUdfFuncName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        logger.info("login user {}, verfiy udf function name: {}", (Object)loginUser.getUserName(), (Object)name);
        return this.udfFuncService.verifyUdfFuncByName(name);
    }

    @ApiOperation(value="deleteUdfFunc", notes="DELETE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/udf-func/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_UDF_FUNCTION_ERROR)
    public Result deleteUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int udfFuncId) {
        logger.info("login user {}, delete udf function id: {}", (Object)loginUser.getUserName(), (Object)udfFuncId);
        return this.udfFuncService.delete(udfFuncId);
    }

    @ApiOperation(value="authorizedFile", notes="AUTHORIZED_FILE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-file"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZED_FILE_RESOURCE_ERROR)
    public Result authorizedFile(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("authorized file resource, user: {}, user id:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.resourceService.authorizedFile(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authorizeResourceTree", notes="AUTHORIZE_RESOURCE_TREE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authorize-resource-tree"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZE_RESOURCE_TREE)
    public Result authorizeResourceTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("all resource file, user:{}, user id:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.resourceService.authorizeResourceTree(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="unauthUDFFunc", notes="UNAUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/unauth-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UNAUTHORIZED_UDF_FUNCTION_ERROR)
    public Result unauthUDFFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("unauthorized udf function, login user:{}, unauthorized user id:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.resourceService.unauthorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authUDFFunc", notes="AUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZED_UDF_FUNCTION_ERROR)
    public Result authorizedUDFFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        logger.info("auth udf function, login user:{}, auth user id:{}", (Object)loginUser.getUserName(), (Object)userId);
        Map<String, Object> result = this.resourceService.authorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }
}

