/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.ZookeeperMonitor;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkerGroupMapper;
import org.apache.dolphinscheduler.service.zk.ZookeeperCachedOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkerGroupService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(WorkerGroupService.class);
    @Autowired
    WorkerGroupMapper workerGroupMapper;
    @Autowired
    protected ZookeeperCachedOperator zookeeperCachedOperator;
    @Autowired
    private ZookeeperMonitor zookeeperMonitor;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;

    public Map<String, Object> saveWorkerGroup(User loginUser, int id, String name, String addrList) {
        WorkerGroup workerGroup;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        Date now = new Date();
        if (id != 0) {
            workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)Integer.valueOf(id));
            if (workerGroup == null) {
                workerGroup = new WorkerGroup();
                workerGroup.setCreateTime(now);
            }
        } else {
            workerGroup = new WorkerGroup();
            workerGroup.setCreateTime(now);
        }
        workerGroup.setName(name);
        workerGroup.setAddrList(addrList);
        workerGroup.setUpdateTime(now);
        if (this.checkWorkerGroupNameExists(workerGroup)) {
            this.putMsg(result, Status.NAME_EXIST, workerGroup.getName());
            return result;
        }
        String invalidAddr = this.checkWorkerGroupAddrList(workerGroup);
        if (invalidAddr != null) {
            this.putMsg(result, Status.WORKER_ADDRESS_INVALID, invalidAddr);
            return result;
        }
        if (workerGroup.getId() != 0) {
            this.workerGroupMapper.updateById((Object)workerGroup);
        } else {
            this.workerGroupMapper.insert((Object)workerGroup);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkWorkerGroupNameExists(WorkerGroup workerGroup) {
        List workerGroupList = this.workerGroupMapper.queryWorkerGroupByName(workerGroup.getName());
        if (CollectionUtils.isNotEmpty((Collection)workerGroupList)) {
            if (workerGroup.getId() == 0) {
                return true;
            }
            for (WorkerGroup group : workerGroupList) {
                if (group.getId() == workerGroup.getId()) continue;
                return true;
            }
        }
        String workerGroupPath = this.zookeeperCachedOperator.getZookeeperConfig().getDsRoot() + "/nodes/worker" + "/" + workerGroup.getName();
        return this.zookeeperCachedOperator.isExisted(workerGroupPath);
    }

    private String checkWorkerGroupAddrList(WorkerGroup workerGroup) {
        Map serverMaps = this.zookeeperMonitor.getServerMaps(ZKNodeType.WORKER, true);
        for (String addr : workerGroup.getAddrList().split(",")) {
            if (serverMaps.containsKey(addr)) continue;
            return addr;
        }
        return null;
    }

    public Map<String, Object> queryAllGroupPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = (pageNo - 1) * pageSize + pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List<WorkerGroup> workerGroups = this.getWorkerGroups(true);
        List<Object> resultDataList = new ArrayList();
        if (CollectionUtils.isNotEmpty(workerGroups)) {
            List<Object> searchValDataList = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)searchVal)) {
                for (WorkerGroup workerGroup : workerGroups) {
                    if (!workerGroup.getName().contains(searchVal)) continue;
                    searchValDataList.add(workerGroup);
                }
            } else {
                searchValDataList = workerGroups;
            }
            if (fromIndex < searchValDataList.size()) {
                if (toIndex > searchValDataList.size()) {
                    toIndex = searchValDataList.size();
                }
                resultDataList = searchValDataList.subList(fromIndex, toIndex);
            }
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount(resultDataList.size());
        pageInfo.setLists(resultDataList);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> queryAllGroup() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<WorkerGroup> workerGroups = this.getWorkerGroups(false);
        List availableWorkerGroupList = workerGroups.stream().map(WorkerGroup::getName).collect(Collectors.toList());
        int index = availableWorkerGroupList.indexOf("default");
        if (index > -1) {
            availableWorkerGroupList.remove(index);
            availableWorkerGroupList.add(0, "default");
        }
        result.put("data", availableWorkerGroupList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<WorkerGroup> getWorkerGroups(boolean isPaging) {
        List workerGroups = this.workerGroupMapper.queryAllWorkerGroup();
        String workerPath = this.zookeeperCachedOperator.getZookeeperConfig().getDsRoot() + "/nodes/worker";
        List workerGroupList = null;
        try {
            workerGroupList = this.zookeeperCachedOperator.getChildrenKeys(workerPath);
        }
        catch (Exception e) {
            logger.error("getWorkerGroups exception: {}, workerPath: {}, isPaging: {}", new Object[]{e.getMessage(), workerPath, isPaging});
        }
        if (CollectionUtils.isEmpty((Collection)workerGroupList)) {
            if (CollectionUtils.isEmpty((Collection)workerGroups) && !isPaging) {
                WorkerGroup wg = new WorkerGroup();
                wg.setName("default");
                workerGroups.add(wg);
            }
            return workerGroups;
        }
        for (String workerGroup : workerGroupList) {
            String workerGroupPath = workerPath + "/" + workerGroup;
            List childrenNodes = null;
            try {
                childrenNodes = this.zookeeperCachedOperator.getChildrenKeys(workerGroupPath);
            }
            catch (Exception e) {
                logger.error("getChildrenNodes exception: {}, workerGroupPath: {}", (Object)e.getMessage(), (Object)workerGroupPath);
            }
            if (childrenNodes == null || childrenNodes.isEmpty()) continue;
            WorkerGroup wg = new WorkerGroup();
            wg.setName(workerGroup);
            if (isPaging) {
                wg.setAddrList(String.join((CharSequence)",", childrenNodes));
                String registeredValue = this.zookeeperCachedOperator.get(workerGroupPath + "/" + (String)childrenNodes.get(0));
                wg.setCreateTime(DateUtils.stringToDate((String)registeredValue.split(",")[6]));
                wg.setUpdateTime(DateUtils.stringToDate((String)registeredValue.split(",")[7]));
                wg.setSystemDefault(true);
            }
            workerGroups.add(wg);
        }
        return workerGroups;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteWorkerGroupById(User loginUser, Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        WorkerGroup workerGroup = (WorkerGroup)this.workerGroupMapper.selectById((Serializable)id);
        if (workerGroup == null) {
            this.putMsg(result, Status.DELETE_WORKER_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        List processInstances = this.processInstanceMapper.queryByWorkerGroupNameAndStatus(workerGroup.getName(), Constants.NOT_TERMINATED_STATES);
        if (CollectionUtils.isNotEmpty((Collection)processInstances)) {
            this.putMsg(result, Status.DELETE_WORKER_GROUP_BY_ID_FAIL, processInstances.size());
            return result;
        }
        this.workerGroupMapper.deleteById((Serializable)id);
        this.processInstanceMapper.updateProcessInstanceByWorkerGroupName(workerGroup.getName(), "");
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> getWorkerAddressList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List serverNodeList = this.zookeeperMonitor.getServerNodeList(ZKNodeType.WORKER, true);
        result.put("data", serverNodeList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

