/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.common.utils.TaskParametersUtils;

public class CheckUtils {
    private CheckUtils() {
        throw new IllegalStateException("CheckUtils class");
    }

    public static boolean checkUserName(String userName) {
        return CheckUtils.regexChecks(userName, Constants.REGEX_USER_NAME);
    }

    public static boolean checkEmail(String email) {
        if (StringUtils.isEmpty((CharSequence)email)) {
            return false;
        }
        return email.length() > 5 && email.length() <= 40 && CheckUtils.regexChecks(email, Constants.REGEX_MAIL_NAME);
    }

    public static Map<String, Object> checkDesc(String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)desc) && desc.length() > 200) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "desc length"));
        } else {
            result.put("status", (Object)Status.SUCCESS);
        }
        return result;
    }

    public static boolean checkOtherParams(String otherParams) {
        return StringUtils.isNotEmpty((CharSequence)otherParams) && !JSONUtils.checkJsonValid((String)otherParams);
    }

    public static boolean checkPassword(String password) {
        return StringUtils.isNotEmpty((CharSequence)password) && password.length() >= 2 && password.length() <= 20;
    }

    public static boolean checkPhone(String phone) {
        return StringUtils.isEmpty((CharSequence)phone) || phone.length() == 11;
    }

    public static boolean checkTaskNodeParameters(String parameter, String taskType) {
        AbstractParameters abstractParameters = TaskParametersUtils.getParameters((String)taskType, (String)parameter);
        if (abstractParameters != null) {
            return abstractParameters.checkParameters();
        }
        return false;
    }

    public static boolean checkUserParams(String userName, String password, String email, String phone) {
        return CheckUtils.checkUserName(userName) && CheckUtils.checkEmail(email) && CheckUtils.checkPassword(password) && CheckUtils.checkPhone(phone);
    }

    private static boolean regexChecks(String str, Pattern pattern) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return pattern.matcher(str).matches();
    }
}

