/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskRecordService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@RestController
@RequestMapping(value={"/projects/task-record"})
public class TaskRecordController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(TaskRecordController.class);
    @Autowired
    TaskRecordService taskRecordService;

    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_RECORD_LIST_PAGING_ERROR)
    public Result queryTaskRecordListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskName", required=false) String taskName, @RequestParam(value="state", required=false) String state, @RequestParam(value="sourceTable", required=false) String sourceTable, @RequestParam(value="destTable", required=false) String destTable, @RequestParam(value="taskDate", required=false) String taskDate, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("query task record list, task name:{}, state :{}, taskDate: {}, start:{}, end:{}", new Object[]{taskName, state, taskDate, startTime, endTime});
        Map<String, Object> result = this.taskRecordService.queryTaskRecordListPaging(false, taskName, startTime, taskDate, sourceTable, destTable, endTime, state, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }

    @GetMapping(value={"/history-list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_RECORD_LIST_PAGING_ERROR)
    public Result queryHistoryTaskRecordListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskName", required=false) String taskName, @RequestParam(value="state", required=false) String state, @RequestParam(value="sourceTable", required=false) String sourceTable, @RequestParam(value="destTable", required=false) String destTable, @RequestParam(value="taskDate", required=false) String taskDate, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("query hisotry task record list, task name:{}, state :{}, taskDate: {}, start:{}, end:{}", new Object[]{taskName, state, taskDate, startTime, endTime});
        Map<String, Object> result = this.taskRecordService.queryTaskRecordListPaging(true, taskName, startTime, taskDate, sourceTable, destTable, endTime, state, pageNo, pageSize);
        return this.returnDataListPaging(result);
    }
}

