/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.WorkerGroupService;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"WORKER_GROUP_TAG"}, position=1)
@RestController
@RequestMapping(value={"/worker-group"})
public class WorkerGroupController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(WorkerGroupController.class);
    @Autowired
    WorkerGroupService workerGroupService;

    @ApiOperation(value="saveWorkerGroup", notes="CREATE_WORKER_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="WORKER_GROUP_ID", dataType="Int", example="10", defaultValue="0"), @ApiImplicitParam(name="name", value="WORKER_GROUP_NAME", required=true, dataType="String"), @ApiImplicitParam(name="addrList", value="WORKER_ADDR_LIST", required=true, dataType="String")})
    @PostMapping(value={"/save"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SAVE_ERROR)
    public Result saveWorkerGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false, defaultValue="0") int id, @RequestParam(value="name") String name, @RequestParam(value="addrList") String addrList) {
        logger.info("save worker group: login user {}, id:{}, name: {}, addrList: {} ", new Object[]{RegexUtils.escapeNRT(loginUser.getUserName()), id, RegexUtils.escapeNRT(name), RegexUtils.escapeNRT(addrList)});
        Map<String, Object> result = this.workerGroupService.saveWorkerGroup(loginUser, id, name, addrList);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAllWorkerGroupsPaging", notes="QUERY_WORKER_GROUP_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_GROUP_FAIL)
    public Result queryAllWorkerGroupsPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="searchVal", required=false) String searchVal) {
        logger.info("query all worker group paging: login user {}, pageNo:{}, pageSize:{}, searchVal:{}", new Object[]{RegexUtils.escapeNRT(loginUser.getUserName()), pageNo, pageSize, searchVal});
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        Map<String, Object> result = this.workerGroupService.queryAllGroupPaging(loginUser, pageNo, pageSize, searchVal);
        return this.returnDataListPaging(result);
    }

    @ApiOperation(value="queryAllWorkerGroups", notes="QUERY_WORKER_GROUP_LIST_NOTES")
    @GetMapping(value={"/all-groups"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_GROUP_FAIL)
    public Result queryAllWorkerGroups(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("query all worker group: login user {}", (Object)RegexUtils.escapeNRT(loginUser.getUserName()));
        Map<String, Object> result = this.workerGroupService.queryAllGroup();
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteById", notes="DELETE_WORKER_GROUP_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="WORKER_GROUP_ID", required=true, dataType="Int", example="10")})
    @PostMapping(value={"/delete-by-id"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_WORKER_GROUP_FAIL)
    public Result deleteById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") Integer id) {
        logger.info("delete worker group: login user {}, id:{} ", (Object)RegexUtils.escapeNRT(loginUser.getUserName()), (Object)id);
        Map<String, Object> result = this.workerGroupService.deleteWorkerGroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryWorkerAddressList", notes="QUERY_WORKER_ADDRESS_LIST_NOTES")
    @GetMapping(value={"/worker-address-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKER_ADDRESS_LIST_FAIL)
    public Result queryWorkerAddressList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("query worker address list: login user {}", (Object)RegexUtils.escapeNRT(loginUser.getUserName()));
        Map<String, Object> result = this.workerGroupService.getWorkerAddressList();
        return this.returnDataList(result);
    }
}

