/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.dto.resources.filter.IFilter;
import org.apache.dolphinscheduler.dao.entity.Resource;

public class ResourceFilter
implements IFilter {
    private Set<String> suffixs = new HashSet<String>();
    private List<Resource> resourceList;

    public ResourceFilter(String suffix, List<Resource> resourceList) {
        this.suffixs.add(suffix);
        this.resourceList = resourceList;
    }

    public ResourceFilter(Set<String> suffixs, List<Resource> resourceList) {
        this.suffixs = suffixs;
        this.resourceList = resourceList;
    }

    public Set<Resource> fileFilter() {
        Set<Resource> resources = this.resourceList.stream().filter(t -> {
            String alias = t.getAlias();
            boolean result = false;
            for (String suffix : this.suffixs) {
                if (!alias.endsWith(suffix)) continue;
                result = true;
            }
            return result;
        }).collect(Collectors.toSet());
        return resources;
    }

    Set<Resource> listAllParent() {
        HashSet<Resource> parentList = new HashSet<Resource>();
        Set<Resource> filterFileList = this.fileFilter();
        for (Resource file : filterFileList) {
            parentList.add(file);
            this.setAllParent(file, parentList);
        }
        return parentList;
    }

    private void setAllParent(Resource resource, Set<Resource> parentList) {
        for (Resource resourceTemp : this.resourceList) {
            if (resourceTemp.getId() != resource.getPid()) continue;
            parentList.add(resourceTemp);
            this.setAllParent(resourceTemp, parentList);
        }
    }

    @Override
    public List<Resource> filter() {
        return new ArrayList<Resource>(this.listAllParent());
    }
}

