/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.Scanner;
import org.apache.dolphinscheduler.api.utils.FourLetterWordMain;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperState {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperState.class);
    private final String host;
    private final int port;
    private float minLatency = -1.0f;
    private float avgLatency = -1.0f;
    private float maxLatency = -1.0f;
    private long received = -1L;
    private long sent = -1L;
    private int outStanding = -1;
    private long zxid = -1L;
    private String mode = null;
    private int nodeCount = -1;
    private int watches = -1;
    private int connections = -1;
    private boolean healthFlag = false;

    public ZooKeeperState(String connectionString) {
        String host = connectionString.substring(0, connectionString.indexOf(58));
        int port = Integer.parseInt(connectionString.substring(connectionString.indexOf(58) + 1));
        this.host = host;
        this.port = port;
    }

    public void getZookeeperInfo() {
        String consText;
        String line3;
        String wchsText;
        Object line2;
        String content = this.cmd("srvr");
        if (StringUtils.isNotBlank((CharSequence)content)) {
            if ("false".equals(content)) {
                this.healthFlag = true;
            } else {
                try (Scanner scannerForStat = new Scanner(content);){
                    while (scannerForStat.hasNext()) {
                        line2 = scannerForStat.nextLine();
                        if (((String)line2).startsWith("Latency min/avg/max:")) {
                            String[] latencys = this.getStringValueFromLine((String)line2).split("/");
                            this.minLatency = Float.parseFloat(latencys[0]);
                            this.avgLatency = Float.parseFloat(latencys[1]);
                            this.maxLatency = Float.parseFloat(latencys[2]);
                            continue;
                        }
                        if (((String)line2).startsWith("Received:")) {
                            this.received = Long.parseLong(this.getStringValueFromLine((String)line2));
                            continue;
                        }
                        if (((String)line2).startsWith("Sent:")) {
                            this.sent = Long.parseLong(this.getStringValueFromLine((String)line2));
                            continue;
                        }
                        if (((String)line2).startsWith("Outstanding:")) {
                            this.outStanding = Integer.parseInt(this.getStringValueFromLine((String)line2));
                            continue;
                        }
                        if (((String)line2).startsWith("Zxid:")) {
                            this.zxid = Long.parseLong(this.getStringValueFromLine((String)line2).substring(2), 16);
                            continue;
                        }
                        if (((String)line2).startsWith("Mode:")) {
                            this.mode = this.getStringValueFromLine((String)line2);
                            continue;
                        }
                        if (!((String)line2).startsWith("Node count:")) continue;
                        this.nodeCount = Integer.parseInt(this.getStringValueFromLine((String)line2));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(wchsText = this.cmd("wchs")))) {
            if ("false".equals(wchsText)) {
                this.healthFlag = true;
            } else {
                Scanner scannerForWchs = new Scanner(wchsText);
                line2 = null;
                try {
                    while (scannerForWchs.hasNext()) {
                        line3 = scannerForWchs.nextLine();
                        if (!line3.startsWith("Total watches:")) continue;
                        this.watches = Integer.parseInt(this.getStringValueFromLine(line3));
                    }
                }
                catch (Throwable line3) {
                    line2 = line3;
                    throw line3;
                }
                finally {
                    if (scannerForWchs != null) {
                        if (line2 != null) {
                            try {
                                scannerForWchs.close();
                            }
                            catch (Throwable line3) {
                                ((Throwable)line2).addSuppressed(line3);
                            }
                        } else {
                            scannerForWchs.close();
                        }
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(consText = this.cmd("cons")))) {
            if ("false".equals(consText)) {
                this.healthFlag = true;
            } else {
                Scanner scannerForCons = new Scanner(consText);
                if (StringUtils.isNotBlank((CharSequence)consText)) {
                    this.connections = 0;
                }
                while (scannerForCons.hasNext()) {
                    line3 = scannerForCons.nextLine();
                    ++this.connections;
                }
                scannerForCons.close();
            }
        }
    }

    public boolean ruok() {
        return "imok\n".equals(this.cmd("ruok"));
    }

    private String getStringValueFromLine(String line) {
        return line.substring(line.indexOf(":") + 1, line.length()).replaceAll(" ", "").trim();
    }

    private String cmd(String cmd) {
        int waitTimeout = 5;
        SendThread sendThread = new SendThread(cmd);
        sendThread.setName("FourLetterCmd:" + cmd);
        sendThread.start();
        try {
            sendThread.join(5000L);
            return sendThread.ret;
        }
        catch (InterruptedException e) {
            logger.error("send " + cmd + " to server " + this.host + ":" + this.port + " failed!", (Throwable)e);
            return "false";
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public float getMinLatency() {
        return this.minLatency;
    }

    public float getAvgLatency() {
        return this.avgLatency;
    }

    public float getMaxLatency() {
        return this.maxLatency;
    }

    public long getReceived() {
        return this.received;
    }

    public long getSent() {
        return this.sent;
    }

    public int getOutStanding() {
        return this.outStanding;
    }

    public long getZxid() {
        return this.zxid;
    }

    public String getMode() {
        return this.mode;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getWatches() {
        return this.watches;
    }

    public int getConnections() {
        return this.connections;
    }

    public boolean isHealthFlag() {
        return this.healthFlag;
    }

    public String toString() {
        return "ZooKeeperState [host=" + this.host + ", port=" + this.port + ", minLatency=" + this.minLatency + ", avgLatency=" + this.avgLatency + ", maxLatency=" + this.maxLatency + ", received=" + this.received + ", sent=" + this.sent + ", outStanding=" + this.outStanding + ", zxid=" + this.zxid + ", mode=" + this.mode + ", nodeCount=" + this.nodeCount + ", watches=" + this.watches + ", connections=" + this.connections + ",healthFlag=" + this.healthFlag + "]";
    }

    private class SendThread
    extends Thread {
        private String cmd;
        private String ret = "false";

        public SendThread(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public void run() {
            try {
                this.ret = FourLetterWordMain.send4LetterWord(ZooKeeperState.this.host, ZooKeeperState.this.port, this.cmd);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

