/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggerService.class);
    @Autowired
    private ProcessService processService;
    private final LogClientService logClient = new LogClientService();

    @PreDestroy
    public void close() {
        this.logClient.close();
    }

    public Result queryLog(int taskInstId, int skipLineNum, int limit) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            return new Result(Status.TASK_INSTANCE_NOT_FOUND.getCode(), Status.TASK_INSTANCE_NOT_FOUND.getMsg());
        }
        String host = this.getHost(taskInstance.getHost());
        Result<String> result = new Result<String>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg());
        logger.info("log host : {} , logPath : {} , logServer port : {}", new Object[]{host, taskInstance.getLogPath(), 50051});
        String log = this.logClient.rollViewLog(host, 50051, taskInstance.getLogPath(), skipLineNum, limit);
        result.setData(log);
        return result;
    }

    public byte[] getLogBytes(int taskInstId) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            throw new RuntimeException("task instance is null or host is null");
        }
        String host = this.getHost(taskInstance.getHost());
        return this.logClient.getLogBytes(host, 50051, taskInstance.getLogPath());
    }

    private String getHost(String address) {
        if (Host.isOldVersion((String)address).booleanValue()) {
            return address;
        }
        return Host.of((String)address).getIp();
    }
}

