/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_DEFINITION_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/process-definition"})
public class ProcessDefinitionController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionController.class);
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @ApiOperation(value="createProcessDefinition", notes="CREATE_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="locations", value="PROCESS_DEFINITION_LOCATIONS", required=true, type="String"), @ApiImplicitParam(name="description", value="PROCESS_DEFINITION_DESC", required=false, type="String")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="tenantCode", required=true) String tenantCode, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson) {
        Map<String, Object> result = this.processDefinitionService.createProcessDefinition(loginUser, projectCode, name, description, globalParams, locations, timeout, tenantCode, taskRelationJson, taskDefinitionJson);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchCopyByCodes", notes="COPY_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codes", value="PROCESS_DEFINITION_CODES", required=true, dataType="String", example="3,4"), @ApiImplicitParam(name="targetProjectCode", value="TARGET_PROJECT_CODE", required=true, dataType="Long", example="123")})
    @PostMapping(value={"/batch-copy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_COPY_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result copyProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes", required=true) String codes, @RequestParam(value="targetProjectCode", required=true) long targetProjectCode) {
        return this.returnDataList(this.processDefinitionService.batchCopyProcessDefinition(loginUser, projectCode, codes, targetProjectCode));
    }

    @ApiOperation(value="batchMoveByCodes", notes="MOVE_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codes", value="PROCESS_DEFINITION_CODES", required=true, dataType="String", example="3,4"), @ApiImplicitParam(name="targetProjectCode", value="TARGET_PROJECT_CODE", required=true, dataType="Long", example="123")})
    @PostMapping(value={"/batch-move"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_MOVE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result moveProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes", required=true) String codes, @RequestParam(value="targetProjectCode", required=true) long targetProjectCode) {
        return this.returnDataList(this.processDefinitionService.batchMoveProcessDefinition(loginUser, projectCode, codes, targetProjectCode));
    }

    @ApiOperation(value="verify-name", notes="VERIFY_PROCESS_DEFINITION_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_PROCESS_DEFINITION_NAME_UNIQUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyProcessDefinitionName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name) {
        Map<String, Object> result = this.processDefinitionService.verifyProcessDefinitionName(loginUser, projectCode, name);
        return this.returnDataList(result);
    }

    @ApiOperation(value="update", notes="UPDATE_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="123456789"), @ApiImplicitParam(name="locations", value="PROCESS_DEFINITION_LOCATIONS", required=true, type="String"), @ApiImplicitParam(name="description", value="PROCESS_DEFINITION_DESC", required=false, type="String"), @ApiImplicitParam(name="releaseState", value="RELEASE_PROCESS_DEFINITION_NOTES", required=false, dataType="ReleaseState")})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name", required=true) String name, @PathVariable(value="code", required=true) long code, @RequestParam(value="description", required=false) String description, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="tenantCode", required=true) String tenantCode, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson, @RequestParam(value="releaseState", required=false, defaultValue="OFFLINE") ReleaseState releaseState) {
        Map<String, Object> result = this.processDefinitionService.updateProcessDefinition(loginUser, projectCode, name, code, description, globalParams, locations, timeout, tenantCode, taskRelationJson, taskDefinitionJson);
        if (result.get("status") != Status.SUCCESS) {
            return this.returnDataList(result);
        }
        if (releaseState == ReleaseState.ONLINE) {
            result = this.processDefinitionService.releaseProcessDefinition(loginUser, projectCode, code, releaseState);
        }
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryVersions", notes="QUERY_PROCESS_DEFINITION_VERSIONS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="1")})
    @GetMapping(value={"/{code}/versions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_VERSIONS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionVersions(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, @PathVariable(value="code") long code) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        result = this.processDefinitionService.queryProcessDefinitionVersions(loginUser, projectCode, pageNo, pageSize, code);
        return result;
    }

    @ApiOperation(value="switchVersion", notes="SWITCH_PROCESS_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SWITCH_PROCESS_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result switchProcessDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.processDefinitionService.switchProcessDefinitionVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteVersion", notes="DELETE_PROCESS_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteProcessDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.processDefinitionService.deleteProcessDefinitionVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="release", notes="RELEASE_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, type="String"), @ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="123456789"), @ApiImplicitParam(name="releaseState", value="PROCESS_DEFINITION_RELEASE", required=true, dataType="ReleaseState")})
    @PostMapping(value={"/{code}/release"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RELEASE_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result releaseProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code, @RequestParam(value="releaseState", required=true) ReleaseState releaseState) {
        Map<String, Object> result = this.processDefinitionService.releaseProcessDefinition(loginUser, projectCode, code, releaseState);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProcessDefinitionByCode", notes="QUERY_PROCESS_DEFINITION_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="123456789")})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionByCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProcessDefinitionByName", notes="QUERY_PROCESS_DEFINITION_BY_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="PROCESS_DEFINITION_NAME", required=true, dataType="String")})
    @GetMapping(value={"/query-by-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ProcessDefinition> queryProcessDefinitionByName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="name") String name) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionByName(loginUser, projectCode, name);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryList", notes="QUERY_PROCESS_DEFINITION_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryProcessDefinitionList(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryListPaging", notes="QUERY_PROCESS_DEFINITION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", required=false, type="String"), @ApiImplicitParam(name="userId", value="USER_ID", required=false, dataType="Int", example="100"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessDefinitionListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="userId", required=false, defaultValue="0") Integer userId, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.processDefinitionService.queryProcessDefinitionListPaging(loginUser, projectCode, searchVal, userId, pageNo, pageSize);
    }

    @ApiOperation(value="viewTree", notes="VIEW_TREE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{code}/view-tree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ENCAPSULATION_TREEVIEW_STRUCTURE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result viewTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="limit") Integer limit) {
        Map<String, Object> result = this.processDefinitionService.viewTree(code, limit);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getTasksByDefinitionCode", notes="GET_TASK_LIST_BY_DEFINITION_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="100")})
    @GetMapping(value={"/{code}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getNodeListByDefinitionCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.processDefinitionService.getTaskNodeListByDefinitionCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getTaskListByDefinitionCodes", notes="GET_TASK_LIST_BY_DEFINITION_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codes", value="PROCESS_DEFINITION_CODES", required=true, type="String", example="100,200,300")})
    @GetMapping(value={"/batch-query-tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_TASKS_LIST_BY_PROCESS_DEFINITION_ID_ERROR)
    public Result getNodeListMapByDefinitionCodes(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes) {
        Map<String, Object> result = this.processDefinitionService.getNodeListMapByDefinitionCodes(loginUser, projectCode, codes);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteByCode", notes="DELETE_PROCESS_DEFINITION_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROCESS_DEFINITION_CODE", dataType="Int", example="100")})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteProcessDefinitionByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.processDefinitionService.deleteProcessDefinitionByCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchDeleteByCodes", notes="BATCH_DELETE_PROCESS_DEFINITION_BY_IDS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codes", value="PROCESS_DEFINITION_CODE", required=true, dataType="String")})
    @PostMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_DELETE_PROCESS_DEFINE_BY_CODES_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchDeleteProcessDefinitionByCodes(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deleteFailedCodeList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)codes)) {
            String[] processDefinitionCodeArray;
            for (String strProcessDefinitionCode : processDefinitionCodeArray = codes.split(",")) {
                long code = Long.parseLong(strProcessDefinitionCode);
                try {
                    Map<String, Object> deleteResult = this.processDefinitionService.deleteProcessDefinitionByCode(loginUser, projectCode, code);
                    if (Status.SUCCESS.equals(deleteResult.get("status"))) continue;
                    deleteFailedCodeList.add(strProcessDefinitionCode);
                    logger.error((String)deleteResult.get("msg"));
                }
                catch (Exception e) {
                    deleteFailedCodeList.add(strProcessDefinitionCode);
                }
            }
        }
        if (!deleteFailedCodeList.isEmpty()) {
            this.putMsg(result, Status.BATCH_DELETE_PROCESS_DEFINE_BY_CODES_ERROR, String.join((CharSequence)",", deleteFailedCodeList));
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchExportByCodes", notes="BATCH_EXPORT_PROCESS_DEFINITION_BY_CODES_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codes", value="PROCESS_DEFINITION_CODE", required=true, dataType="String")})
    @PostMapping(value={"/batch-export"})
    @ResponseBody
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "response"})
    public void batchExportProcessDefinitionByCodes(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="codes") String codes, HttpServletResponse response) {
        try {
            this.processDefinitionService.batchExportProcessDefinitionByCodes(loginUser, projectCode, codes, response);
        }
        catch (Exception e) {
            logger.error(Status.BATCH_EXPORT_PROCESS_DEFINE_BY_IDS_ERROR.getMsg(), (Throwable)e);
        }
    }

    @ApiOperation(value="queryAllByProjectCode", notes="QUERY_PROCESS_DEFINITION_All_BY_PROJECT_CODE_NOTES")
    @GetMapping(value={"/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllProcessDefinitionByProjectCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.processDefinitionService.queryAllProcessDefinitionByProjectCode(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="importProcessDefinition", notes="IMPORT_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PostMapping(value={"/import"})
    @ApiException(value=Status.IMPORT_PROCESS_DEFINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "file"})
    public Result importProcessDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="file") MultipartFile file) {
        Map<String, Object> result = this.processDefinitionService.importProcessDefinition(loginUser, projectCode, file);
        return this.returnDataList(result);
    }
}

