/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"USERS_TAG"})
@RestController
@RequestMapping(value={"/users"})
public class UsersController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(UsersController.class);
    @Autowired
    private UsersService usersService;

    @ApiOperation(value="createUser", notes="CREATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", required=true, type="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", required=true, type="String"), @ApiImplicitParam(name="tenantId", value="TENANT_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="queue", value="QUEUE", dataType="String"), @ApiImplicitParam(name="email", value="EMAIL", required=true, dataType="String"), @ApiImplicitParam(name="phone", value="PHONE", dataType="String"), @ApiImplicitParam(name="state", value="STATE", dataType="Int", example="1")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "userPassword"})
    public Result createUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="state", required=false) int state) throws Exception {
        Map<String, Object> result = this.usersService.createUser(loginUser, userName, userPassword, email, tenantId, phone, queue, state);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUserList", notes="QUERY_USER_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_USER_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUserList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="searchVal", required=false) String searchVal) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.usersService.queryUserList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="updateUser", notes="UPDATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="USER_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="userName", value="USER_NAME", required=true, type="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", required=true, type="String"), @ApiImplicitParam(name="tenantId", value="TENANT_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="queue", value="QUEUE", dataType="String"), @ApiImplicitParam(name="email", value="EMAIL", required=true, dataType="String"), @ApiImplicitParam(name="phone", value="PHONE", dataType="String"), @ApiImplicitParam(name="state", value="STATE", dataType="Int", example="1")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser", "userPassword"})
    public Result updateUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="queue", required=false, defaultValue="") String queue, @RequestParam(value="email") String email, @RequestParam(value="tenantId") int tenantId, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="state", required=false) int state) throws Exception {
        Map<String, Object> result = this.usersService.updateUser(loginUser, id, userName, userPassword, email, tenantId, phone, queue, state);
        return this.returnDataList(result);
    }

    @ApiOperation(value="delUserById", notes="DELETE_USER_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="USER_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_USER_BY_ID_ERROR)
    @AccessLogAnnotation
    public Result delUserById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) throws Exception {
        Map<String, Object> result = this.usersService.deleteUserById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="grantProject", notes="GRANT_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="projectIds", value="PROJECT_IDS", required=true, type="String")})
    @PostMapping(value={"/grant-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_PROJECT_ERROR)
    @AccessLogAnnotation
    public Result grantProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="projectIds") String projectIds) {
        Map<String, Object> result = this.usersService.grantProject(loginUser, userId, projectIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="grantResource", notes="GRANT_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="resourceIds", value="RESOURCE_IDS", required=true, type="String")})
    @PostMapping(value={"/grant-file"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_RESOURCE_ERROR)
    @AccessLogAnnotation
    public Result grantResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="resourceIds") String resourceIds) {
        Map<String, Object> result = this.usersService.grantResources(loginUser, userId, resourceIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="grantUDFFunc", notes="GRANT_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="udfIds", value="UDF_IDS", required=true, type="String")})
    @PostMapping(value={"/grant-udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation
    public Result grantUDFFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="udfIds") String udfIds) {
        Map<String, Object> result = this.usersService.grantUDFFunction(loginUser, userId, udfIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="grantDataSource", notes="GRANT_DATASOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="datasourceIds", value="DATASOURCE_IDS", required=true, type="String")})
    @PostMapping(value={"/grant-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GRANT_DATASOURCE_ERROR)
    @AccessLogAnnotation
    public Result grantDataSource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") int userId, @RequestParam(value="datasourceIds") String datasourceIds) {
        Map<String, Object> result = this.usersService.grantDataSource(loginUser, userId, datasourceIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getUserInfo", notes="GET_USER_INFO_NOTES")
    @GetMapping(value={"/get-user-info"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_USER_INFO_ERROR)
    @AccessLogAnnotation
    public Result getUserInfo(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.getUserInfo(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="listUser", notes="LIST_USER_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.USER_LIST_ERROR)
    @AccessLogAnnotation
    public Result listUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.queryAllGeneralUsers(loginUser);
        return this.returnDataList(result);
    }

    @GetMapping(value={"/list-all"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.USER_LIST_ERROR)
    @AccessLogAnnotation
    public Result listAll(@RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.usersService.queryUserList(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyUserName", notes="VERIFY_USER_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", required=true, type="String")})
    @GetMapping(value={"/verify-user-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_USERNAME_ERROR)
    @AccessLogAnnotation
    public Result verifyUserName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName) {
        return this.usersService.verifyUserName(userName);
    }

    @ApiOperation(value="unauthorizedUser", notes="UNAUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertgroupId", value="ALERT_GROUP_ID", required=true, type="String")})
    @GetMapping(value={"/unauth-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UNAUTHORIZED_USER_ERROR)
    @AccessLogAnnotation
    public Result unauthorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        Map<String, Object> result = this.usersService.unauthorizedUser(loginUser, alertgroupId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authorizedUser", notes="AUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertgroupId", value="ALERT_GROUP_ID", required=true, type="String")})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.AUTHORIZED_USER_ERROR)
    @AccessLogAnnotation
    public Result authorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") Integer alertgroupId) {
        try {
            Map<String, Object> result = this.usersService.authorizedUser(loginUser, alertgroupId);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.AUTHORIZED_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.AUTHORIZED_USER_ERROR.getCode(), Status.AUTHORIZED_USER_ERROR.getMsg());
        }
    }

    @ApiOperation(value="registerUser", notes="REGISTER_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", required=true, type="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", required=true, type="String"), @ApiImplicitParam(name="repeatPassword", value="REPEAT_PASSWORD", required=true, type="String"), @ApiImplicitParam(name="email", value="EMAIL", required=true, type="String")})
    @PostMapping(value={"/register"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CREATE_USER_ERROR)
    @AccessLogAnnotation
    public Result<Object> registerUser(@RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, @RequestParam(value="repeatPassword") String repeatPassword, @RequestParam(value="email") String email) throws Exception {
        userName = ParameterUtils.handleEscapes((String)userName);
        userPassword = ParameterUtils.handleEscapes((String)userPassword);
        repeatPassword = ParameterUtils.handleEscapes((String)repeatPassword);
        email = ParameterUtils.handleEscapes((String)email);
        Map<String, Object> result = this.usersService.registerUser(userName, userPassword, repeatPassword, email);
        return this.returnDataList(result);
    }

    @ApiOperation(value="activateUser", notes="ACTIVATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", type="String")})
    @PostMapping(value={"/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    @AccessLogAnnotation
    public Result<Object> activateUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userName") String userName) {
        userName = ParameterUtils.handleEscapes((String)userName);
        Map<String, Object> result = this.usersService.activateUser(loginUser, userName);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchActivateUser", notes="BATCH_ACTIVATE_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userNames", value="USER_NAMES", required=true, type="String")})
    @PostMapping(value={"/batch/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_USER_ERROR)
    @AccessLogAnnotation
    public Result<Object> batchActivateUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestBody List<String> userNames) {
        List<String> formatUserNames = userNames.stream().map(ParameterUtils::handleEscapes).collect(Collectors.toList());
        Map<String, Object> result = this.usersService.batchActivateUser(loginUser, formatUserNames);
        return this.returnDataList(result);
    }
}

