/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.QueueMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueServiceImpl
extends BaseServiceImpl
implements QueueService {
    private static final Logger logger = LoggerFactory.getLogger(QueueServiceImpl.class);
    @Autowired
    private QueueMapper queueMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public Map<String, Object> queryList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List queueList = this.queueMapper.selectList(null);
        result.put("data", queueList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage queueList = this.queueMapper.queryQueuePaging((IPage)page, searchVal);
        Integer count = (int)queueList.getTotal();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal(count);
        pageInfo.setTotalList(queueList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> createQueue(User loginUser, String queue, String queueName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.isEmpty((String)queue)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
            return result;
        }
        if (StringUtils.isEmpty((String)queueName)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
            return result;
        }
        if (this.checkQueueNameExist(queueName)) {
            this.putMsg(result, Status.QUEUE_NAME_EXIST, queueName);
            return result;
        }
        if (this.checkQueueExist(queue)) {
            this.putMsg(result, Status.QUEUE_VALUE_EXIST, queue);
            return result;
        }
        Queue queueObj = new Queue();
        Date now = new Date();
        queueObj.setQueue(queue);
        queueObj.setQueueName(queueName);
        queueObj.setCreateTime(now);
        queueObj.setUpdateTime(now);
        this.queueMapper.insert((Object)queueObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateQueue(User loginUser, int id, String queue, String queueName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.isEmpty((String)queue)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
            return result;
        }
        if (StringUtils.isEmpty((String)queueName)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
            return result;
        }
        Queue queueObj = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        if (queueObj == null) {
            this.putMsg(result, Status.QUEUE_NOT_EXIST, id);
            return result;
        }
        if (queue.equals(queueObj.getQueue()) && queueName.equals(queueObj.getQueueName())) {
            this.putMsg(result, Status.NEED_NOT_UPDATE_QUEUE, new Object[0]);
            return result;
        }
        if (!queueName.equals(queueObj.getQueueName()) && this.checkQueueNameExist(queueName)) {
            this.putMsg(result, Status.QUEUE_NAME_EXIST, queueName);
            return result;
        }
        if (!queue.equals(queueObj.getQueue()) && this.checkQueueExist(queue)) {
            this.putMsg(result, Status.QUEUE_VALUE_EXIST, queue);
            return result;
        }
        if (this.checkIfQueueIsInUsing(queueObj.getQueueName(), queueName)) {
            Integer relatedUserNums = this.userMapper.updateUserQueue(queueObj.getQueueName(), queueName);
            logger.info("old queue have related {} user, exec update user success.", (Object)relatedUserNums);
        }
        Date now = new Date();
        queueObj.setQueue(queue);
        queueObj.setQueueName(queueName);
        queueObj.setUpdateTime(now);
        this.queueMapper.updateById((Object)queueObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyQueue(String queue, String queueName) {
        Result<Object> result = new Result<Object>();
        if (StringUtils.isEmpty((String)queue)) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"queue"});
            return result;
        }
        if (StringUtils.isEmpty((String)queueName)) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"queueName"});
            return result;
        }
        if (this.checkQueueNameExist(queueName)) {
            this.putMsg((Result)result, Status.QUEUE_NAME_EXIST, new Object[]{queueName});
            return result;
        }
        if (this.checkQueueExist(queue)) {
            this.putMsg((Result)result, Status.QUEUE_VALUE_EXIST, new Object[]{queue});
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkQueueExist(String queue) {
        return this.queueMapper.existQueue(queue, null) == Boolean.TRUE;
    }

    private boolean checkQueueNameExist(String queueName) {
        return this.queueMapper.existQueue(null, queueName) == Boolean.TRUE;
    }

    private boolean checkIfQueueIsInUsing(String oldQueue, String newQueue) {
        return !oldQueue.equals(newQueue) && this.userMapper.existUser(oldQueue) == Boolean.TRUE;
    }
}

