/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectServiceImpl
extends BaseServiceImpl
implements ProjectService {
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public Map<String, Object> createProject(User loginUser, String name, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> descCheck = CheckUtils.checkDesc(desc);
        if (descCheck.get("status") != Status.SUCCESS) {
            return descCheck;
        }
        Project project = this.projectMapper.queryByName(name);
        if (project != null) {
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, name);
            return result;
        }
        Date now = new Date();
        try {
            project = Project.newBuilder().name(name).code(CodeGenerateUtils.getInstance().genCode()).description(desc).userId(loginUser.getId()).userName(loginUser.getUserName()).createTime(now).updateTime(now).build();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            this.putMsg(result, Status.CREATE_PROJECT_ERROR, new Object[0]);
            return result;
        }
        if (this.projectMapper.insert((Object)project) > 0) {
            result.put("data", project.getId());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryByCode(User loginUser, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        if (project != null) {
            result.put("data", project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> checkProjectAndAuth(User loginUser, Project project, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
        } else if (!this.checkReadPermission(loginUser, project)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), projectCode);
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public boolean hasProjectAndPerm(User loginUser, Project project, Map<String, Object> result) {
        boolean checkResult = false;
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, "");
        } else if (!this.checkReadPermission(loginUser, project)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), project.getCode());
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    @Override
    public boolean hasProjectAndPerm(User loginUser, Project project, Result result) {
        boolean checkResult = false;
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, new Object[]{""});
        } else if (!this.checkReadPermission(loginUser, project)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, new Object[]{loginUser.getUserName(), project.getName()});
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    @Override
    public Result queryProjectListPaging(User loginUser, Integer pageSize, Integer pageNo, String searchVal) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getUserType() == UserType.ADMIN_USER ? 0 : loginUser.getId();
        IPage projectIPage = this.projectMapper.queryProjectListPaging((IPage)page, userId, searchVal);
        List projectList = projectIPage.getRecords();
        if (userId != 0) {
            for (Project project : projectList) {
                project.setPerm(7);
            }
        }
        pageInfo.setTotal((int)projectIPage.getTotal());
        pageInfo.setTotalList(projectList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteProject(User loginUser, Long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        Map<String, Object> checkResult = this.getCheckResult(loginUser, project);
        if (checkResult != null) {
            return checkResult;
        }
        if (!this.hasPerm(loginUser, project.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        List processDefinitionList = this.processDefinitionMapper.queryAllDefinitionList(project.getCode());
        if (!processDefinitionList.isEmpty()) {
            this.putMsg(result, Status.DELETE_PROJECT_ERROR_DEFINES_NOT_NULL, new Object[0]);
            return result;
        }
        int delete = this.projectMapper.deleteById((Serializable)Integer.valueOf(project.getId()));
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    private Map<String, Object> getCheckResult(User loginUser, Project project) {
        Map<String, Object> checkResult = this.checkProjectAndAuth(loginUser, project, project == null ? 0L : project.getCode());
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        return null;
    }

    @Override
    public Map<String, Object> update(User loginUser, Long projectCode, String projectName, String desc, String userName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> descCheck = CheckUtils.checkDesc(desc);
        if (descCheck.get("status") != Status.SUCCESS) {
            return descCheck;
        }
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Project tempProject = this.projectMapper.queryByName(projectName);
        if (tempProject != null && tempProject.getCode() != project.getCode()) {
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, projectName);
            return result;
        }
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userName);
            return result;
        }
        project.setName(projectName);
        project.setDescription(desc);
        project.setUpdateTime(new Date());
        project.setUserId(user.getId());
        int update = this.projectMapper.updateById((Object)project);
        if (update > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryUnauthorizedProject(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginUser.getId() != userId.intValue() && this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List projectList = this.projectMapper.queryProjectExceptUserId(userId.intValue());
        List<Object> resultList = new ArrayList();
        if (projectList != null && !projectList.isEmpty()) {
            HashSet<Project> projectSet = new HashSet<Project>(projectList);
            List authedProjectList = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
            resultList = this.getUnauthorizedProjects(projectSet, authedProjectList);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<Project> getUnauthorizedProjects(Set<Project> projectSet, List<Project> authedProjectList) {
        if (authedProjectList != null && !authedProjectList.isEmpty()) {
            HashSet<Project> authedProjectSet = new HashSet<Project>(authedProjectList);
            projectSet.removeAll(authedProjectSet);
        }
        ArrayList<Project> resultList = new ArrayList<Project>(projectSet);
        return resultList;
    }

    @Override
    public Map<String, Object> queryAuthorizedProject(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginUser.getId() != userId.intValue() && this.isNotAdmin(loginUser, result)) {
            return result;
        }
        List projects = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProjectCreatedByUser(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = this.projectMapper.queryProjectCreatedByUser(loginUser.getId());
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProjectCreatedAndAuthorizedByUser(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = null;
        projects = loginUser.getUserType() == UserType.ADMIN_USER ? this.projectMapper.selectList(null) : this.projectMapper.queryProjectCreatedAndAuthorizedByUserId(loginUser.getId());
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkReadPermission(User user, Project project) {
        int permissionId = this.queryPermission(user, project);
        return (permissionId & 2) != 0;
    }

    private int queryPermission(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN_USER) {
            return 2;
        }
        if (project.getUserId() == user.getId()) {
            return 7;
        }
        ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId(), user.getId());
        if (projectUser == null) {
            return 0;
        }
        return projectUser.getPerm();
    }

    @Override
    public Map<String, Object> queryAllProjectList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = this.projectMapper.queryAllProject();
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

