/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerServiceImpl
implements LoggerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServiceImpl.class);
    private static final String LOG_HEAD_FORMAT = "[LOG-PATH]: %s, [HOST]:  %s%s";
    @Autowired
    private ProcessService processService;
    private LogClientService logClient;

    @PostConstruct
    public void init() {
        if (Objects.isNull(this.logClient)) {
            this.logClient = new LogClientService();
        }
    }

    @PreDestroy
    public void close() {
        if (Objects.nonNull(this.logClient) && this.logClient.isRunning()) {
            this.logClient.close();
        }
    }

    @Override
    public Result<String> queryLog(int taskInstId, int skipLineNum, int limit) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((String)taskInstance.getHost())) {
            return Result.error(Status.TASK_INSTANCE_NOT_FOUND);
        }
        String host = this.getHost(taskInstance.getHost());
        Result<String> result = new Result<String>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg());
        logger.info("log host : {} , logPath : {} , logServer port : {}", new Object[]{host, taskInstance.getLogPath(), 50051});
        StringBuilder log = new StringBuilder();
        if (skipLineNum == 0) {
            String head = String.format(LOG_HEAD_FORMAT, taskInstance.getLogPath(), host, Constants.SYSTEM_LINE_SEPARATOR);
            log.append(head);
        }
        log.append(this.logClient.rollViewLog(host, 50051, taskInstance.getLogPath(), skipLineNum, limit));
        result.setData(log.toString());
        return result;
    }

    @Override
    public byte[] getLogBytes(int taskInstId) {
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((String)taskInstance.getHost())) {
            throw new ServiceException("task instance is null or host is null");
        }
        String host = this.getHost(taskInstance.getHost());
        byte[] head = String.format(LOG_HEAD_FORMAT, taskInstance.getLogPath(), host, Constants.SYSTEM_LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8);
        return Bytes.concat((byte[][])new byte[][]{head, this.logClient.getLogBytes(host, 50051, taskInstance.getLogPath())});
    }

    private String getHost(String address) {
        if (Boolean.TRUE.equals(Host.isOldVersion((String)address))) {
            return address;
        }
        return Host.of((String)address).getIp();
    }
}

