/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.UiPluginService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"UI_PLUGINS_TAG"})
@RestController
@RequestMapping(value={"ui-plugins"})
public class UiPluginController
extends BaseController {
    @Autowired
    UiPluginService uiPluginService;

    @ApiOperation(value="queryUiPluginsByType", notes="QUERY_UI_PLUGINS_BY_TYPE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pluginType", value="pluginType", required=true, dataType="PluginType")})
    @GetMapping(value={"/query-by-type"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.QUERY_PLUGINS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUiPluginsByType(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginType") PluginType pluginType) {
        Map<String, Object> result = this.uiPluginService.queryUiPluginsByType(pluginType);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUiPluginDetailById", notes="QUERY_UI_PLUGIN_DETAIL_BY_ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PLUGIN_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.QUERY_PLUGINS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUiPluginDetailById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer pluginId) {
        Map<String, Object> result = this.uiPluginService.queryUiPluginDetailById(pluginId);
        return this.returnDataList(result);
    }
}

