/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"QUEUE_TAG"})
@RestController
@RequestMapping(value={"/queues"})
public class QueueController
extends BaseController {
    @Autowired
    private QueueService queueService;

    @ApiOperation(value="queryList", notes="QUERY_QUEUE_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.queueService.queryList(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryQueueListPaging", notes="QUERY_QUEUE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryQueueListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.queueService.queryList(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="createQueue", notes="CREATE_QUEUE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queue", value="YARN_QUEUE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="queueName", value="QUEUE_NAME", required=true, dataType="String")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createQueue(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        Map<String, Object> result = this.queueService.createQueue(loginUser, queue, queueName);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateQueue", notes="UPDATE_QUEUE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="QUEUE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="queue", value="YARN_QUEUE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="queueName", value="QUEUE_NAME", required=true, dataType="String")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateQueue(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        Map<String, Object> result = this.queueService.updateQueue(loginUser, id, queue, queueName);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyQueue", notes="VERIFY_QUEUE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queue", value="YARN_QUEUE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="queueName", value="QUEUE_NAME", required=true, dataType="String")})
    @PostMapping(value={"/verify"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_QUEUE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyQueue(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queue") String queue, @RequestParam(value="queueName") String queueName) {
        return this.queueService.verifyQueue(queue, queueName);
    }
}

