/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.dao.entity.Session;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.SessionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.WebUtils;

@Service
public class SessionServiceImpl
extends BaseServiceImpl
implements SessionService {
    private static final Logger logger = LoggerFactory.getLogger(SessionService.class);
    @Autowired
    private SessionMapper sessionMapper;

    @Override
    public Session getSession(HttpServletRequest request) {
        Cookie cookie;
        String sessionId = request.getHeader("sessionId");
        if (StringUtils.isBlank((String)sessionId) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"sessionId")) != null) {
            sessionId = cookie.getValue();
        }
        if (StringUtils.isBlank((String)sessionId)) {
            return null;
        }
        String ip = BaseController.getClientIpAddress(request);
        logger.debug("get session: {}, ip: {}", (Object)sessionId, (Object)ip);
        return (Session)this.sessionMapper.selectById((Serializable)((Object)sessionId));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public String createSession(User user, String ip) {
        Session session = null;
        List sessionList = this.sessionMapper.queryByUserId(user.getId());
        Date now = new Date();
        if (CollectionUtils.isNotEmpty((Collection)sessionList)) {
            if (sessionList.size() > 1) {
                for (int i = 1; i < sessionList.size(); ++i) {
                    this.sessionMapper.deleteById((Serializable)((Object)((Session)sessionList.get(i)).getId()));
                }
            }
            session = (Session)sessionList.get(0);
            if (now.getTime() - session.getLastLoginTime().getTime() <= 0x6DDD00L) {
                session.setLastLoginTime(now);
                this.sessionMapper.updateById((Object)session);
                return session.getId();
            }
            this.sessionMapper.deleteById((Serializable)((Object)session.getId()));
        }
        session = new Session();
        session.setId(UUID.randomUUID().toString());
        session.setIp(ip);
        session.setUserId(user.getId());
        session.setLastLoginTime(now);
        this.sessionMapper.insert((Object)session);
        return session.getId();
    }

    @Override
    public void signOut(String ip, User loginUser) {
        try {
            Session session = this.sessionMapper.queryByUserIdAndIp(loginUser.getId(), ip);
            this.sessionMapper.deleteById((Serializable)((Object)session.getId()));
        }
        catch (Exception e) {
            logger.warn("userId : {} , ip : {} , find more one session", (Object)loginUser.getId(), (Object)ip);
        }
    }
}

