/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DatasourceUtil;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceServiceImpl
extends BaseServiceImpl
implements DataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;

    @Override
    public Result<Object> createDataSource(User loginUser, BaseDataSourceParamDTO datasourceParam) {
        DatasourceUtil.checkDatasourceParam((BaseDataSourceParamDTO)datasourceParam);
        Result<Object> result = new Result<Object>();
        if (this.checkName(datasourceParam.getName())) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        ConnectionParam connectionParam = DatasourceUtil.buildConnectionParams((BaseDataSourceParamDTO)datasourceParam);
        Result<Object> isConnection = this.checkConnection(datasourceParam.getType(), connectionParam);
        if (Status.SUCCESS.getCode() != isConnection.getCode().intValue()) {
            this.putMsg((Result)result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
            return result;
        }
        DataSource dataSource = new DataSource();
        Date now = new Date();
        dataSource.setName(datasourceParam.getName().trim());
        dataSource.setNote(datasourceParam.getNote());
        dataSource.setUserId(loginUser.getId());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(datasourceParam.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setCreateTime(now);
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.insert((Object)dataSource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            logger.error("Create datasource error.", (Throwable)ex);
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> updateDataSource(int id, User loginUser, BaseDataSourceParamDTO dataSourceParam) {
        Result<Object> isConnection;
        DatasourceUtil.checkDatasourceParam((BaseDataSourceParamDTO)dataSourceParam);
        Result<Object> result = new Result<Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, dataSource.getUserId())) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!dataSource.getName().trim().equals(dataSource.getName()) && this.checkName(dataSource.getName())) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        BaseConnectionParam connectionParam = (BaseConnectionParam)DatasourceUtil.buildConnectionParams((BaseDataSourceParamDTO)dataSourceParam);
        String password = connectionParam.getPassword();
        if (StringUtils.isBlank((String)password)) {
            String oldConnectionParams = dataSource.getConnectionParams();
            ObjectNode oldParams = JSONUtils.parseObject((String)oldConnectionParams);
            connectionParam.setPassword(oldParams.path("password").asText());
        }
        if ((isConnection = this.checkConnection(dataSource.getType(), (ConnectionParam)connectionParam)).isFailed()) {
            return isConnection;
        }
        Date now = new Date();
        dataSource.setName(dataSourceParam.getName().trim());
        dataSource.setNote(dataSourceParam.getNote());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(dataSource.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.updateById((Object)dataSource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            logger.error("Update datasource error.", (Throwable)ex);
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    private boolean checkName(String name) {
        List queryDataSource = this.dataSourceMapper.queryDataSourceByName(name.trim());
        return queryDataSource != null && !queryDataSource.isEmpty();
    }

    @Override
    public Map<String, Object> queryDataSource(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        BaseDataSourceParamDTO baseDataSourceParamDTO = DatasourceUtil.buildDatasourceParamDTO((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        baseDataSourceParamDTO.setId(Integer.valueOf(dataSource.getId()));
        baseDataSourceParamDTO.setName(dataSource.getName());
        baseDataSourceParamDTO.setNote(dataSource.getNote());
        result.put("data", baseDataSourceParamDTO);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryDataSourceListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Page dataSourcePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage dataSourceList = this.isAdmin(loginUser) ? this.dataSourceMapper.selectPaging((IPage)dataSourcePage, 0, searchVal) : this.dataSourceMapper.selectPaging((IPage)dataSourcePage, loginUser.getId(), searchVal);
        List dataSources = dataSourceList != null ? dataSourceList.getRecords() : new ArrayList();
        this.handlePasswd(dataSources);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)(dataSourceList != null ? dataSourceList.getTotal() : 0L));
        pageInfo.setTotalList(dataSources);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void handlePasswd(List<DataSource> dataSourceList) {
        for (DataSource dataSource : dataSourceList) {
            String connectionParams = dataSource.getConnectionParams();
            ObjectNode object = JSONUtils.parseObject((String)connectionParams);
            object.put("password", this.getHiddenPassword());
            dataSource.setConnectionParams(object.toString());
        }
    }

    private String getHiddenPassword() {
        return "******";
    }

    @Override
    public Map<String, Object> queryDataSourceList(User loginUser, Integer type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List datasourceList = this.isAdmin(loginUser) ? this.dataSourceMapper.listAllDataSourceByType(type) : this.dataSourceMapper.queryDataSourceByType(loginUser.getId(), type);
        result.put("data", datasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyDataSourceName(String name) {
        Result<Object> result = new Result<Object>();
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(name);
        if (dataSourceList != null && !dataSourceList.isEmpty()) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result<Object> checkConnection(DbType type, ConnectionParam connectionParam) {
        Result<Object> result2 = new Result<Object>();
        try (Connection connection = DataSourceClientProvider.getInstance().getConnection(type, connectionParam);){
            if (connection == null) {
                this.putMsg((Result)result2, Status.CONNECTION_TEST_FAILURE, new Object[0]);
                Result<Object> result3 = result2;
                return result3;
            }
            this.putMsg((Result)result2, Status.SUCCESS, new Object[0]);
            Result<Object> result = result2;
            return result;
        }
        catch (Exception e) {
            logger.error("datasource test connection error, dbType:{}, connectionParam:{}, message:{}.", new Object[]{type, connectionParam, e.getMessage()});
            return new Result<Object>(Status.CONNECTION_TEST_FAILURE.getCode(), e.getMessage());
        }
    }

    @Override
    public Result<Object> connectionTest(int id) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            Result<Object> result = new Result<Object>();
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        return this.checkConnection(dataSource.getType(), DatasourceUtil.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams()));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<Object> delete(User loginUser, int datasourceId) {
        Result<Object> result = new Result<Object>();
        try {
            DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(datasourceId));
            if (dataSource == null) {
                logger.error("resource id {} not exist", (Object)datasourceId);
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.hasPerm(loginUser, dataSource.getUserId())) {
                this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
            this.dataSourceMapper.deleteById((Serializable)Integer.valueOf(datasourceId));
            this.datasourceUserMapper.deleteByDatasourceId(datasourceId);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            logger.error("delete datasource error", (Throwable)e);
            throw new RuntimeException("delete datasource error");
        }
        return result;
    }

    @Override
    public Map<String, Object> unauthDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        ArrayList resultList = new ArrayList();
        List datasourceList = this.dataSourceMapper.queryDatasourceExceptUserId(userId.intValue());
        HashSet datasourceSet = null;
        if (datasourceList != null && !datasourceList.isEmpty()) {
            datasourceSet = new HashSet(datasourceList);
            List authedDataSourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
            HashSet authedDataSourceSet = null;
            if (authedDataSourceList != null && !authedDataSourceList.isEmpty()) {
                authedDataSourceSet = new HashSet(authedDataSourceList);
                datasourceSet.removeAll(authedDataSourceSet);
            }
            resultList = new ArrayList(datasourceSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authedDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        List authedDatasourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
        result.put("data", authedDatasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

