/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.CommandStateCount;
import org.apache.dolphinscheduler.api.dto.DefineUserDto;
import org.apache.dolphinscheduler.api.dto.TaskCountDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.TriFunction;
import org.apache.dolphinscheduler.dao.entity.CommandCount;
import org.apache.dolphinscheduler.dao.entity.DefinitionGroupByUser;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataAnalysisServiceImpl
extends BaseServiceImpl
implements DataAnalysisService {
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ProcessService processService;

    @Override
    public Map<String, Object> countTaskStateByProject(User loginUser, long projectCode, String startDate, String endDate) {
        return this.countStateByProject(loginUser, projectCode, startDate, endDate, (TriFunction<Date, Date, Long[], List<ExecuteStatusCount>>)((TriFunction)(start, end, projectCodes) -> this.taskInstanceMapper.countTaskInstanceStateByProjectCodes(start, end, projectCodes)));
    }

    @Override
    public Map<String, Object> countProcessInstanceStateByProject(User loginUser, long projectCode, String startDate, String endDate) {
        Map<String, Object> result = this.countStateByProject(loginUser, projectCode, startDate, endDate, (TriFunction<Date, Date, Long[], List<ExecuteStatusCount>>)((TriFunction)(start, end, projectCodes) -> this.processInstanceMapper.countInstanceStateByProjectCodes(start, end, projectCodes)));
        if (result.containsKey("status") && result.get("status").equals((Object)Status.SUCCESS)) {
            ((TaskCountDto)result.get("data")).removeStateFromCountList(ExecutionStatus.FORCED_SUCCESS);
        }
        return result;
    }

    private Map<String, Object> countStateByProject(User loginUser, long projectCode, String startDate, String endDate, TriFunction<Date, Date, Long[], List<ExecuteStatusCount>> instanceStateCounter) {
        Long[] longArray;
        Project project;
        Map<Object, Object> result = new HashMap();
        if (projectCode != 0L && (result = this.projectService.checkProjectAndAuth(loginUser, project = this.projectMapper.queryByCode(projectCode), projectCode)).get("status") != Status.SUCCESS) {
            return result;
        }
        Date start = null;
        Date end = null;
        if (!StringUtils.isEmpty((String)startDate) && !StringUtils.isEmpty((String)endDate)) {
            start = DateUtils.getScheduleDate((String)startDate);
            end = DateUtils.getScheduleDate((String)endDate);
            if (Objects.isNull(start) || Objects.isNull(end)) {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
                return result;
            }
        }
        ArrayList<ExecuteStatusCount> processInstanceStateCounts = new ArrayList();
        if (projectCode == 0L) {
            longArray = this.getProjectCodesArrays(loginUser);
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = projectCode;
        }
        Long[] projectCodeArray = longArray;
        if (projectCodeArray.length != 0 || loginUser.getUserType() == UserType.ADMIN_USER) {
            processInstanceStateCounts = (List)instanceStateCounter.apply((Object)start, (Object)end, (Object)projectCodeArray);
        }
        if (processInstanceStateCounts != null) {
            TaskCountDto taskCountResult = new TaskCountDto(processInstanceStateCounts);
            result.put("data", taskCountResult);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> countDefinitionByUser(User loginUser, long projectCode) {
        Long[] longArray;
        Project project;
        Map<Object, Object> result = new HashMap();
        if (projectCode != 0L && (result = this.projectService.checkProjectAndAuth(loginUser, project = this.projectMapper.queryByCode(projectCode), projectCode)).get("status") != Status.SUCCESS) {
            return result;
        }
        ArrayList<DefinitionGroupByUser> defineGroupByUsers = new ArrayList();
        if (projectCode == 0L) {
            longArray = this.getProjectCodesArrays(loginUser);
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = projectCode;
        }
        Long[] projectCodeArray = longArray;
        if (projectCodeArray.length != 0 || loginUser.getUserType() == UserType.ADMIN_USER) {
            defineGroupByUsers = this.processDefinitionMapper.countDefinitionByProjectCodes(projectCodeArray);
        }
        DefineUserDto dto = new DefineUserDto(defineGroupByUsers);
        result.put("data", dto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> countCommandState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date start = null;
        Date end = null;
        Long[] projectCodeArray = this.getProjectCodesArrays(loginUser);
        Map<CommandType, Integer> normalCountCommandCounts = this.commandMapper.countCommandState(loginUser.getId(), start, end, projectCodeArray).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        Map<CommandType, Integer> errorCommandCounts = this.errorCommandMapper.countCommandState(start, end, projectCodeArray).stream().collect(Collectors.toMap(CommandCount::getCommandType, CommandCount::getCount));
        List list = Arrays.stream(CommandType.values()).map(commandType -> new CommandStateCount(errorCommandCounts.getOrDefault(commandType, 0), normalCountCommandCounts.getOrDefault(commandType, 0), (CommandType)commandType)).collect(Collectors.toList());
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Long[] getProjectCodesArrays(User loginUser) {
        List projectList = this.projectMapper.queryRelationProjectListByUserId(loginUser.getUserType() == UserType.ADMIN_USER ? 0 : loginUser.getId());
        HashSet projectCodes = new HashSet();
        projectList.forEach(project -> projectCodes.add(project.getCode()));
        if (loginUser.getUserType() == UserType.GENERAL_USER) {
            List createProjects = this.projectMapper.queryProjectCreatedByUser(loginUser.getId());
            createProjects.forEach(project -> projectCodes.add(project.getCode()));
        }
        return projectCodes.toArray(new Long[0]);
    }

    @Override
    public Map<String, Object> countQueueState(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("taskQueue", 0);
        dataMap.put("taskKill", 0);
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

