/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.K8sNameSpaceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.K8sNamespaceMapper;
import org.apache.dolphinscheduler.service.k8s.K8sClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class K8sNameSpaceServiceImpl
extends BaseServiceImpl
implements K8sNameSpaceService {
    private static final Logger logger = LoggerFactory.getLogger(K8sNameSpaceServiceImpl.class);
    private static String resourceYaml = "apiVersion: v1\nkind: ResourceQuota\nmetadata:\n  name: ${name}\n  namespace: ${namespace}\nspec:\n  hard:\n    ${limitCpu}\n    ${limitMemory}\n";
    @Autowired
    private K8sNamespaceMapper k8sNamespaceMapper;
    @Autowired
    private K8sClientService k8sClientService;

    @Override
    public Result queryListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage k8sNamespaceList = this.k8sNamespaceMapper.queryK8sNamespacePaging((IPage)page, searchVal);
        Integer count = (int)k8sNamespaceList.getTotal();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal(count);
        pageInfo.setTotalList(k8sNamespaceList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> createK8sNamespace(User loginUser, String namespace, String k8s, String owner, String tag, Double limitsCpu, Integer limitsMemory) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.isEmpty((String)namespace)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "namespace");
            return result;
        }
        if (StringUtils.isEmpty((String)k8s)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "k8s");
            return result;
        }
        if (limitsCpu != null && limitsCpu < 0.0) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "limitsCpu");
            return result;
        }
        if (limitsMemory != null && limitsMemory < 0) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "limitsMemory");
            return result;
        }
        if (this.checkNamespaceExistInDb(namespace, k8s)) {
            this.putMsg(result, Status.K8S_NAMESPACE_EXIST, namespace, k8s);
            return result;
        }
        K8sNamespace k8sNamespaceObj = new K8sNamespace();
        Date now = new Date();
        k8sNamespaceObj.setNamespace(namespace);
        k8sNamespaceObj.setK8s(k8s);
        k8sNamespaceObj.setOwner(owner);
        k8sNamespaceObj.setTag(tag);
        k8sNamespaceObj.setLimitsCpu(limitsCpu);
        k8sNamespaceObj.setLimitsMemory(limitsMemory);
        k8sNamespaceObj.setOnlineJobNum(Integer.valueOf(0));
        k8sNamespaceObj.setPodReplicas(Integer.valueOf(0));
        k8sNamespaceObj.setPodRequestCpu(Double.valueOf(0.0));
        k8sNamespaceObj.setPodRequestMemory(Integer.valueOf(0));
        k8sNamespaceObj.setCreateTime(now);
        k8sNamespaceObj.setUpdateTime(now);
        try {
            String yamlStr = this.genDefaultResourceYaml(k8sNamespaceObj);
            this.k8sClientService.upsertNamespaceAndResourceToK8s(k8sNamespaceObj, yamlStr);
        }
        catch (Exception e) {
            logger.error("namespace create to k8s error", (Throwable)e);
            this.putMsg(result, Status.K8S_CLIENT_OPS_ERROR, e.getMessage());
            return result;
        }
        this.k8sNamespaceMapper.insert((Object)k8sNamespaceObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateK8sNamespace(User loginUser, int id, String owner, String tag, Double limitsCpu, Integer limitsMemory) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (limitsCpu != null && limitsCpu < 0.0) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "limitsCpu");
            return result;
        }
        if (limitsMemory != null && limitsMemory < 0) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "limitsMemory");
            return result;
        }
        K8sNamespace k8sNamespaceObj = (K8sNamespace)this.k8sNamespaceMapper.selectById((Serializable)Integer.valueOf(id));
        if (k8sNamespaceObj == null) {
            this.putMsg(result, Status.K8S_NAMESPACE_NOT_EXIST, id);
            return result;
        }
        Date now = new Date();
        k8sNamespaceObj.setTag(tag);
        k8sNamespaceObj.setLimitsCpu(limitsCpu);
        k8sNamespaceObj.setLimitsMemory(limitsMemory);
        k8sNamespaceObj.setUpdateTime(now);
        k8sNamespaceObj.setOwner(owner);
        try {
            String yamlStr = this.genDefaultResourceYaml(k8sNamespaceObj);
            this.k8sClientService.upsertNamespaceAndResourceToK8s(k8sNamespaceObj, yamlStr);
        }
        catch (Exception e) {
            logger.error("namespace update to k8s error", (Throwable)e);
            this.putMsg(result, Status.K8S_CLIENT_OPS_ERROR, e.getMessage());
            return result;
        }
        this.k8sNamespaceMapper.updateById((Object)k8sNamespaceObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyNamespaceK8s(String namespace, String k8s) {
        Result<Object> result = new Result<Object>();
        if (StringUtils.isEmpty((String)namespace)) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"namespace"});
            return result;
        }
        if (StringUtils.isEmpty((String)k8s)) {
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"k8s"});
            return result;
        }
        if (this.checkNamespaceExistInDb(namespace, k8s)) {
            this.putMsg((Result)result, Status.K8S_NAMESPACE_EXIST, new Object[]{namespace, k8s});
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteNamespaceById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        K8sNamespace k8sNamespaceObj = (K8sNamespace)this.k8sNamespaceMapper.selectById((Serializable)Integer.valueOf(id));
        if (k8sNamespaceObj == null) {
            this.putMsg(result, Status.K8S_NAMESPACE_NOT_EXIST, id);
            return result;
        }
        this.k8sClientService.deleteNamespaceToK8s(k8sNamespaceObj.getNamespace(), k8sNamespaceObj.getK8s());
        this.k8sNamespaceMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkNamespaceExistInDb(String namespace, String k8s) {
        return this.k8sNamespaceMapper.existNamespace(namespace, k8s) == Boolean.TRUE;
    }

    private String genDefaultResourceYaml(K8sNamespace k8sNamespace) {
        String name = k8sNamespace.getNamespace();
        String namespace = k8sNamespace.getNamespace();
        String cpuStr = null;
        if (k8sNamespace.getLimitsCpu() != null) {
            cpuStr = k8sNamespace.getLimitsCpu() + "";
        }
        String memoryStr = null;
        if (k8sNamespace.getLimitsMemory() != null) {
            memoryStr = k8sNamespace.getLimitsMemory() + "Gi";
        }
        String result = resourceYaml.replace("${name}", name).replace("${namespace}", namespace);
        result = cpuStr == null ? result.replace("${limitCpu}", "") : result.replace("${limitCpu}", "limits.cpu: '" + cpuStr + "'");
        result = memoryStr == null ? result.replace("${limitMemory}", "") : result.replace("${limitMemory}", "limits.memory: " + memoryStr);
        return result;
    }
}

