/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.api.audit.AuditMessage;
import org.apache.dolphinscheduler.api.audit.AuditSubscriber;
import org.apache.dolphinscheduler.api.configuration.AuditConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditPublishService {
    private BlockingQueue<AuditMessage> auditMessageQueue = new LinkedBlockingQueue<AuditMessage>();
    @Autowired
    private List<AuditSubscriber> subscribers;
    @Autowired
    private AuditConfiguration auditConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(AuditPublishService.class);

    @PostConstruct
    private void init() {
        if (this.auditConfiguration.getEnabled()) {
            Thread thread = new Thread(this::doPublish);
            thread.setDaemon(true);
            thread.setName("Audit-Log-Consume-Thread");
            thread.start();
        }
    }

    public void publish(AuditMessage message) {
        if (this.auditConfiguration.getEnabled() && !this.auditMessageQueue.offer(message)) {
            logger.error("add audit message failed {}", (Object)message);
        }
    }

    private void doPublish() {
        AuditMessage message = null;
        try {
            block4: while (true) {
                message = this.auditMessageQueue.take();
                Iterator<AuditSubscriber> iterator = this.subscribers.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    AuditSubscriber subscriber = iterator.next();
                    try {
                        subscriber.execute(message);
                    }
                    catch (Exception e) {
                        logger.error("consume audit message {} failed, error detail {}", (Object)message, (Object)e);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            logger.error("consume audit message failed {}.", (Object)message, (Object)e);
            Thread.currentThread().interrupt();
            return;
        }
    }
}

