/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AlertPluginInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ALERT_PLUGIN_INSTANCE_TAG"})
@RestController
@RequestMapping(value={"alert-plugin-instances"})
public class AlertPluginInstanceController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AlertPluginInstanceController.class);
    @Autowired
    private AlertPluginInstanceService alertPluginInstanceService;

    @ApiOperation(value="createAlertPluginInstance", notes="CREATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pluginDefineId", value="ALERT_PLUGIN_DEFINE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="instanceName", value="ALERT_PLUGIN_INSTANCE_NAME", required=true, dataType="String", example="DING TALK"), @ApiImplicitParam(name="pluginInstanceParams", value="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, dataType="String", example="ALERT_PLUGIN_INSTANCE_PARAMS")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createAlertPluginInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginDefineId") int pluginDefineId, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        Map<String, Object> result = this.alertPluginInstanceService.create(loginUser, pluginDefineId, instanceName, pluginInstanceParams);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateAlertPluginInstance", notes="UPDATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertPluginInstanceId", value="ALERT_PLUGIN_INSTANCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="instanceName", value="ALERT_PLUGIN_INSTANCE_NAME", required=true, dataType="String", example="DING TALK"), @ApiImplicitParam(name="pluginInstanceParams", value="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, dataType="String", example="ALERT_PLUGIN_INSTANCE_PARAMS")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateAlertPluginInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        Map<String, Object> result = this.alertPluginInstanceService.update(loginUser, id, instanceName, pluginInstanceParams);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteAlertPluginInstance", notes="DELETE_ALERT_PLUGIN_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_PLUGIN_ID", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteAlertPluginInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertPluginInstanceService.delete(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="getAlertPluginInstance", notes="GET_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result getAlertPluginInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertPluginInstanceService.get(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAlertPluginInstanceList", notes="QUERY_ALL_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result getAlertPluginInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.alertPluginInstanceService.queryAll();
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyAlertInstanceName", notes="VERIFY_ALERT_INSTANCE_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="alertInstanceName", value="ALERT_INSTANCE_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyGroupName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertInstanceName") String alertInstanceName) {
        boolean exist = this.alertPluginInstanceService.checkExistPluginInstanceName(alertInstanceName);
        if (exist) {
            logger.error("alert plugin instance {} has exist, can't create again.", (Object)alertInstanceName);
            return Result.error(Status.PLUGIN_INSTANCE_ALREADY_EXIT);
        }
        return Result.success();
    }

    @ApiOperation(value="queryAlertPluginInstanceListPaging", notes="QUERY_ALERT_PLUGIN_INSTANCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_PAGING_ALERT_PLUGIN_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.alertPluginInstanceService.listPaging(loginUser, searchVal, pageNo, pageSize);
    }
}

