/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.text.MessageFormat;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.hibernate.validator.internal.constraintvalidators.bv.EmailValidator;

public class CheckUtils {
    private CheckUtils() {
        throw new IllegalStateException("CheckUtils class");
    }

    public static boolean checkUserName(String userName) {
        return CheckUtils.regexChecks(userName, Constants.REGEX_USER_NAME);
    }

    public static boolean checkEmail(String email) {
        if (StringUtils.isBlank((String)email)) {
            return false;
        }
        EmailValidator emailValidator = new EmailValidator();
        if (!emailValidator.isValid((CharSequence)email, null)) {
            return false;
        }
        int indexDomain = email.lastIndexOf("@");
        String domainString = email.substring(indexDomain);
        return domainString.contains(".");
    }

    public static Map<String, Object> checkDesc(String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)desc) && desc.length() > 200) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "desc length"));
        } else {
            result.put("status", (Object)Status.SUCCESS);
        }
        return result;
    }

    public static boolean checkOtherParams(String otherParams) {
        return !StringUtils.isEmpty((String)otherParams) && !JSONUtils.checkJsonValid((String)otherParams);
    }

    public static boolean checkPassword(String password) {
        return !StringUtils.isEmpty((String)password) && password.length() >= 2 && password.length() <= 20;
    }

    public static boolean checkPhone(String phone) {
        return StringUtils.isEmpty((String)phone) || phone.length() == 11;
    }

    public static boolean checkTimeZone(String timeZone) {
        try {
            ZoneId.of(timeZone);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean regexChecks(String str, Pattern pattern) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return pattern.matcher(str).matches();
    }
}

