/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROJECT_TAG"})
@RestController
@RequestMapping(value={"projects"})
public class ProjectController
extends BaseController {
    @Autowired
    private ProjectService projectService;

    @ApiOperation(value="create", notes="CREATE_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", value="PROJECT_NAME", dataType="String"), @ApiImplicitParam(name="description", value="PROJECT_DESC", dataType="String")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description) {
        Map<String, Object> result = this.projectService.createProject(loginUser, projectName, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="update", notes="UPDATE_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROJECT_CODE", dataType="Long", example="123456"), @ApiImplicitParam(name="projectName", value="PROJECT_NAME", dataType="String"), @ApiImplicitParam(name="description", value="PROJECT_DESC", dataType="String"), @ApiImplicitParam(name="userName", value="USER_NAME", dataType="String")})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description, @RequestParam(value="userName") String userName) {
        Map<String, Object> result = this.projectService.update(loginUser, code, projectName, description, userName);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProjectByCode", notes="QUERY_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROJECT_CODE", dataType="Long", example="123456")})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_DETAILS_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProjectByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.projectService.queryByCode(loginUser, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProjectListPaging", notes="QUERY_PROJECT_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProjectListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.projectService.queryProjectListPaging(loginUser, pageSize, pageNo, searchVal);
        return result;
    }

    @ApiOperation(value="delete", notes="DELETE_PROJECT_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="PROJECT_CODE", dataType="Long", example="123456")})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        Map<String, Object> result = this.projectService.deleteProject(loginUser, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUnauthorizedProject", notes="QUERY_UNAUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/unauth-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UNAUTHORIZED_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUnauthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.projectService.queryUnauthorizedProject(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAuthorizedProject", notes="QUERY_AUTHORIZED_PROJECT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/authed-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_PROJECT)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuthorizedProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.projectService.queryAuthorizedProject(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAuthorizedUser", notes="QUERY_AUTHORIZED_USER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", dataType="Long", example="100")})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_USER)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuthorizedUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectCode") Long projectCode) {
        Map<String, Object> result = this.projectService.queryAuthorizedUser(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProjectCreatedAndAuthorizedByUser", notes="QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_NOTES")
    @GetMapping(value={"/created-and-authed"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProjectCreatedAndAuthorizedByUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.projectService.queryProjectCreatedAndAuthorizedByUser(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAllProjectList", notes="QUERY_ALL_PROJECT_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllProjectList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.projectService.queryAllProjectList(loginUser);
        return this.returnDataList(result);
    }
}

