/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.gantt.GanttDto;
import org.apache.dolphinscheduler.api.dto.gantt.Task;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessInstanceServiceImpl
extends BaseServiceImpl
implements ProcessInstanceService {
    public static final String TASK_TYPE = "taskType";
    public static final String LOCAL_PARAMS_LIST = "localParamsList";
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    ProcessInstanceMapper processInstanceMapper;
    @Autowired
    ProcessDefinitionMapper processDefineMapper;
    @Autowired
    ProcessDefinitionService processDefinitionService;
    @Autowired
    ExecutorService execService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    LoggerService loggerService;
    @Autowired
    ProcessDefinitionLogMapper processDefinitionLogMapper;
    @Autowired
    TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    UsersService usersService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private ScheduleMapper scheduleMapper;

    @Override
    public Map<String, Object> queryTopNLongestRunningProcessInstance(User loginUser, long projectCode, int size, String startTime, String endTime) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (0 > size) {
            this.putMsg(result, Status.NEGTIVE_SIZE_NUMBER_ERROR, size);
            return result;
        }
        if (Objects.isNull(startTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "start time");
            return result;
        }
        Date start = DateUtils.stringToDate((String)startTime);
        if (Objects.isNull(endTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "end time");
            return result;
        }
        Date end = DateUtils.stringToDate((String)endTime);
        if (start == null || end == null) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        if (start.getTime() > end.getTime()) {
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, startTime, endTime);
            return result;
        }
        List processInstances = this.processInstanceMapper.queryTopNProcessInstance(size, start, end, ExecutionStatus.SUCCESS, projectCode);
        result.put("data", processInstances);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProcessInstanceById(User loginUser, long projectCode, Integer processId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(processId.intValue());
        ProcessDefinition processDefinition = this.processService.findProcessDefinition(processInstance.getProcessDefinitionCode(), processInstance.getProcessDefinitionVersion());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processId);
        } else {
            processInstance.setLocations(processDefinition.getLocations());
            processInstance.setDagData(this.processService.genDagData(processDefinition));
            result.put("data", processInstance);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryProcessInstanceList(User loginUser, long projectCode, long processDefineCode, String startDate, String endDate, String searchVal, String executorName, ExecutionStatus stateType, String host, Integer pageNo, Integer pageSize) {
        Map<String, Object> checkAndParseDateResult;
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            this.putMsg(result, resultEnum, new Object[0]);
            return result;
        }
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.ordinal()};
        }
        if ((resultEnum = (Status)((Object)(checkAndParseDateResult = this.checkAndParseDateParameters(startDate, endDate)).get("status"))) != Status.SUCCESS) {
            this.putMsg(result, resultEnum, new Object[0]);
            return result;
        }
        Date start = (Date)checkAndParseDateResult.get("start time");
        Date end = (Date)checkAndParseDateResult.get("end time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        int executorId = this.usersService.getUserIdByName(executorName);
        IPage processInstanceList = this.processInstanceMapper.queryProcessInstanceListPaging(page, Long.valueOf(project.getCode()), Long.valueOf(processDefineCode), searchVal, Integer.valueOf(executorId), statusArray, host, start, end);
        List processInstances = processInstanceList.getRecords();
        List<Integer> userIds = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)processInstances)) {
            userIds = processInstances.stream().map(ProcessInstance::getExecutorId).collect(Collectors.toList());
        }
        List<User> users = this.usersService.queryUser(userIds);
        Map<Object, Object> idToUserMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty(users)) {
            idToUserMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        for (ProcessInstance processInstance : processInstances) {
            processInstance.setDuration(DateUtils.format2Duration((Date)processInstance.getStartTime(), (Date)processInstance.getEndTime()));
            User executor = (User)idToUserMap.get(processInstance.getExecutorId());
            if (null == executor) continue;
            processInstance.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotal((int)processInstanceList.getTotal());
        pageInfo.setTotalList(processInstances);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskListByProcessId(User loginUser, long projectCode, Integer processId) throws IOException {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(processId.intValue());
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition != null && projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processId);
            return result;
        }
        List taskInstanceList = this.processService.findValidTaskListByProcessId(processId);
        this.addDependResultForTaskList(taskInstanceList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("processInstanceState", processInstance.getState().toString());
        resultMap.put("taskList", taskInstanceList);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void addDependResultForTaskList(List<TaskInstance> taskInstanceList) throws IOException {
        for (TaskInstance taskInstance : taskInstanceList) {
            Result<String> logResult;
            if (!"DEPENDENT".equalsIgnoreCase(taskInstance.getTaskType()) || (logResult = this.loggerService.queryLog(taskInstance.getId(), 0, 4096)).getCode().intValue() != Status.SUCCESS.ordinal()) continue;
            String log = logResult.getData();
            Map<String, DependResult> resultMap = this.parseLogForDependentResult(log);
            taskInstance.setDependentResult(JSONUtils.toJsonString(resultMap));
        }
    }

    @Override
    public Map<String, DependResult> parseLogForDependentResult(String log) throws IOException {
        String line;
        HashMap<String, DependResult> resultMap = new HashMap<String, DependResult>();
        if (StringUtils.isEmpty((String)log)) {
            return resultMap;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(log.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String dependResultString;
            String[] dependStringArray;
            String[] tmpStringArray;
            if (!line.contains(":||") || (tmpStringArray = line.split(":\\|\\|")).length != 2 || (dependStringArray = (dependResultString = tmpStringArray[1]).split(",")).length != 2) continue;
            String key = dependStringArray[0].trim();
            DependResult dependResult = DependResult.valueOf((String)dependStringArray[1].trim());
            resultMap.put(key, dependResult);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> querySubProcessInstanceByTaskId(User loginUser, long projectCode, Integer taskId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskInstance taskInstance = this.processService.findTaskInstanceById(taskId);
        if (taskInstance == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskInstance.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        if (!taskInstance.isSubProcess()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE, taskInstance.getName());
            return result;
        }
        ProcessInstance subWorkflowInstance = this.processService.findSubProcessInstance(Integer.valueOf(taskInstance.getProcessInstanceId()), Integer.valueOf(taskInstance.getId()));
        if (subWorkflowInstance == null) {
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, taskId);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("subProcessInstanceId", subWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> updateProcessInstance(User loginUser, long projectCode, Integer processInstanceId, String taskRelationJson, String taskDefinitionJson, String scheduleTime, Boolean syncDefine, String globalParams, String locations, int timeout, String tenantCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        ProcessDefinition processDefinition0 = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition0 != null && projectCode != processDefinition0.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        if (!processInstance.getState().typeIsFinished()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState().toString(), "update");
            return result;
        }
        Map commandParamMap = JSONUtils.toMap((String)processInstance.getCommandParam());
        String timezoneId = null;
        timezoneId = commandParamMap == null || StringUtils.isBlank((String)((String)commandParamMap.get("schedule_timezone"))) ? loginUser.getTimeZone() : (String)commandParamMap.get("schedule_timezone");
        this.setProcessInstance(processInstance, tenantCode, scheduleTime, globalParams, timeout, timezoneId);
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (taskDefinitionLogs.isEmpty()) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionLog.getTaskType()).taskParams(taskDefinitionLog.getTaskParams()).dependence(taskDefinitionLog.getDependence()).build())) continue;
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, syncDefine);
        if (saveTaskResult == -1) {
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        List taskRelationList = JSONUtils.toList((String)taskRelationJson, ProcessTaskRelationLog.class);
        result = this.processDefinitionService.checkProcessNodeList(taskRelationJson, taskDefinitionLogs);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        int tenantId = -1;
        if (!"default".equals(tenantCode)) {
            Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
            if (tenant == null) {
                this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
                return result;
            }
            tenantId = tenant.getId();
        }
        processDefinition.set(projectCode, processDefinition.getName(), processDefinition.getDescription(), globalParams, locations, timeout, tenantId);
        processDefinition.setUpdateTime(new Date());
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, syncDefine, Boolean.FALSE);
        if (insertVersion == 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs, syncDefine);
        if (insertResult != 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
        processInstance.setProcessDefinitionVersion(insertVersion);
        int update = this.processService.updateProcessInstance(processInstance);
        if (update == 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_INSTANCE_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_INSTANCE_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void setProcessInstance(ProcessInstance processInstance, String tenantCode, String scheduleTime, String globalParams, int timeout, String timezone) {
        Date schedule = processInstance.getScheduleTime();
        if (scheduleTime != null) {
            schedule = DateUtils.getScheduleDate((String)scheduleTime);
        }
        processInstance.setScheduleTime(schedule);
        List globalParamList = JSONUtils.toList((String)globalParams, Property.class);
        Map<String, String> globalParamMap = globalParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        globalParams = ParameterUtils.curingGlobalParams(globalParamMap, (List)globalParamList, (CommandType)processInstance.getCmdTypeIfComplement(), (Date)schedule, (String)timezone);
        processInstance.setTimeout(timeout);
        processInstance.setTenantCode(tenantCode);
        processInstance.setGlobalParams(globalParams);
    }

    @Override
    public Map<String, Object> queryParentInstanceBySubId(User loginUser, long projectCode, Integer subId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance subInstance = this.processService.findProcessInstanceDetailById(subId.intValue());
        if (subInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, subId);
            return result;
        }
        if (subInstance.getIsSubProcess() == Flag.NO) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_SUB_PROCESS_INSTANCE, subInstance.getName());
            return result;
        }
        ProcessInstance parentWorkflowInstance = this.processService.findParentProcessInstance(subId);
        if (parentWorkflowInstance == null) {
            this.putMsg(result, Status.SUB_PROCESS_INSTANCE_NOT_EXIST, new Object[0]);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("parentWorkflowInstance", parentWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteProcessInstanceById(User loginUser, long projectCode, Integer processInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(processInstanceId.intValue());
        if (null == processInstance) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, String.valueOf(processInstanceId));
            return result;
        }
        if (!processInstance.getState().typeIsFinished()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), processInstance.getState().toString(), "delete");
            return result;
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition != null && projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, String.valueOf(processInstanceId));
            return result;
        }
        try {
            this.processService.removeTaskLogFile(processInstanceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int delete = this.processService.deleteWorkProcessInstanceById(processInstanceId.intValue());
        this.processService.deleteAllSubWorkProcessByParentId(processInstanceId.intValue());
        this.processService.deleteWorkProcessMapByParentId(processInstanceId.intValue());
        this.processService.deleteWorkTaskInstanceByProcessInstanceId(processInstanceId.intValue());
        if (delete <= 0) {
            this.putMsg(result, Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> viewVariables(long projectCode, Integer processInstanceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            throw new RuntimeException("workflow instance is null");
        }
        ProcessDefinition processDefinition = this.processDefineMapper.queryByCode(processInstance.getProcessDefinitionCode().longValue());
        if (processDefinition != null && projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        Map commandParam = JSONUtils.toMap((String)processInstance.getCommandParam());
        String timezone = null;
        if (commandParam != null) {
            timezone = (String)commandParam.get("schedule_timezone");
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)processInstance.getCmdTypeIfComplement(), (Date)processInstance.getScheduleTime(), (String)timezone);
        String userDefinedParams = processInstance.getGlobalParams();
        List globalParams = new ArrayList();
        String globalParamStr = ParameterUtils.convertParameterPlaceholders((String)JSONUtils.toJsonString(globalParams), (Map)timeParams);
        globalParams = JSONUtils.toList((String)globalParamStr, Property.class);
        for (Property property : globalParams) {
            timeParams.put(property.getProp(), property.getValue());
        }
        if (userDefinedParams != null && userDefinedParams.length() > 0) {
            globalParams = JSONUtils.toList((String)userDefinedParams, Property.class);
        }
        Map<String, Map<String, Object>> localUserDefParams = this.getLocalParams(processInstance, timeParams);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("globalParams", globalParams);
        resultMap.put("localParams", localUserDefParams);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Map<String, Map<String, Object>> getLocalParams(ProcessInstance processInstance, Map<String, String> timeParams) {
        HashMap<String, Map<String, Object>> localUserDefParams = new HashMap<String, Map<String, Object>>();
        List taskInstanceList = this.taskInstanceMapper.findValidTaskListByProcessId(Integer.valueOf(processInstance.getId()), Flag.YES);
        for (TaskInstance taskInstance : taskInstanceList) {
            TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
            String localParams = JSONUtils.getNodeString((String)taskDefinitionLog.getTaskParams(), (String)"localParams");
            if (StringUtils.isEmpty((String)localParams)) continue;
            localParams = ParameterUtils.convertParameterPlaceholders((String)localParams, timeParams);
            List localParamsList = JSONUtils.toList((String)localParams, Property.class);
            HashMap<String, Object> localParamsMap = new HashMap<String, Object>();
            localParamsMap.put(TASK_TYPE, taskDefinitionLog.getTaskType());
            localParamsMap.put(LOCAL_PARAMS_LIST, localParamsList);
            if (!CollectionUtils.isNotEmpty((Collection)localParamsList)) continue;
            localUserDefParams.put(taskDefinitionLog.getName(), localParamsMap);
        }
        return localUserDefParams;
    }

    @Override
    public Map<String, Object> viewGantt(long projectCode, Integer processInstanceId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessInstance processInstance = this.processInstanceMapper.queryDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            throw new RuntimeException("workflow instance is null");
        }
        ProcessDefinitionLog processDefinition = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        GanttDto ganttDto = new GanttDto();
        DAG dag = this.processService.genDagGraph((ProcessDefinition)processDefinition);
        List nodeList = dag.topologicalSort();
        ganttDto.setTaskNames(nodeList);
        ArrayList<Task> taskList = new ArrayList<Task>();
        for (String node : nodeList) {
            TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndCode(processInstanceId.intValue(), Long.valueOf(Long.parseLong(node)));
            if (taskInstance == null) continue;
            Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
            Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
            Task task = new Task();
            task.setTaskName(taskInstance.getName());
            task.getStartDate().add(startTime.getTime());
            task.getEndDate().add(endTime.getTime());
            task.setIsoStart(startTime);
            task.setIsoEnd(endTime);
            task.setStatus(taskInstance.getState().toString());
            task.setExecutionDate(taskInstance.getStartTime());
            task.setDuration(DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())));
            taskList.add(task);
        }
        ganttDto.setTasks(taskList);
        result.put("data", ganttDto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<ProcessInstance> queryByProcessDefineCodeAndStatus(Long processDefinitionCode, int[] states) {
        return this.processInstanceMapper.queryByProcessDefineCodeAndStatus(processDefinitionCode, states);
    }

    @Override
    public List<ProcessInstance> queryByProcessDefineCode(Long processDefinitionCode, int size) {
        return this.processInstanceMapper.queryByProcessDefineCode(processDefinitionCode, size);
    }
}

