/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupQueueMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskGroupQueueServiceImpl
extends BaseServiceImpl
implements TaskGroupQueueService {
    @Autowired
    TaskGroupQueueMapper taskGroupQueueMapper;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ProjectService projectService;
    private static final Logger logger = LoggerFactory.getLogger(TaskGroupQueueServiceImpl.class);

    @Override
    public Map<String, Object> queryTasksByGroupId(User loginUser, String taskName, String processName, Integer status, int groupId, int pageNo, int pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page((long)pageNo, (long)pageSize);
        Map<String, Object> objectMap = this.projectService.queryAuthorizedProject(loginUser, loginUser.getId());
        List projects = (List)objectMap.get("data");
        IPage taskGroupQueue = this.taskGroupQueueMapper.queryTaskGroupQueueByTaskGroupIdPaging(page, taskName, processName, status, groupId, projects);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)taskGroupQueue.getTotal());
        pageInfo.setTotalList(taskGroupQueue.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTasksByProcessId(User loginUser, int pageNo, int pageSize, int processId) {
        return this.doQuery(loginUser, pageNo, pageSize, processId);
    }

    @Override
    public Map<String, Object> queryAllTasks(User loginUser, int pageNo, int pageSize) {
        return this.doQuery(loginUser, pageNo, pageSize, 0);
    }

    public Map<String, Object> doQuery(User loginUser, int pageNo, int pageSize, int groupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskGroupQueue = this.taskGroupQueueMapper.queryTaskGroupQueuePaging((IPage)page, groupId);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)taskGroupQueue.getTotal());
        pageInfo.setTotalList(taskGroupQueue.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public boolean deleteByTaskId(int taskId) {
        return this.taskGroupQueueMapper.deleteByTaskId(taskId) == 1;
    }

    @Override
    public void forceStartTask(int queueId, int forceStart) {
        this.taskGroupQueueMapper.updateForceStart(queueId, forceStart);
    }

    @Override
    public void modifyPriority(Integer queueId, Integer priority) {
        this.taskGroupQueueMapper.modifyPriority(queueId.intValue(), priority.intValue());
    }
}

