/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskGroupServiceImpl
extends BaseServiceImpl
implements TaskGroupService {
    @Autowired
    private TaskGroupMapper taskGroupMapper;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ExecutorService executorService;
    private static final Logger logger = LoggerFactory.getLogger(TaskGroupServiceImpl.class);

    @Override
    public Map<String, Object> createTaskGroup(User loginUser, Long projectCode, String name, String description, int groupSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (name == null) {
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        if (groupSize <= 0) {
            this.putMsg(result, Status.TASK_GROUP_SIZE_ERROR, new Object[0]);
            return result;
        }
        TaskGroup taskGroup1 = this.taskGroupMapper.queryByName(loginUser.getId(), name);
        if (taskGroup1 != null) {
            this.putMsg(result, Status.TASK_GROUP_NAME_EXSIT, new Object[0]);
            return result;
        }
        TaskGroup taskGroup = new TaskGroup(name, projectCode.longValue(), description, groupSize, loginUser.getId(), Flag.YES.getCode());
        taskGroup.setCreateTime(new Date());
        taskGroup.setUpdateTime(new Date());
        if (this.taskGroupMapper.insert((Object)taskGroup) <= 0) {
            this.putMsg(result, Status.CREATE_TASK_GROUP_ERROR, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateTaskGroup(User loginUser, int id, String name, String description, int groupSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (name == null) {
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        if (groupSize <= 0) {
            this.putMsg(result, Status.TASK_GROUP_SIZE_ERROR, new Object[0]);
            return result;
        }
        Integer exists = this.taskGroupMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TaskGroup::getName, (Object)name)).eq(TaskGroup::getUserId, (Object)loginUser.getId())).ne(TaskGroup::getId, (Object)id));
        if (exists > 0) {
            this.putMsg(result, Status.TASK_GROUP_NAME_EXSIT, new Object[0]);
            return result;
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (taskGroup.getStatus() != Flag.YES.getCode()) {
            this.putMsg(result, Status.TASK_GROUP_STATUS_ERROR, new Object[0]);
            return result;
        }
        taskGroup.setGroupSize(groupSize);
        taskGroup.setDescription(description);
        taskGroup.setUpdateTime(new Date());
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            taskGroup.setName(name);
        }
        int i = this.taskGroupMapper.updateById((Object)taskGroup);
        logger.info("update result:{}", (Object)i);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public boolean isTheTaskGroupAvailable(int id) {
        return this.taskGroupMapper.selectCountByIdStatus(id, Flag.YES.getCode()) == 1;
    }

    @Override
    public Map<String, Object> queryAllTaskGroup(User loginUser, String name, Integer status, int pageNo, int pageSize) {
        return this.doQuery(loginUser, pageNo, pageSize, loginUser.getId(), name, status);
    }

    @Override
    public Map<String, Object> queryTaskGroupByStatus(User loginUser, int pageNo, int pageSize, int status) {
        return this.doQuery(loginUser, pageNo, pageSize, loginUser.getId(), null, status);
    }

    @Override
    public Map<String, Object> queryTaskGroupByProjectCode(User loginUser, int pageNo, int pageSize, Long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskGroupPaging = this.taskGroupMapper.queryTaskGroupPagingByProjectCode(page, projectCode);
        return this.getStringObjectMap(pageNo, pageSize, result, (IPage<TaskGroup>)taskGroupPaging);
    }

    private Map<String, Object> getStringObjectMap(int pageNo, int pageSize, Map<String, Object> result, IPage<TaskGroup> taskGroupPaging) {
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        int total = taskGroupPaging == null ? 0 : (int)taskGroupPaging.getTotal();
        List list = taskGroupPaging == null ? new ArrayList() : taskGroupPaging.getRecords();
        pageInfo.setTotal(total);
        pageInfo.setTotalList(list);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskGroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        result.put("data", taskGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> doQuery(User loginUser, int pageNo, int pageSize, int userId, String name, Integer status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskGroupPaging = this.taskGroupMapper.queryTaskGroupPaging((IPage)page, userId, name, status);
        return this.getStringObjectMap(pageNo, pageSize, result, (IPage<TaskGroup>)taskGroupPaging);
    }

    @Override
    public Map<String, Object> closeTaskGroup(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (taskGroup.getStatus() == Flag.NO.getCode()) {
            this.putMsg(result, Status.TASK_GROUP_STATUS_CLOSED, new Object[0]);
            return result;
        }
        taskGroup.setStatus(Flag.NO.getCode());
        this.taskGroupMapper.updateById((Object)taskGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> startTaskGroup(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (taskGroup.getStatus() == Flag.YES.getCode()) {
            this.putMsg(result, Status.TASK_GROUP_STATUS_OPENED, new Object[0]);
            return result;
        }
        taskGroup.setStatus(Flag.YES.getCode());
        taskGroup.setUpdateTime(new Date(System.currentTimeMillis()));
        int update = this.taskGroupMapper.updateById((Object)taskGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> forceStartTask(User loginUser, int queueId) {
        return this.executorService.forceStartTaskInstance(loginUser, queueId);
    }

    @Override
    public Map<String, Object> modifyPriority(User loginUser, Integer queueId, Integer priority) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.taskGroupQueueService.modifyPriority(queueId, priority);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

