/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskInstanceServiceImpl
extends BaseServiceImpl
implements TaskInstanceService {
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    ProcessInstanceService processInstanceService;
    @Autowired
    UsersService usersService;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;

    @Override
    public Result queryTaskListPaging(User loginUser, long projectCode, Integer processInstanceId, String processInstanceName, String taskName, String executorName, String startDate, String endDate, String searchVal, ExecutionStatus stateType, String host, Integer pageNo, Integer pageSize) {
        Map<String, Object> checkAndParseDateResult;
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.ordinal()};
        }
        if ((status = (Status)((Object)(checkAndParseDateResult = this.checkAndParseDateParameters(startDate, endDate)).get("status"))) != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
            return result;
        }
        Date start = (Date)checkAndParseDateResult.get("start time");
        Date end = (Date)checkAndParseDateResult.get("end time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        int executorId = this.usersService.getUserIdByName(executorName);
        IPage taskInstanceIPage = this.taskInstanceMapper.queryTaskInstanceListPaging((IPage)page, Long.valueOf(project.getCode()), processInstanceId, processInstanceName, searchVal, taskName, executorId, statusArray, host, start, end);
        HashSet<String> exclusionSet = new HashSet<String>();
        exclusionSet.add("class");
        exclusionSet.add("taskJson");
        List taskInstanceList = taskInstanceIPage.getRecords();
        List<Integer> executorIds = taskInstanceList.stream().map(TaskInstance::getExecutorId).distinct().collect(Collectors.toList());
        List<User> users = this.usersService.queryUser(executorIds);
        Map<Integer, User> userMap = users.stream().collect(Collectors.toMap(User::getId, v -> v));
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstance.setDuration(DateUtils.format2Duration((Date)taskInstance.getStartTime(), (Date)taskInstance.getEndTime()));
            User user = userMap.get(taskInstance.getExecutorId());
            if (user == null) continue;
            taskInstance.setExecutorName(user.getUserName());
        }
        pageInfo.setTotal((int)taskInstanceIPage.getTotal());
        pageInfo.setTotalList(CollectionUtils.getListByExclusion((List)taskInstanceIPage.getRecords(), exclusionSet));
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> forceTaskSuccess(User loginUser, long projectCode, Integer taskInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskInstance task = (TaskInstance)this.taskInstanceMapper.selectById((Serializable)taskInstanceId);
        if (task == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_FOUND, taskInstanceId);
            return result;
        }
        if (!task.getState().typeIsFailure() && !task.getState().typeIsCancel()) {
            this.putMsg(result, Status.TASK_INSTANCE_STATE_OPERATION_ERROR, taskInstanceId, task.getState().toString());
            return result;
        }
        task.setState(ExecutionStatus.FORCED_SUCCESS);
        int changedNum = this.taskInstanceMapper.updateById((Object)task);
        if (changedNum > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.FORCE_TASK_SUCCESS_ERROR, new Object[0]);
        }
        return result;
    }
}

