/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.storage.StorageOperate;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantServiceImpl
extends BaseServiceImpl
implements TenantService {
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired(required=false)
    private StorageOperate storageOperate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> createTenant(User loginUser, String tenantCode, int queueId, String desc) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (StringUtils.length((String)tenantCode) > 30) {
            this.putMsg(result, Status.TENANT_FULL_NAME_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        if (!RegexUtils.isValidLinuxUserName(tenantCode)) {
            this.putMsg(result, Status.CHECK_OS_TENANT_CODE_ERROR, new Object[0]);
            return result;
        }
        if (this.checkTenantExists(tenantCode)) {
            this.putMsg(result, Status.OS_TENANT_CODE_EXIST, tenantCode);
            return result;
        }
        Tenant tenant = new Tenant();
        Date now = new Date();
        tenant.setTenantCode(tenantCode);
        tenant.setQueueId(queueId);
        tenant.setDescription(desc);
        tenant.setCreateTime(now);
        tenant.setUpdateTime(now);
        this.tenantMapper.insert((Object)tenant);
        if (PropertyUtils.getResUploadStartupState()) {
            this.storageOperate.createTenantDirIfNotExists(tenantCode);
        }
        result.put("data", tenant);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryTenantList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result<Object> result = new Result<Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage tenantIPage = this.tenantMapper.queryTenantPaging((IPage)page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)tenantIPage.getTotal());
        pageInfo.setTotalList(tenantIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateTenant(User loginUser, int id, String tenantCode, int queueId, String desc) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Tenant tenant = this.tenantMapper.queryById(id);
        if (tenant == null) {
            this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!tenant.getTenantCode().equals(tenantCode)) {
            if (this.checkTenantExists(tenantCode)) {
                if (PropertyUtils.getResUploadStartupState()) {
                    this.storageOperate.createTenantDirIfNotExists(tenantCode);
                }
            } else {
                this.putMsg(result, Status.OS_TENANT_CODE_HAS_ALREADY_EXISTS, new Object[0]);
                return result;
            }
        }
        Date now = new Date();
        if (!StringUtils.isEmpty((String)tenantCode)) {
            tenant.setTenantCode(tenantCode);
        }
        if (queueId != 0) {
            tenant.setQueueId(queueId);
        }
        tenant.setDescription(desc);
        tenant.setUpdateTime(now);
        this.tenantMapper.updateById(tenant);
        result.put("status", (Object)Status.SUCCESS);
        result.put("msg", Status.SUCCESS.getMsg());
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> deleteTenantById(User loginUser, int id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Tenant tenant = this.tenantMapper.queryById(id);
        if (tenant == null) {
            this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            return result;
        }
        List<ProcessInstance> processInstances = this.getProcessInstancesByTenant(tenant);
        if (CollectionUtils.isNotEmpty(processInstances)) {
            this.putMsg(result, Status.DELETE_TENANT_BY_ID_FAIL, processInstances.size());
            return result;
        }
        List processDefinitions = this.processDefinitionMapper.queryDefinitionListByTenant(tenant.getId());
        if (CollectionUtils.isNotEmpty((Collection)processDefinitions)) {
            this.putMsg(result, Status.DELETE_TENANT_BY_ID_FAIL_DEFINES, processDefinitions.size());
            return result;
        }
        List userList = this.userMapper.queryUserListByTenant(tenant.getId());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            this.putMsg(result, Status.DELETE_TENANT_BY_ID_FAIL_USERS, userList.size());
            return result;
        }
        if (PropertyUtils.getResUploadStartupState()) {
            this.storageOperate.deleteTenant(tenant.getTenantCode());
        }
        this.tenantMapper.deleteById(id);
        this.processInstanceMapper.updateProcessInstanceByTenantId(id, -1);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<ProcessInstance> getProcessInstancesByTenant(Tenant tenant) {
        return this.processInstanceMapper.queryByTenantIdAndStatus(tenant.getId(), Constants.NOT_TERMINATED_STATES);
    }

    @Override
    public Map<String, Object> queryTenantList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List resourceList = this.tenantMapper.selectList(null);
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyTenantCode(String tenantCode) {
        Result<Object> result = new Result<Object>();
        if (this.checkTenantExists(tenantCode)) {
            this.putMsg((Result)result, Status.OS_TENANT_CODE_EXIST, new Object[]{tenantCode});
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public boolean checkTenantExists(String tenantCode) {
        Boolean existTenant = this.tenantMapper.existTenant(tenantCode);
        return Boolean.TRUE.equals(existTenant);
    }

    @Override
    public Map<String, Object> queryByTenantCode(String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
        if (tenant != null) {
            result.put("data", tenant);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }
}

