/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.dto.RuleDefinition;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DqRuleService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DqComparisonTypeMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleExecuteSqlMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleInputEntryMapper;
import org.apache.dolphinscheduler.dao.mapper.DqRuleMapper;
import org.apache.dolphinscheduler.dao.utils.DqRuleUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.OptionSourceType;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.params.base.FormType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.PropsType;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.group.GroupParam;
import org.apache.dolphinscheduler.spi.params.group.GroupParamsProps;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.InputParamProps;
import org.apache.dolphinscheduler.spi.params.select.SelectParam;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DqRuleServiceImpl
extends BaseServiceImpl
implements DqRuleService {
    private final Logger logger = LoggerFactory.getLogger(DqRuleServiceImpl.class);
    @Autowired
    private DqRuleMapper dqRuleMapper;
    @Autowired
    private DqRuleInputEntryMapper dqRuleInputEntryMapper;
    @Autowired
    private DqRuleExecuteSqlMapper dqRuleExecuteSqlMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DqComparisonTypeMapper dqComparisonTypeMapper;

    @Override
    public Map<String, Object> getRuleFormCreateJsonById(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List ruleInputEntryList = this.dqRuleInputEntryMapper.getRuleInputEntryList(Integer.valueOf(id));
        if (ruleInputEntryList == null || ruleInputEntryList.isEmpty()) {
            this.putMsg(result, Status.QUERY_RULE_INPUT_ENTRY_LIST_ERROR, new Object[0]);
        } else {
            result.put("data", this.getRuleFormCreateJson(DqRuleUtils.transformInputEntry((List)ruleInputEntryList)));
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryAllRuleList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List ruleList = this.dqRuleMapper.selectList((Wrapper)new QueryWrapper());
        result.put("data", ruleList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getDatasourceOptionsById(int datasourceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List dataSourceList = this.dataSourceMapper.listAllDataSourceByType(Integer.valueOf(datasourceId));
        ArrayList<ParamsOptions> options = null;
        if (CollectionUtils.isNotEmpty((Collection)dataSourceList)) {
            options = new ArrayList<ParamsOptions>();
            for (DataSource dataSource : dataSourceList) {
                ParamsOptions childrenOption = new ParamsOptions(dataSource.getName(), (Object)dataSource.getId(), false);
                options.add(childrenOption);
            }
        }
        result.put("data", options);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryRuleListPaging(User loginUser, String searchVal, Integer ruleType, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        IPage dqRulePage;
        Result result = new Result();
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startTime)) {
                start = DateUtils.getScheduleDate((String)startTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)endTime)) {
                end = DateUtils.getScheduleDate((String)endTime);
            }
        }
        catch (Exception e) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"startTime,endTime"});
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        if (ruleType == null) {
            ruleType = -1;
        }
        if ((dqRulePage = this.dqRuleMapper.queryRuleListPaging((IPage)page, searchVal, ruleType.intValue(), start, end)) != null) {
            List dataList = dqRulePage.getRecords();
            dataList.forEach(dqRule -> {
                List ruleInputEntryList = DqRuleUtils.transformInputEntry((List)this.dqRuleInputEntryMapper.getRuleInputEntryList(Integer.valueOf(dqRule.getId())));
                List ruleExecuteSqlList = this.dqRuleExecuteSqlMapper.getExecuteSqlList(Integer.valueOf(dqRule.getId()));
                RuleDefinition ruleDefinition = new RuleDefinition(ruleInputEntryList, ruleExecuteSqlList);
                dqRule.setRuleJson(JSONUtils.toJsonString((Object)ruleDefinition));
            });
            pageInfo.setTotal((int)dqRulePage.getTotal());
            pageInfo.setTotalList(dataList);
        }
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private String getRuleFormCreateJson(List<DqRuleInputEntry> ruleInputEntryList) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (DqRuleInputEntry inputEntry : ruleInputEntryList) {
            if (!Boolean.TRUE.equals(inputEntry.getShow())) continue;
            switch (Objects.requireNonNull(FormType.of((String)inputEntry.getType()))) {
                case INPUT: {
                    params.add(this.getInputParam(inputEntry));
                    break;
                }
                case SELECT: {
                    params.add(this.getSelectParam(inputEntry));
                    break;
                }
                case TEXTAREA: {
                    params.add(this.getTextareaParam(inputEntry));
                    break;
                }
                case GROUP: {
                    params.add(this.getGroupParam(inputEntry));
                    break;
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String result = null;
        try {
            result = mapper.writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            this.logger.error("json parse error : {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private InputParam getTextareaParam(DqRuleInputEntry inputEntry) {
        InputParamProps paramProps = new InputParamProps();
        paramProps.setDisabled(Boolean.valueOf(inputEntry.getCanEdit() == false));
        paramProps.setSize("small");
        paramProps.setType(PropsType.TEXTAREA.getPropsType());
        paramProps.setRows(Integer.valueOf(1));
        return InputParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getValidate().booleanValue()).build()).setProps(paramProps).setValue((Object)inputEntry.getValue()).setPlaceholder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getEmit()) ? Collections.singletonList("change") : null).build();
    }

    private SelectParam getSelectParam(DqRuleInputEntry inputEntry) {
        List<ParamsOptions> options = null;
        switch (OptionSourceType.of((Integer)inputEntry.getOptionSourceType())) {
            case DEFAULT: {
                String optionStr = inputEntry.getOptions();
                if (!StringUtils.isNotEmpty((CharSequence)optionStr)) break;
                options = JSONUtils.toList((String)optionStr, ParamsOptions.class);
                break;
            }
            case DATASOURCE_TYPE: {
                options = new ArrayList();
                ParamsOptions paramsOptions = null;
                for (DbType dbtype : DbType.values()) {
                    paramsOptions = new ParamsOptions(dbtype.name(), (Object)dbtype.getCode(), false);
                    options.add(paramsOptions);
                }
                break;
            }
            case COMPARISON_TYPE: {
                options = new ArrayList();
                ParamsOptions comparisonOptions = null;
                List list = this.dqComparisonTypeMapper.selectList((Wrapper)new QueryWrapper().orderByAsc((Object)"id"));
                for (DqComparisonType type : list) {
                    comparisonOptions = new ParamsOptions(type.getType(), (Object)type.getId(), false);
                    options.add(comparisonOptions);
                }
                break;
            }
        }
        return SelectParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).setOptions(options).setValue((Object)inputEntry.getValue()).setSize("small").setPlaceHolder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getEmit()) ? Collections.singletonList("change") : null).build();
    }

    private InputParam getInputParam(DqRuleInputEntry inputEntry) {
        InputParamProps paramProps = new InputParamProps();
        paramProps.setDisabled(Boolean.valueOf(inputEntry.getCanEdit() == false));
        paramProps.setSize("small");
        paramProps.setRows(Integer.valueOf(2));
        return InputParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getValidate().booleanValue()).build()).setProps(paramProps).setValue((Object)inputEntry.getValue()).setPlaceholder(inputEntry.getPlaceholder()).setEmit(Boolean.TRUE.equals(inputEntry.getEmit()) ? Collections.singletonList("change") : null).build();
    }

    private GroupParam getGroupParam(DqRuleInputEntry inputEntry) {
        return GroupParam.newBuilder((String)inputEntry.getField(), (String)inputEntry.getTitle()).addValidate(Validate.newBuilder().setRequired(inputEntry.getValidate().booleanValue()).build()).setProps(new GroupParamsProps().setRules(JSONUtils.toList((String)inputEntry.getOptions(), PluginParams.class)).setFontSize(20)).setEmit(Boolean.TRUE.equals(inputEntry.getEmit()) ? Collections.singletonList("change") : null).build();
    }
}

