/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.storage.StorageOperate;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantServiceImpl
extends BaseServiceImpl
implements TenantService {
    private static final Logger logger = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private QueueService queueService;
    @Autowired(required=false)
    private StorageOperate storageOperate;

    private void createTenantValid(Tenant tenant) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)tenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, tenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)tenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(tenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (this.checkTenantExists(tenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenant.getTenantCode());
        }
    }

    private void updateTenantValid(Tenant existsTenant, Tenant updateTenant) throws ServiceException {
        if (Objects.isNull(existsTenant)) {
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        if (StringUtils.isEmpty((CharSequence)updateTenant.getTenantCode())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, updateTenant.getTenantCode());
        }
        if (StringUtils.length((CharSequence)updateTenant.getTenantCode()) > 30) {
            throw new ServiceException(Status.TENANT_FULL_NAME_TOO_LONG_ERROR);
        }
        if (!RegexUtils.isValidLinuxUserName(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.CHECK_OS_TENANT_CODE_ERROR);
        }
        if (!Objects.equals(existsTenant.getTenantCode(), updateTenant.getTenantCode()) && this.checkTenantExists(updateTenant.getTenantCode())) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, updateTenant.getTenantCode());
        }
    }

    @Override
    @Transactional
    public Map<String, Object> createTenant(User loginUser, String tenantCode, int queueId, String desc) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Tenant tenant = new Tenant(tenantCode, desc, queueId);
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        if (PropertyUtils.getResUploadStartupState()) {
            this.storageOperate.createTenantDirIfNotExists(tenantCode);
        }
        result.put("data", tenant);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> queryTenantList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result<Object> result = new Result<Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage tenantIPage = this.tenantMapper.queryTenantPaging((IPage)page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)tenantIPage.getTotal());
        pageInfo.setTotalList(tenantIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateTenant(User loginUser, int id, String tenantCode, int queueId, String desc) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Tenant updateTenant = new Tenant(id, tenantCode, desc, queueId);
        Tenant existsTenant = this.tenantMapper.queryById(id);
        this.updateTenantValid(existsTenant, updateTenant);
        if (!Objects.equals(existsTenant.getTenantCode(), updateTenant.getTenantCode()) && PropertyUtils.getResUploadStartupState()) {
            this.storageOperate.createTenantDirIfNotExists(tenantCode);
        }
        this.tenantMapper.updateById(updateTenant);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteTenantById(User loginUser, int id) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Tenant tenant = this.tenantMapper.queryById(id);
        if (Objects.isNull(tenant)) {
            throw new ServiceException(Status.TENANT_NOT_EXIST);
        }
        List<ProcessInstance> processInstances = this.getProcessInstancesByTenant(tenant);
        if (CollectionUtils.isNotEmpty(processInstances)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL, processInstances.size());
        }
        List processDefinitions = this.processDefinitionMapper.queryDefinitionListByTenant(tenant.getId());
        if (CollectionUtils.isNotEmpty((Collection)processDefinitions)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_DEFINES, processDefinitions.size());
        }
        List userList = this.userMapper.queryUserListByTenant(tenant.getId());
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            throw new ServiceException(Status.DELETE_TENANT_BY_ID_FAIL_USERS, userList.size());
        }
        if (PropertyUtils.getResUploadStartupState()) {
            this.storageOperate.deleteTenant(tenant.getTenantCode());
        }
        this.tenantMapper.deleteById(id);
        this.processInstanceMapper.updateProcessInstanceByTenantId(id, -1);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<ProcessInstance> getProcessInstancesByTenant(Tenant tenant) {
        return this.processInstanceMapper.queryByTenantIdAndStatus(tenant.getId(), Constants.NOT_TERMINATED_STATES);
    }

    @Override
    public Map<String, Object> queryTenantList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List resourceList = this.tenantMapper.selectList(null);
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyTenantCode(String tenantCode) {
        Result<Object> result = new Result<Object>();
        if (this.checkTenantExists(tenantCode)) {
            throw new ServiceException(Status.OS_TENANT_CODE_EXIST, tenantCode);
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkTenantExists(String tenantCode) {
        Boolean existTenant = this.tenantMapper.existTenant(tenantCode);
        return Boolean.TRUE.equals(existTenant);
    }

    @Override
    public Map<String, Object> queryByTenantCode(String tenantCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
        if (tenant != null) {
            result.put("data", tenant);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Tenant createTenantIfNotExists(String tenantCode, String desc, String queue, String queueName) {
        if (this.checkTenantExists(tenantCode)) {
            return this.tenantMapper.queryByTenantCode(tenantCode);
        }
        Queue queueObj = this.queueService.createQueueIfNotExists(queue, queueName);
        Tenant tenant = new Tenant(tenantCode, desc, queueObj.getId());
        this.createTenantValid(tenant);
        this.tenantMapper.insert((Object)tenant);
        return tenant;
    }
}

