/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="traffic.control")
public class TrafficConfiguration {
    private boolean globalSwitch;
    private Integer maxGlobalQpsRate = 300;
    private boolean tenantSwitch;
    private Integer defaultTenantQpsRate = 10;
    private Map<String, Integer> customizeTenantQpsRate = new HashMap<String, Integer>();

    public boolean isGlobalSwitch() {
        return this.globalSwitch;
    }

    public Integer getMaxGlobalQpsRate() {
        return this.maxGlobalQpsRate;
    }

    public boolean isTenantSwitch() {
        return this.tenantSwitch;
    }

    public Integer getDefaultTenantQpsRate() {
        return this.defaultTenantQpsRate;
    }

    public Map<String, Integer> getCustomizeTenantQpsRate() {
        return this.customizeTenantQpsRate;
    }

    public void setGlobalSwitch(boolean globalSwitch) {
        this.globalSwitch = globalSwitch;
    }

    public void setMaxGlobalQpsRate(Integer maxGlobalQpsRate) {
        this.maxGlobalQpsRate = maxGlobalQpsRate;
    }

    public void setTenantSwitch(boolean tenantSwitch) {
        this.tenantSwitch = tenantSwitch;
    }

    public void setDefaultTenantQpsRate(Integer defaultTenantQpsRate) {
        this.defaultTenantQpsRate = defaultTenantQpsRate;
    }

    public void setCustomizeTenantQpsRate(Map<String, Integer> customizeTenantQpsRate) {
        this.customizeTenantQpsRate = customizeTenantQpsRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrafficConfiguration)) {
            return false;
        }
        TrafficConfiguration other = (TrafficConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobalSwitch() != other.isGlobalSwitch()) {
            return false;
        }
        if (this.isTenantSwitch() != other.isTenantSwitch()) {
            return false;
        }
        Integer this$maxGlobalQpsRate = this.getMaxGlobalQpsRate();
        Integer other$maxGlobalQpsRate = other.getMaxGlobalQpsRate();
        if (this$maxGlobalQpsRate == null ? other$maxGlobalQpsRate != null : !((Object)this$maxGlobalQpsRate).equals(other$maxGlobalQpsRate)) {
            return false;
        }
        Integer this$defaultTenantQpsRate = this.getDefaultTenantQpsRate();
        Integer other$defaultTenantQpsRate = other.getDefaultTenantQpsRate();
        if (this$defaultTenantQpsRate == null ? other$defaultTenantQpsRate != null : !((Object)this$defaultTenantQpsRate).equals(other$defaultTenantQpsRate)) {
            return false;
        }
        Map<String, Integer> this$customizeTenantQpsRate = this.getCustomizeTenantQpsRate();
        Map<String, Integer> other$customizeTenantQpsRate = other.getCustomizeTenantQpsRate();
        return !(this$customizeTenantQpsRate == null ? other$customizeTenantQpsRate != null : !((Object)this$customizeTenantQpsRate).equals(other$customizeTenantQpsRate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrafficConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobalSwitch() ? 79 : 97);
        result = result * 59 + (this.isTenantSwitch() ? 79 : 97);
        Integer $maxGlobalQpsRate = this.getMaxGlobalQpsRate();
        result = result * 59 + ($maxGlobalQpsRate == null ? 43 : ((Object)$maxGlobalQpsRate).hashCode());
        Integer $defaultTenantQpsRate = this.getDefaultTenantQpsRate();
        result = result * 59 + ($defaultTenantQpsRate == null ? 43 : ((Object)$defaultTenantQpsRate).hashCode());
        Map<String, Integer> $customizeTenantQpsRate = this.getCustomizeTenantQpsRate();
        result = result * 59 + ($customizeTenantQpsRate == null ? 43 : ((Object)$customizeTenantQpsRate).hashCode());
        return result;
    }

    public String toString() {
        return "TrafficConfiguration(globalSwitch=" + this.isGlobalSwitch() + ", maxGlobalQpsRate=" + this.getMaxGlobalQpsRate() + ", tenantSwitch=" + this.isTenantSwitch() + ", defaultTenantQpsRate=" + this.getDefaultTenantQpsRate() + ", customizeTenantQpsRate=" + this.getCustomizeTenantQpsRate() + ")";
    }
}

