/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"PROCESS_INSTANCE_TAG"})
@RestController
@RequestMapping(value={"/projects/{projectCode}/process-instances"})
public class ProcessInstanceController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    ProcessInstanceService processInstanceService;

    @ApiOperation(value="queryProcessInstanceListPaging", notes="QUERY_PROCESS_INSTANCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefineCode", value="PROCESS_DEFINITION_CODE", dataType="Long", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="executorName", value="EXECUTOR_NAME", type="String"), @ApiImplicitParam(name="stateType", value="EXECUTION_STATUS", type="ExecutionStatus"), @ApiImplicitParam(name="host", value="HOST", type="String"), @ApiImplicitParam(name="startDate", value="START_DATE", type="String"), @ApiImplicitParam(name="endDate", value="END_DATE", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessInstanceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefineCode", required=false, defaultValue="0") long processDefineCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="executorName", required=false) String executorName, @RequestParam(value="stateType", required=false) ExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.processInstanceService.queryProcessInstanceList(loginUser, projectCode, processDefineCode, startTime, endTime, searchVal, executorName, stateType, host, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="queryTaskListByProcessId", notes="QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_LIST_BY_PROCESS_INSTANCE_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskListByProcessId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) throws IOException {
        Map<String, Object> result = this.processInstanceService.queryTaskListByProcessId(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateProcessInstance", notes="UPDATE_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskRelationJson", value="TASK_RELATION_JSON", type="String"), @ApiImplicitParam(name="taskDefinitionJson", value="TASK_DEFINITION_JSON", type="String"), @ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="scheduleTime", value="SCHEDULE_TIME", type="String"), @ApiImplicitParam(name="syncDefine", value="SYNC_DEFINE", required=true, type="Boolean", example="false"), @ApiImplicitParam(name="globalParams", value="PROCESS_GLOBAL_PARAMS", type="String", example="[]"), @ApiImplicitParam(name="locations", value="PROCESS_INSTANCE_LOCATIONS", type="String"), @ApiImplicitParam(name="timeout", value="PROCESS_TIMEOUT", type="Int", example="0"), @ApiImplicitParam(name="tenantCode", value="TENANT_CODE", type="String", example="default")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskRelationJson", required=true) String taskRelationJson, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson, @PathVariable(value="id") Integer id, @RequestParam(value="scheduleTime", required=false) String scheduleTime, @RequestParam(value="syncDefine", required=true) Boolean syncDefine, @RequestParam(value="globalParams", required=false, defaultValue="[]") String globalParams, @RequestParam(value="locations", required=false) String locations, @RequestParam(value="timeout", required=false, defaultValue="0") int timeout, @RequestParam(value="tenantCode", required=true) String tenantCode) {
        Map<String, Object> result = this.processInstanceService.updateProcessInstance(loginUser, projectCode, id, taskRelationJson, taskDefinitionJson, scheduleTime, syncDefine, globalParams, locations, timeout, tenantCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryProcessInstanceById", notes="QUERY_PROCESS_INSTANCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProcessInstanceById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.processInstanceService.queryProcessInstanceById(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTopNLongestRunningProcessInstance", notes="QUERY_TOPN_LONGEST_RUNNING_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="size", value="PROCESS_INSTANCE_SIZE", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="startTime", value="PROCESS_INSTANCE_START_TIME", required=true, dataType="String"), @ApiImplicitParam(name="endTime", value="PROCESS_INSTANCE_END_TIME", required=true, dataType="String")})
    @GetMapping(value={"/top-n"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ProcessInstance> queryTopNLongestRunningProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="size") Integer size, @RequestParam(value="startTime", required=true) String startTime, @RequestParam(value="endTime", required=true) String endTime) {
        Map<String, Object> result = this.processInstanceService.queryTopNLongestRunningProcessInstance(loginUser, projectCode, size, startTime, endTime);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteProcessInstanceById", notes="DELETE_PROCESS_INSTANCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_INSTANCE_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<ProcessInstance> deleteProcessInstanceById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.processInstanceService.deleteProcessInstanceById(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="querySubProcessInstanceByTaskCode", notes="QUERY_SUBPROCESS_INSTANCE_BY_TASK_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskCode", value="TASK_CODE", required=true, dataType="Long", example="100")})
    @GetMapping(value={"/query-sub-by-parent"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_SUB_PROCESS_INSTANCE_DETAIL_INFO_BY_TASK_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result querySubProcessInstanceByTaskId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskId") Integer taskId) {
        Map<String, Object> result = this.processInstanceService.querySubProcessInstanceByTaskId(loginUser, projectCode, taskId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryParentInstanceBySubId", notes="QUERY_PARENT_PROCESS_INSTANCE_BY_SUB_PROCESS_INSTANCE_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="subId", value="SUB_PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/query-parent-by-sub"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PARENT_PROCESS_INSTANCE_DETAIL_INFO_BY_SUB_PROCESS_INSTANCE_ID_ERROR)
    @AccessLogAnnotation
    public Result queryParentInstanceBySubId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="subId") Integer subId) {
        Map<String, Object> result = this.processInstanceService.queryParentInstanceBySubId(loginUser, projectCode, subId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="viewVariables", notes="QUERY_PROCESS_INSTANCE_GLOBAL_VARIABLES_AND_LOCAL_VARIABLES_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/view-variables"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_ALL_VARIABLES_ERROR)
    @AccessLogAnnotation
    public Result viewVariables(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.processInstanceService.viewVariables(projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="vieGanttTree", notes="VIEW_GANTT_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="PROCESS_INSTANCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/view-gantt"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.ENCAPSULATION_PROCESS_INSTANCE_GANTT_STRUCTURE_ERROR)
    @AccessLogAnnotation
    public Result viewTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) throws Exception {
        Map<String, Object> result = this.processInstanceService.viewGantt(projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchDeleteProcessInstanceByIds", notes="BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", value="PROJECT_NAME", required=true, dataType="String"), @ApiImplicitParam(name="processInstanceIds", value="PROCESS_INSTANCE_IDS", required=true, dataType="String")})
    @PostMapping(value={"/batch-delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR)
    @AccessLogAnnotation
    public Result batchDeleteProcessInstanceByIds(@RequestAttribute(value="session.user") User loginUser, @PathVariable long projectCode, @RequestParam(value="processInstanceIds") String processInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deleteFailedIdList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)processInstanceIds)) {
            String[] processInstanceIdArray;
            for (String strProcessInstanceId : processInstanceIdArray = processInstanceIds.split(",")) {
                int processInstanceId = Integer.parseInt(strProcessInstanceId);
                try {
                    Map<String, Object> deleteResult = this.processInstanceService.deleteProcessInstanceById(loginUser, projectCode, processInstanceId);
                    if (Status.SUCCESS.equals(deleteResult.get("status"))) continue;
                    deleteFailedIdList.add((String)deleteResult.get("msg"));
                    logger.error((String)deleteResult.get("msg"));
                }
                catch (Exception e) {
                    deleteFailedIdList.add(MessageFormat.format(Status.PROCESS_INSTANCE_ERROR.getMsg(), strProcessInstanceId));
                }
            }
        }
        if (!deleteFailedIdList.isEmpty()) {
            this.putMsg(result, Status.BATCH_DELETE_PROCESS_INSTANCE_BY_IDS_ERROR, String.join((CharSequence)"\n", deleteFailedIdList));
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return this.returnDataList(result);
    }
}

