/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.audit.AuditMessage;
import org.apache.dolphinscheduler.api.audit.AuditPublishService;
import org.apache.dolphinscheduler.api.dto.AuditDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.AuditService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.common.enums.AuditResourceType;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AuditLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditServiceImpl
extends BaseServiceImpl
implements AuditService {
    @Autowired
    private AuditLogMapper auditLogMapper;
    @Autowired
    private AuditPublishService publishService;

    @Override
    public void addAudit(User user, AuditResourceType resourceType, Integer resourceId, AuditOperationType operation) {
        this.publishService.publish(new AuditMessage(user, new Date(), resourceType, operation, resourceId));
    }

    @Override
    public Result queryLogListPaging(User loginUser, AuditResourceType resourceType, AuditOperationType operationType, String startDate, String endDate, String userName, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Map<String, Object> checkAndParseDateResult = this.checkAndParseDateParameters(startDate, endDate);
        Status resultEnum = (Status)((Object)checkAndParseDateResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            this.putMsg(result, resultEnum, new Object[0]);
            return result;
        }
        int[] resourceArray = null;
        if (resourceType != null) {
            resourceArray = new int[]{resourceType.getCode()};
        }
        int[] opsArray = null;
        if (operationType != null) {
            opsArray = new int[]{operationType.getCode()};
        }
        Date start = (Date)checkAndParseDateResult.get("start time");
        Date end = (Date)checkAndParseDateResult.get("end time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage logIPage = this.auditLogMapper.queryAuditLog((IPage)page, resourceArray, opsArray, userName, start, end);
        List logList = logIPage != null ? logIPage.getRecords() : new ArrayList();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        List auditDtos = logList.stream().map(this::transformAuditLog).collect(Collectors.toList());
        pageInfo.setTotal((int)(auditDtos != null ? (long)auditDtos.size() : 0L));
        pageInfo.setTotalList(auditDtos);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private AuditDto transformAuditLog(AuditLog auditLog) {
        AuditDto auditDto = new AuditDto();
        String resourceType = AuditResourceType.of((int)auditLog.getResourceType()).getMsg();
        auditDto.setResource(resourceType);
        auditDto.setOperation(AuditOperationType.of((int)auditLog.getOperation()).getMsg());
        auditDto.setUserName(auditLog.getUserName());
        auditDto.setResourceName(this.auditLogMapper.queryResourceNameByType(resourceType, auditLog.getResourceId()));
        auditDto.setTime(auditLog.getTime());
        return auditDto;
    }
}

