/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.vo;

import java.time.ZoneId;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;

public class ScheduleVo {
    private int id;
    private long processDefinitionCode;
    private String processDefinitionName;
    private String projectName;
    private String definitionDescription;
    private String startTime;
    private String endTime;
    private String timezoneId;
    private String crontab;
    private FailureStrategy failureStrategy;
    private WarningType warningType;
    private Date createTime;
    private Date updateTime;
    private int userId;
    private String userName;
    private ReleaseState releaseState;
    private int warningGroupId;
    private Priority processInstancePriority;
    private String workerGroup;
    private Long environmentCode;

    public ScheduleVo(Schedule schedule) {
        this.setId(schedule.getId());
        this.setCrontab(schedule.getCrontab());
        this.setProjectName(schedule.getProjectName());
        this.setUserName(schedule.getUserName());
        this.setWorkerGroup(schedule.getWorkerGroup());
        this.setWarningType(schedule.getWarningType());
        this.setWarningGroupId(schedule.getWarningGroupId());
        this.setUserId(schedule.getUserId());
        this.setCreateTime(schedule.getCreateTime());
        this.setUpdateTime(schedule.getUpdateTime());
        this.setTimezoneId(schedule.getTimezoneId());
        this.setReleaseState(schedule.getReleaseState());
        this.setProcessInstancePriority(schedule.getProcessInstancePriority());
        this.setProcessDefinitionName(schedule.getProcessDefinitionName());
        this.setProcessDefinitionCode(schedule.getProcessDefinitionCode());
        this.setFailureStrategy(schedule.getFailureStrategy());
        this.setEnvironmentCode(schedule.getEnvironmentCode());
        this.setStartTime(DateUtils.dateToString((Date)schedule.getStartTime(), (String)ZoneId.systemDefault().getId()));
        this.setEndTime(DateUtils.dateToString((Date)schedule.getEndTime(), (String)ZoneId.systemDefault().getId()));
    }

    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getTimezoneId() {
        return this.timezoneId;
    }

    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    public String getCrontab() {
        return this.crontab;
    }

    public void setCrontab(String crontab) {
        this.crontab = crontab;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    public WarningType getWarningType() {
        return this.warningType;
    }

    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public ReleaseState getReleaseState() {
        return this.releaseState;
    }

    public void setReleaseState(ReleaseState releaseState) {
        this.releaseState = releaseState;
    }

    public long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    public void setProcessDefinitionCode(long processDefinitionCode) {
        this.processDefinitionCode = processDefinitionCode;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public String toString() {
        return "Schedule{id=" + this.id + ", processDefinitionCode=" + this.processDefinitionCode + ", processDefinitionName='" + this.processDefinitionName + '\'' + ", projectName='" + this.projectName + '\'' + ", description='" + this.definitionDescription + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", timezoneId='" + this.timezoneId + 39 + ", crontab='" + this.crontab + '\'' + ", failureStrategy=" + this.failureStrategy + ", warningType=" + this.warningType + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", userId=" + this.userId + ", userName='" + this.userName + '\'' + ", releaseState=" + this.releaseState + ", warningGroupId=" + this.warningGroupId + ", processInstancePriority=" + this.processInstancePriority + ", workerGroup='" + this.workerGroup + '\'' + ", environmentCode='" + this.environmentCode + '\'' + '}';
    }

    public String getDefinitionDescription() {
        return this.definitionDescription;
    }

    public void setDefinitionDescription(String definitionDescription) {
        this.definitionDescription = definitionDescription;
    }
}

