/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.K8sNamespaceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"K8S_NAMESPACE_TAG"})
@RestController
@RequestMapping(value={"/k8s-namespace"})
public class K8sNamespaceController
extends BaseController {
    @Autowired
    private K8sNamespaceService k8sNamespaceService;

    @ApiOperation(value="queryNamespaceListPaging", notes="QUERY_NAMESPACE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_K8S_NAMESPACE_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryProjectListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.k8sNamespaceService.queryListPaging(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="createK8sNamespace", notes="CREATE_NAMESPACE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="namespace", value="NAMESPACE", required=true, dataType="String"), @ApiImplicitParam(name="k8s", value="K8S", required=true, dataType="String"), @ApiImplicitParam(name="limits_cpu", value="LIMITS_CPU", required=false, dataType="Double"), @ApiImplicitParam(name="limits_memory", value="LIMITS_MEMORY", required=false, dataType="Integer")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createNamespace(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="namespace") String namespace, @RequestParam(value="k8s") String k8s, @RequestParam(value="limitsCpu", required=false) Double limitsCpu, @RequestParam(value="limitsMemory", required=false) Integer limitsMemory) {
        Map<String, Object> result = this.k8sNamespaceService.createK8sNamespace(loginUser, namespace, k8s, limitsCpu, limitsMemory);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateK8sNamespace", notes="UPDATE_NAMESPACE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="K8S_NAMESPACE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="userName", value="OWNER", required=false, dataType="String"), @ApiImplicitParam(name="limitsCpu", value="LIMITS_CPU", required=false, dataType="Double"), @ApiImplicitParam(name="limitsMemory", value="LIMITS_MEMORY", required=false, dataType="Integer")})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateNamespace(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="limitsCpu", required=false) Double limitsCpu, @RequestParam(value="limitsMemory", required=false) Integer limitsMemory) {
        Map<String, Object> result = this.k8sNamespaceService.updateK8sNamespace(loginUser, id, userName, limitsCpu, limitsMemory);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyNamespaceK8s", notes="VERIFY_NAMESPACE_K8S_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="namespace", value="NAMESPACE", required=true, dataType="String"), @ApiImplicitParam(name="k8s", value="K8S", required=true, dataType="String")})
    @PostMapping(value={"/verify"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_K8S_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyNamespace(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="namespace") String namespace, @RequestParam(value="k8s") String k8s) {
        return this.k8sNamespaceService.verifyNamespaceK8s(namespace, k8s);
    }

    @ApiOperation(value="delNamespaceById", notes="DELETE_NAMESPACE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="NAMESPACE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_K8S_NAMESPACE_BY_ID_ERROR)
    @AccessLogAnnotation
    public Result delNamespaceById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        Map<String, Object> result = this.k8sNamespaceService.deleteNamespaceById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUnauthorizedNamespace", notes="QUERY_UNAUTHORIZED_NAMESPACE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/unauth-namespace"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UNAUTHORIZED_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryUnauthorizedNamespace(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.k8sNamespaceService.queryUnauthorizedNamespace(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAuthorizedNamespace", notes="QUERY_AUTHORIZED_NAMESPACE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", dataType="Int", example="100")})
    @GetMapping(value={"/authed-namespace"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_NAMESPACE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAuthorizedNamespace(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.k8sNamespaceService.queryAuthorizedNamespace(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAvailableNamespaceList", notes="QUERY_AVAILABLE_NAMESPACE_LIST_NOTES")
    @GetMapping(value={"/available-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CAN_USE_K8S_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAvailableNamespaceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        List<K8sNamespace> result = this.k8sNamespaceService.queryNamespaceAvailable(loginUser);
        return this.success(result);
    }
}

