/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.ScheduleParam;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.ScheduleVo;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.ProcessScheduleJob;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutor;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedulerServiceImpl
extends BaseServiceImpl
implements SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private QuartzExecutor quartzExecutor;

    @Override
    @Transactional
    public Map<String, Object> insertSchedule(User loginUser, long projectCode, long processDefineCode, String schedule, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, Long environmentCode) {
        Map<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefineCode);
        result = this.executorService.checkProcessDefinitionValid(projectCode, processDefinition, processDefineCode, processDefinition.getVersion());
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Schedule scheduleObj = new Schedule();
        Date now = new Date();
        scheduleObj.setProjectName(project.getName());
        scheduleObj.setProcessDefinitionCode(processDefineCode);
        scheduleObj.setProcessDefinitionName(processDefinition.getName());
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        if (now.after(scheduleParam.getStartTime())) {
            logger.warn("The start time must be later than current time.");
            this.putMsg(result, Status.START_TIME_BEFORE_CURRENT_TIME_ERROR, new Object[0]);
            return result;
        }
        if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
            logger.warn("The start time must not be the same as the end");
            this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
            return result;
        }
        if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
            logger.warn("The start time must be smaller than end time.");
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
            return result;
        }
        scheduleObj.setStartTime(scheduleParam.getStartTime());
        scheduleObj.setEndTime(scheduleParam.getEndTime());
        if (!CronExpression.isValidExpression((String)scheduleParam.getCrontab())) {
            logger.error("{} verify failure", (Object)scheduleParam.getCrontab());
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, scheduleParam.getCrontab());
            return result;
        }
        scheduleObj.setCrontab(scheduleParam.getCrontab());
        scheduleObj.setTimezoneId(scheduleParam.getTimezoneId());
        scheduleObj.setWarningType(warningType);
        scheduleObj.setWarningGroupId(warningGroupId);
        scheduleObj.setFailureStrategy(failureStrategy);
        scheduleObj.setCreateTime(now);
        scheduleObj.setUpdateTime(now);
        scheduleObj.setUserId(loginUser.getId());
        scheduleObj.setUserName(loginUser.getUserName());
        scheduleObj.setReleaseState(ReleaseState.OFFLINE);
        scheduleObj.setProcessInstancePriority(processInstancePriority);
        scheduleObj.setWorkerGroup(workerGroup);
        scheduleObj.setEnvironmentCode(environmentCode);
        this.scheduleMapper.insert(scheduleObj);
        processDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.processDefinitionMapper.updateById(processDefinition);
        result.put("data", this.scheduleMapper.selectById((Serializable)Integer.valueOf(scheduleObj.getId())));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("scheduleId", scheduleObj.getId());
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateSchedule(User loginUser, long projectCode, Integer id, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (schedule == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, id);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(schedule.getProcessDefinitionCode());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(schedule.getProcessDefinitionCode()));
            return result;
        }
        this.updateSchedule(result, schedule, processDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, (long)environmentCode);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> setScheduleState(User loginUser, long projectCode, Integer id, ReleaseState scheduleStatus) {
        List<Server> masterServers;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Schedule scheduleObj = (Schedule)this.scheduleMapper.selectById((Serializable)id);
        if (scheduleObj == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, id);
            return result;
        }
        if (scheduleObj.getReleaseState() == scheduleStatus) {
            logger.info("schedule release is already {},needn't to change schedule id: {} from {} to {}", new Object[]{scheduleObj.getReleaseState(), scheduleObj.getId(), scheduleObj.getReleaseState(), scheduleStatus});
            this.putMsg(result, Status.SCHEDULE_CRON_REALEASE_NEED_NOT_CHANGE, scheduleStatus);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(scheduleObj.getProcessDefinitionCode());
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(scheduleObj.getProcessDefinitionCode()));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, scheduleObj.getProcessDefinitionCode());
        if (processTaskRelations.isEmpty()) {
            this.putMsg(result, Status.PROCESS_DAG_IS_EMPTY, new Object[0]);
            return result;
        }
        if (scheduleStatus == ReleaseState.ONLINE) {
            List subProcessDefinitionList;
            Date now = new Date();
            if (now.after(scheduleObj.getStartTime())) {
                logger.warn("The start time must be later than current time.");
                this.putMsg(result, Status.START_TIME_BEFORE_CURRENT_TIME_ERROR, new Object[0]);
                return result;
            }
            if (processDefinition.getReleaseState() != ReleaseState.ONLINE) {
                logger.info("not release process definition id: {} , name : {}", (Object)processDefinition.getId(), (Object)processDefinition.getName());
                this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, processDefinition.getName());
                return result;
            }
            ArrayList subProcessDefineCodes = new ArrayList();
            this.processService.recurseFindSubProcess(processDefinition.getCode(), subProcessDefineCodes);
            if (!subProcessDefineCodes.isEmpty() && (subProcessDefinitionList = this.processDefinitionMapper.queryByCodes(subProcessDefineCodes)) != null && !subProcessDefinitionList.isEmpty()) {
                for (ProcessDefinition subProcessDefinition : subProcessDefinitionList) {
                    if (subProcessDefinition.getReleaseState() == ReleaseState.ONLINE) continue;
                    logger.info("not release process definition id: {} , name : {}", (Object)subProcessDefinition.getId(), (Object)subProcessDefinition.getName());
                    this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, String.valueOf(subProcessDefinition.getId()));
                    return result;
                }
            }
        }
        if ((masterServers = this.monitorService.getServerListFromRegistry(true)).isEmpty()) {
            this.putMsg(result, Status.MASTER_NOT_EXISTS, new Object[0]);
            return result;
        }
        scheduleObj.setReleaseState(scheduleStatus);
        this.scheduleMapper.updateById(scheduleObj);
        try {
            switch (scheduleStatus) {
                case ONLINE: {
                    logger.info("Call master client set schedule online, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    this.setSchedule(project.getId(), scheduleObj);
                    break;
                }
                case OFFLINE: {
                    logger.info("Call master client set schedule offline, project id: {}, flow id: {},host: {}", new Object[]{project.getId(), processDefinition.getId(), masterServers});
                    this.deleteSchedule(project.getId(), id);
                    break;
                }
                default: {
                    this.putMsg(result, Status.SCHEDULE_STATUS_UNKNOWN, scheduleStatus.toString());
                    return result;
                }
            }
        }
        catch (Exception e) {
            result.put("msg", scheduleStatus == ReleaseState.ONLINE ? "set online failure" : "set offline failure");
            throw new ServiceException(result.get("msg").toString(), e);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result querySchedule(User loginUser, long projectCode, long processDefineCode, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefineCode);
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, new Object[]{String.valueOf(processDefineCode)});
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage scheduleIPage = this.scheduleMapper.queryByProcessDefineCodePaging((IPage)page, processDefineCode, searchVal);
        ArrayList<ScheduleVo> scheduleList = new ArrayList<ScheduleVo>();
        for (Schedule schedule : scheduleIPage.getRecords()) {
            scheduleList.add(new ScheduleVo(schedule));
        }
        PageInfo<ScheduleVo> pageInfo = new PageInfo<ScheduleVo>(pageNo, pageSize);
        pageInfo.setTotal((int)scheduleIPage.getTotal());
        pageInfo.setTotalList(scheduleList);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryScheduleList(User loginUser, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        List schedules = this.scheduleMapper.querySchedulerListByProjectName(project.getName());
        ArrayList<ScheduleVo> scheduleList = new ArrayList<ScheduleVo>();
        for (Schedule schedule : schedules) {
            scheduleList.add(new ScheduleVo(schedule));
        }
        result.put("data", scheduleList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public void setSchedule(int projectId, Schedule schedule) {
        logger.info("set schedule, project id: {}, scheduleId: {}", (Object)projectId, (Object)schedule.getId());
        this.quartzExecutor.addJob(ProcessScheduleJob.class, projectId, schedule);
    }

    @Override
    public void deleteSchedule(int projectId, int scheduleId) {
        logger.info("delete schedules of project id:{}, schedule id:{}", (Object)projectId, (Object)scheduleId);
        String jobName = this.quartzExecutor.buildJobName(scheduleId);
        String jobGroupName = this.quartzExecutor.buildJobGroupName(projectId);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                logger.info("Try to delete job: {}, group name: {},", (Object)jobName, (Object)jobGroupName);
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (SchedulerException e) {
            logger.error("Failed to delete job: {}", (Object)jobKey);
            throw new ServiceException("Failed to delete job: " + jobKey);
        }
    }

    private boolean checkValid(Map<String, Object> result, boolean bool, Status status) {
        if (bool) {
            this.putMsg(result, status, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> deleteScheduleById(User loginUser, long projectCode, Integer scheduleId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultEnum = (Status)((Object)checkResult.get("status"));
        if (resultEnum != Status.SUCCESS) {
            return checkResult;
        }
        Schedule schedule = (Schedule)this.scheduleMapper.selectById((Serializable)scheduleId);
        if (schedule == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, scheduleId);
            return result;
        }
        if (loginUser.getId() != schedule.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (schedule.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.SCHEDULE_CRON_STATE_ONLINE, schedule.getId());
            return result;
        }
        int delete = this.scheduleMapper.deleteById((Serializable)scheduleId);
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> previewSchedule(User loginUser, String schedule) {
        CronExpression cronExpression;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)schedule, ScheduleParam.class);
        Date now = new Date();
        assert (scheduleParam != null);
        Date startTime = DateUtils.transformTimezoneDate((Date)scheduleParam.getStartTime(), (String)scheduleParam.getTimezoneId());
        Date endTime = DateUtils.transformTimezoneDate((Date)scheduleParam.getEndTime(), (String)scheduleParam.getTimezoneId());
        startTime = now.after(startTime) ? now : startTime;
        try {
            cronExpression = CronUtils.parse2CronExpression((String)scheduleParam.getCrontab());
            cronExpression.setTimeZone(TimeZone.getTimeZone(scheduleParam.getTimezoneId()));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
            return result;
        }
        List selfFireDateList = CronUtils.getSelfFireDateList((Date)startTime, (Date)endTime, (CronExpression)cronExpression, (int)5);
        ArrayList previewDateList = new ArrayList();
        selfFireDateList.forEach(date -> previewDateList.add(DateUtils.dateToString((Date)date, (String)scheduleParam.getTimezoneId())));
        result.put("data", previewDateList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateScheduleByProcessDefinitionCode(User loginUser, long projectCode, long processDefinitionCode, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, long environmentCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Schedule schedule = this.scheduleMapper.queryByProcessDefinitionCode(processDefinitionCode);
        if (schedule == null) {
            this.putMsg(result, Status.SCHEDULE_CRON_NOT_EXISTS, processDefinitionCode);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        this.updateSchedule(result, schedule, processDefinition, scheduleExpression, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, environmentCode);
        return result;
    }

    private void updateSchedule(Map<String, Object> result, Schedule schedule, ProcessDefinition processDefinition, String scheduleExpression, WarningType warningType, int warningGroupId, FailureStrategy failureStrategy, Priority processInstancePriority, String workerGroup, long environmentCode) {
        if (this.checkValid(result, schedule.getReleaseState() == ReleaseState.ONLINE, Status.SCHEDULE_CRON_ONLINE_FORBID_UPDATE)) {
            return;
        }
        Date now = new Date();
        if (!StringUtils.isEmpty((String)scheduleExpression)) {
            ScheduleParam scheduleParam = (ScheduleParam)JSONUtils.parseObject((String)scheduleExpression, ScheduleParam.class);
            if (scheduleParam == null) {
                this.putMsg(result, Status.PARSE_TO_CRON_EXPRESSION_ERROR, new Object[0]);
                return;
            }
            if (now.after(scheduleParam.getStartTime())) {
                logger.warn("The start time must be later than current time.");
                this.putMsg(result, Status.START_TIME_BEFORE_CURRENT_TIME_ERROR, new Object[0]);
                return;
            }
            if (DateUtils.differSec((Date)scheduleParam.getStartTime(), (Date)scheduleParam.getEndTime()) == 0L) {
                logger.warn("The start time must not be the same as the end");
                this.putMsg(result, Status.SCHEDULE_START_TIME_END_TIME_SAME, new Object[0]);
                return;
            }
            if (scheduleParam.getStartTime().getTime() > scheduleParam.getEndTime().getTime()) {
                logger.warn("The start time must be smaller than end time.");
                this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, new Object[0]);
                return;
            }
            schedule.setStartTime(scheduleParam.getStartTime());
            schedule.setEndTime(scheduleParam.getEndTime());
            if (!CronExpression.isValidExpression((String)scheduleParam.getCrontab())) {
                this.putMsg(result, Status.SCHEDULE_CRON_CHECK_FAILED, scheduleParam.getCrontab());
                return;
            }
            schedule.setCrontab(scheduleParam.getCrontab());
            schedule.setTimezoneId(scheduleParam.getTimezoneId());
        }
        if (warningType != null) {
            schedule.setWarningType(warningType);
        }
        schedule.setWarningGroupId(warningGroupId);
        if (failureStrategy != null) {
            schedule.setFailureStrategy(failureStrategy);
        }
        schedule.setWorkerGroup(workerGroup);
        schedule.setEnvironmentCode(Long.valueOf(environmentCode));
        schedule.setUpdateTime(now);
        schedule.setProcessInstancePriority(processInstancePriority);
        this.scheduleMapper.updateById(schedule);
        processDefinition.setWarningGroupId(Integer.valueOf(warningGroupId));
        this.processDefinitionMapper.updateById(processDefinition);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
    }
}

