/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ALERT_GROUP_TAG"})
@RestController
@RequestMapping(value={"/alert-groups"})
public class AlertGroupController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AlertGroupController.class);
    @Autowired
    private AlertGroupService alertGroupService;

    @ApiOperation(value="createAlertgroup", notes="CREATE_ALERT_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="DESC", dataTypeClass=String.class), @ApiImplicitParam(name="alertInstanceIds", value="alertInstanceIds", required=true, dataTypeClass=String.class)})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createAlertgroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName, @RequestParam(value="description", required=false) String description, @RequestParam(value="alertInstanceIds") String alertInstanceIds) {
        Map<String, Object> result = this.alertGroupService.createAlertgroup(loginUser, groupName, description, alertInstanceIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="listAlertgroupById", notes="QUERY_ALERT_GROUP_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_ALERTGROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result list(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.alertGroupService.queryAlertgroup(loginUser);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAlertGroupListPaging", notes="QUERY_ALERT_GROUP_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_PAGING_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result listPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.alertGroupService.listPaging(loginUser, searchVal, pageNo, pageSize);
    }

    @ApiOperation(value="queryAlertGroupById", notes="QUERY_ALERT_GROUP_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", dataTypeClass=int.class, example="1")})
    @PostMapping(value={"/query"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAlertGroupById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") Integer id) {
        Map<String, Object> result = this.alertGroupService.queryAlertGroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateAlertgroup", notes="UPDATE_ALERT_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="DESC", dataTypeClass=String.class), @ApiImplicitParam(name="alertInstanceIds", value="alertInstanceIds", required=true, dataTypeClass=String.class)})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateAlertgroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="groupName") String groupName, @RequestParam(value="description", required=false) String description, @RequestParam(value="alertInstanceIds") String alertInstanceIds) {
        Map<String, Object> result = this.alertGroupService.updateAlertgroup(loginUser, id, groupName, description, alertInstanceIds);
        return this.returnDataList(result);
    }

    @ApiOperation(value="delAlertgroupById", notes="DELETE_ALERT_GROUP_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", required=true, dataTypeClass=int.class, example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ALERT_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result delAlertgroupById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> result = this.alertGroupService.delAlertgroupById(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyGroupName", notes="VERIFY_ALERT_GROUP_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyGroupName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName) {
        boolean exist = this.alertGroupService.existGroupName(groupName);
        Result result = new Result();
        if (exist) {
            logger.error("group {} has exist, can't create again.", (Object)groupName);
            result.setCode(Status.ALERT_GROUP_EXIST.getCode());
            result.setMsg(Status.ALERT_GROUP_EXIST.getMsg());
        } else {
            result.setCode(Status.SUCCESS.getCode());
            result.setMsg(Status.SUCCESS.getMsg());
        }
        return result;
    }
}

