/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ClusterService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"CLUSTER_TAG"})
@RestController
@RequestMapping(value={"cluster"})
public class ClusterController
extends BaseController {
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="createCluster", notes="CREATE_CLUSTER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="CLUSTER_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="config", value="CONFIG", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="CLUSTER_DESC", dataTypeClass=String.class)})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createProject(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description) {
        Map<String, Object> result = this.clusterService.createCluster(loginUser, name, config, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateCluster", notes="UPDATE_CLUSTER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="CLUSTER_CODE", required=true, dataTypeClass=long.class, example="100"), @ApiImplicitParam(name="name", value="CLUSTER_NAME", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="config", value="CLUSTER_CONFIG", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="description", value="CLUSTER_DESC", dataTypeClass=String.class)})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateCluster(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="code") Long code, @RequestParam(value="name") String name, @RequestParam(value="config") String config, @RequestParam(value="description", required=false) String description) {
        Map<String, Object> result = this.clusterService.updateClusterByCode(loginUser, code, name, config, description);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryClusterByCode", notes="QUERY_CLUSTER_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterCode", value="CLUSTER_CODE", required=true, dataTypeClass=long.class, example="100")})
    @GetMapping(value={"/query-by-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryClusterByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterCode") Long clusterCode) {
        Map<String, Object> result = this.clusterService.queryClusterByCode(clusterCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryClusterListPaging", notes="QUERY_CLUSTER_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataTypeClass=String.class), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryClusterListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.clusterService.queryClusterListPaging(pageNo, pageSize, searchVal);
        return result;
    }

    @ApiOperation(value="deleteClusterByCode", notes="DELETE_CLUSTER_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterCode", value="CLUSTER_CODE", required=true, dataTypeClass=long.class, example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteCluster(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterCode") Long clusterCode) {
        Map<String, Object> result = this.clusterService.deleteClusterByCode(loginUser, clusterCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryAllClusterList", notes="QUERY_ALL_CLUSTER_LIST_NOTES")
    @GetMapping(value={"/query-cluster-list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllClusterList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        Map<String, Object> result = this.clusterService.queryAllClusterList();
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyCluster", notes="VERIFY_CLUSTER_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterName", value="CLUSTER_NAME", required=true, dataTypeClass=String.class)})
    @PostMapping(value={"/verify-cluster"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_CLUSTER_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyCluster(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="clusterName") String clusterName) {
        Map<String, Object> result = this.clusterService.verifyCluster(clusterName);
        return this.returnDataList(result);
    }
}

