/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.controller.ProcessInstanceController;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ComplementDependentMode;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.remote.dto.WorkflowExecuteDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"EXECUTOR_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/executors"})
public class ExecutorController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ExecutorService execService;

    @ApiOperation(value="startProcessInstance", notes="RUN_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="100"), @ApiImplicitParam(name="scheduleTime", value="SCHEDULE_TIME", required=true, dataTypeClass=String.class, example="2022-04-06 00:00:00,2022-04-06 00:00:00"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", required=true, dataTypeClass=FailureStrategy.class), @ApiImplicitParam(name="startNodeList", value="START_NODE_LIST", dataTypeClass=String.class), @ApiImplicitParam(name="taskDependType", value="TASK_DEPEND_TYPE", dataTypeClass=TaskDependType.class), @ApiImplicitParam(name="execType", value="COMMAND_TYPE", dataTypeClass=CommandType.class), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", required=true, dataTypeClass=WarningType.class), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="runMode", value="RUN_MODE", dataTypeClass=RunMode.class), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", required=true, dataTypeClass=Priority.class), @ApiImplicitParam(name="workerGroup", value="WORKER_GROUP", dataTypeClass=String.class, example="default"), @ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", dataTypeClass=long.class, example="-1"), @ApiImplicitParam(name="timeout", value="TIMEOUT", dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="expectedParallelismNumber", value="EXPECTED_PARALLELISM_NUMBER", dataTypeClass=int.class, example="8"), @ApiImplicitParam(name="dryRun", value="DRY_RUN", dataTypeClass=int.class, example="0"), @ApiImplicitParam(name="complementDependentMode", value="COMPLEMENT_DEPENDENT_MODE", dataTypeClass=ComplementDependentMode.class)})
    @PostMapping(value={"start-process-instance"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode") long processDefinitionCode, @RequestParam(value="scheduleTime") String scheduleTime, @RequestParam(value="failureStrategy") FailureStrategy failureStrategy, @RequestParam(value="startNodeList", required=false) String startNodeList, @RequestParam(value="taskDependType", required=false) TaskDependType taskDependType, @RequestParam(value="execType", required=false) CommandType execType, @RequestParam(value="warningType") WarningType warningType, @RequestParam(value="warningGroupId", required=false, defaultValue="0") Integer warningGroupId, @RequestParam(value="runMode", required=false) RunMode runMode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="timeout", required=false) Integer timeout, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="expectedParallelismNumber", required=false) Integer expectedParallelismNumber, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun, @RequestParam(value="complementDependentMode", required=false) ComplementDependentMode complementDependentMode) {
        if (timeout == null) {
            timeout = 86400;
        }
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        if (complementDependentMode == null) {
            complementDependentMode = ComplementDependentMode.OFF_MODE;
        }
        Map<String, Object> result = this.execService.execProcessInstance(loginUser, projectCode, processDefinitionCode, scheduleTime, execType, failureStrategy, startNodeList, taskDependType, warningType, warningGroupId, runMode, processInstancePriority, workerGroup, environmentCode, timeout, startParamMap, expectedParallelismNumber, dryRun, complementDependentMode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchStartProcessInstance", notes="BATCH_RUN_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionCodes", value="PROCESS_DEFINITION_CODES", required=true, dataTypeClass=String.class, example="1,2,3"), @ApiImplicitParam(name="scheduleTime", value="SCHEDULE_TIME", required=true, dataTypeClass=String.class, example="2022-04-06 00:00:00,2022-04-06 00:00:00"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", required=true, dataTypeClass=FailureStrategy.class), @ApiImplicitParam(name="startNodeList", value="START_NODE_LIST", dataTypeClass=String.class), @ApiImplicitParam(name="taskDependType", value="TASK_DEPEND_TYPE", dataTypeClass=TaskDependType.class), @ApiImplicitParam(name="execType", value="COMMAND_TYPE", dataTypeClass=CommandType.class), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", required=true, dataTypeClass=WarningType.class), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="runMode", value="RUN_MODE", dataTypeClass=RunMode.class), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", required=true, dataTypeClass=Priority.class), @ApiImplicitParam(name="workerGroup", value="WORKER_GROUP", dataTypeClass=String.class, example="default"), @ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", dataTypeClass=long.class, example="-1"), @ApiImplicitParam(name="timeout", value="TIMEOUT", dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="expectedParallelismNumber", value="EXPECTED_PARALLELISM_NUMBER", dataTypeClass=int.class, example="8"), @ApiImplicitParam(name="dryRun", value="DRY_RUN", dataTypeClass=int.class, example="0"), @ApiImplicitParam(name="complementDependentMode", value="COMPLEMENT_DEPENDENT_MODE", dataTypeClass=ComplementDependentMode.class)})
    @PostMapping(value={"batch-start-process-instance"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchStartProcessInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCodes") String processDefinitionCodes, @RequestParam(value="scheduleTime") String scheduleTime, @RequestParam(value="failureStrategy") FailureStrategy failureStrategy, @RequestParam(value="startNodeList", required=false) String startNodeList, @RequestParam(value="taskDependType", required=false) TaskDependType taskDependType, @RequestParam(value="execType", required=false) CommandType execType, @RequestParam(value="warningType") WarningType warningType, @RequestParam(value="warningGroupId", required=false) int warningGroupId, @RequestParam(value="runMode", required=false) RunMode runMode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="timeout", required=false) Integer timeout, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="expectedParallelismNumber", required=false) Integer expectedParallelismNumber, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun, @RequestParam(value="complementDependentMode", required=false) ComplementDependentMode complementDependentMode) {
        if (timeout == null) {
            timeout = 86400;
        }
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        if (complementDependentMode == null) {
            complementDependentMode = ComplementDependentMode.OFF_MODE;
        }
        Map<String, Object> result = new HashMap<String, Object>();
        List<String> processDefinitionCodeArray = Arrays.asList(processDefinitionCodes.split(","));
        ArrayList<String> startFailedProcessDefinitionCodeList = new ArrayList<String>();
        processDefinitionCodeArray = processDefinitionCodeArray.stream().distinct().collect(Collectors.toList());
        for (String strProcessDefinitionCode : processDefinitionCodeArray) {
            long processDefinitionCode = Long.parseLong(strProcessDefinitionCode);
            result = this.execService.execProcessInstance(loginUser, projectCode, processDefinitionCode, scheduleTime, execType, failureStrategy, startNodeList, taskDependType, warningType, warningGroupId, runMode, processInstancePriority, workerGroup, environmentCode, timeout, startParamMap, expectedParallelismNumber, dryRun, complementDependentMode);
            if (Status.SUCCESS.equals(result.get("status"))) continue;
            startFailedProcessDefinitionCodeList.add(String.valueOf(processDefinitionCode));
        }
        if (!startFailedProcessDefinitionCodeList.isEmpty()) {
            this.putMsg(result, Status.BATCH_START_PROCESS_INSTANCE_ERROR, String.join((CharSequence)",", startFailedProcessDefinitionCodeList));
        }
        return this.returnDataList(result);
    }

    @ApiOperation(value="execute", notes="EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=true, dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="executeType", value="EXECUTE_TYPE", required=true, dataTypeClass=ExecuteType.class)})
    @PostMapping(value={"/execute"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.EXECUTE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result execute(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processInstanceId") Integer processInstanceId, @RequestParam(value="executeType") ExecuteType executeType) {
        Map<String, Object> result = this.execService.execute(loginUser, projectCode, processInstanceId, executeType);
        return this.returnDataList(result);
    }

    @ApiOperation(value="batchExecute", notes="BATCH_EXECUTE_ACTION_TO_PROCESS_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="processInstanceIds", value="PROCESS_INSTANCE_IDS", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="executeType", value="EXECUTE_TYPE", required=true, dataTypeClass=ExecuteType.class)})
    @PostMapping(value={"/batch-execute"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.BATCH_EXECUTE_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result batchExecute(@RequestAttribute(value="session.user") User loginUser, @PathVariable long projectCode, @RequestParam(value="processInstanceIds") String processInstanceIds, @RequestParam(value="executeType") ExecuteType executeType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> executeFailedIdList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)processInstanceIds)) {
            String[] processInstanceIdArray;
            for (String strProcessInstanceId : processInstanceIdArray = processInstanceIds.split(",")) {
                int processInstanceId = Integer.parseInt(strProcessInstanceId);
                try {
                    Map<String, Object> singleResult = this.execService.execute(loginUser, projectCode, processInstanceId, executeType);
                    if (Status.SUCCESS.equals(singleResult.get("status"))) continue;
                    executeFailedIdList.add((String)singleResult.get("msg"));
                    logger.error((String)singleResult.get("msg"));
                }
                catch (Exception e) {
                    executeFailedIdList.add(MessageFormat.format(Status.PROCESS_INSTANCE_ERROR.getMsg(), strProcessInstanceId));
                }
            }
        }
        if (!executeFailedIdList.isEmpty()) {
            this.putMsg(result, Status.BATCH_EXECUTE_PROCESS_INSTANCE_ERROR, String.join((CharSequence)"\n", executeFailedIdList));
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return this.returnDataList(result);
    }

    @ApiOperation(value="startCheckProcessDefinition", notes="START_CHECK_PROCESS_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataTypeClass=long.class, example="100")})
    @PostMapping(value={"/start-check"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CHECK_PROCESS_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startCheckProcessDefinition(@RequestParam(value="processDefinitionCode") long processDefinitionCode) {
        Map<String, Object> result = this.execService.startCheckByProcessDefinedCode(processDefinitionCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryExecutingWorkflow", notes="QUERY_WORKFLOW_EXECUTE_DATA")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=true, dataTypeClass=int.class, example="100")})
    @GetMapping(value={"/query-executing-workflow"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_EXECUTING_WORKFLOW_ERROR)
    @AccessLogAnnotation
    public Result queryExecutingWorkflow(@RequestParam(value="id") Integer processInstanceId) {
        WorkflowExecuteDto workflowExecuteDto = this.execService.queryExecutingWorkflowByProcessInstanceId(processInstanceId);
        return Result.success(workflowExecuteDto);
    }

    @ApiOperation(value="startTaskInstance", notes="RUN_TASK_INSTANCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="version", value="VERSION", dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", required=true, dataTypeClass=FailureStrategy.class), @ApiImplicitParam(name="execType", value="COMMAND_TYPE", dataTypeClass=CommandType.class), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", required=true, dataTypeClass=WarningType.class), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="workerGroup", value="WORKER_GROUP", dataTypeClass=String.class, example="default"), @ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", dataTypeClass=long.class, example="-1"), @ApiImplicitParam(name="timeout", value="TIMEOUT", dataTypeClass=int.class, example="100"), @ApiImplicitParam(name="dryRun", value="DRY_RUN", dataTypeClass=int.class, example="0")})
    @PostMapping(value={"/task-instance/{code}/start"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.START_PROCESS_INSTANCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startStreamTaskInstance(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @ApiParam(name="code", value="TASK_CODE", required=true) @PathVariable long code, @RequestParam(value="version", required=true) int version, @RequestParam(value="warningGroupId", required=false, defaultValue="0") Integer warningGroupId, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="startParams", required=false) String startParams, @RequestParam(value="dryRun", defaultValue="0", required=false) int dryRun) {
        Map startParamMap = null;
        if (startParams != null) {
            startParamMap = JSONUtils.toMap((String)startParams);
        }
        Map<String, Object> result = this.execService.execStreamTaskInstance(loginUser, projectCode, code, version, warningGroupId, workerGroup, environmentCode, startParamMap, dryRun);
        return this.returnDataList(result);
    }
}

