/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.ClusterDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.k8s.K8sManager;
import org.apache.dolphinscheduler.api.service.ClusterService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.utils.ClusterConfUtils;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.K8sNamespaceMapper;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClusterServiceImpl
extends BaseServiceImpl
implements ClusterService {
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceImpl.class);
    @Autowired
    private ClusterMapper clusterMapper;
    @Autowired
    private K8sManager k8sManager;
    @Autowired
    private K8sNamespaceMapper k8sNamespaceMapper;

    @Override
    @Transactional
    public Map<String, Object> createCluster(User loginUser, String name, String config, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Cluster clusterExistByName = this.clusterMapper.queryByClusterName(name);
        if (clusterExistByName != null) {
            this.putMsg(result, Status.CLUSTER_NAME_EXISTS, name);
            return result;
        }
        Cluster cluster = new Cluster();
        cluster.setName(name);
        cluster.setConfig(config);
        cluster.setDescription(desc);
        cluster.setOperator(loginUser.getId());
        cluster.setCreateTime(new Date());
        cluster.setUpdateTime(new Date());
        long code = 0L;
        try {
            code = CodeGenerateUtils.getInstance().genCode();
            cluster.setCode(Long.valueOf(code));
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            logger.error("Cluster code get error, ", (Throwable)e);
        }
        if (code == 0L) {
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating cluster code");
            return result;
        }
        if (this.clusterMapper.insert((Object)cluster) > 0) {
            result.put("data", cluster.getCode());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_CLUSTER_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryClusterListPaging(Integer pageNo, Integer pageSize, String searchVal) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage clusterIPage = this.clusterMapper.queryClusterListPaging((IPage)page, searchVal);
        PageInfo<Object> pageInfo = new PageInfo<Object>(pageNo, pageSize);
        pageInfo.setTotal((int)clusterIPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)clusterIPage.getRecords())) {
            List dtoList = clusterIPage.getRecords().stream().map(cluster -> {
                ClusterDto dto = new ClusterDto();
                BeanUtils.copyProperties((Object)cluster, (Object)dto);
                return dto;
            }).collect(Collectors.toList());
            pageInfo.setTotalList(dtoList);
        } else {
            pageInfo.setTotalList(new ArrayList());
        }
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllClusterList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List clusterList = this.clusterMapper.queryAllClusterList();
        if (CollectionUtils.isNotEmpty((Collection)clusterList)) {
            List dtoList = clusterList.stream().map(cluster -> {
                ClusterDto dto = new ClusterDto();
                BeanUtils.copyProperties((Object)cluster, (Object)dto);
                return dto;
            }).collect(Collectors.toList());
            result.put("data", dtoList);
        } else {
            result.put("data", new ArrayList());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryClusterByCode(Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Cluster cluster = this.clusterMapper.queryByClusterCode(code);
        if (cluster == null) {
            this.putMsg(result, Status.QUERY_CLUSTER_BY_CODE_ERROR, code);
        } else {
            ClusterDto dto = new ClusterDto();
            BeanUtils.copyProperties((Object)cluster, (Object)dto);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryClusterByName(String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Cluster cluster = this.clusterMapper.queryByClusterName(name);
        if (cluster == null) {
            this.putMsg(result, Status.QUERY_CLUSTER_BY_NAME_ERROR, name);
        } else {
            ClusterDto dto = new ClusterDto();
            BeanUtils.copyProperties((Object)cluster, (Object)dto);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteClusterByCode(User loginUser, Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Long relatedNamespaceNumber = this.k8sNamespaceMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(K8sNamespace::getClusterCode, (Object)code));
        if (relatedNamespaceNumber > 0L) {
            this.putMsg(result, Status.DELETE_CLUSTER_RELATED_NAMESPACE_EXISTS, new Object[0]);
            return result;
        }
        int delete = this.clusterMapper.deleteByCode(code);
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_CLUSTER_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateClusterByCode(User loginUser, Long code, String name, String config, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        if (this.checkDescriptionLength(desc)) {
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Cluster clusterExistByName = this.clusterMapper.queryByClusterName(name);
        if (clusterExistByName != null && !clusterExistByName.getCode().equals(code)) {
            this.putMsg(result, Status.CLUSTER_NAME_EXISTS, name);
            return result;
        }
        Cluster clusterExist = this.clusterMapper.queryByClusterCode(code);
        if (clusterExist == null) {
            this.putMsg(result, Status.CLUSTER_NOT_EXISTS, name);
            return result;
        }
        if (!Constants.K8S_LOCAL_TEST_CLUSTER_CODE.equals(clusterExist.getCode()) && !config.equals(ClusterConfUtils.getK8sConfig((String)clusterExist.getConfig()))) {
            try {
                this.k8sManager.getAndUpdateK8sClient(code, true);
            }
            catch (RemotingException e) {
                this.putMsg(result, Status.K8S_CLIENT_OPS_ERROR, name);
                return result;
            }
        }
        clusterExist.setConfig(config);
        clusterExist.setName(name);
        clusterExist.setDescription(desc);
        this.clusterMapper.updateById((Object)clusterExist);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> verifyCluster(String clusterName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            this.putMsg(result, Status.CLUSTER_NAME_IS_NULL, new Object[0]);
            return result;
        }
        Cluster cluster = this.clusterMapper.queryByClusterName(clusterName);
        if (cluster != null) {
            this.putMsg(result, Status.CLUSTER_NAME_EXISTS, clusterName);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }

    public Map<String, Object> checkParams(String name, String config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.putMsg(result, Status.CLUSTER_NAME_IS_NULL, new Object[0]);
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)config)) {
            this.putMsg(result, Status.CLUSTER_CONFIG_IS_NULL, new Object[0]);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }
}

