/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceServiceImpl
extends BaseServiceImpl
implements DataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW"};
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";

    @Override
    @Transactional
    public Result<Object> createDataSource(User loginUser, BaseDataSourceParamDTO datasourceParam) {
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)datasourceParam);
        Result<Object> result = new Result<Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.DATASOURCE, "datasource:create")) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (this.checkName(datasourceParam.getName())) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(datasourceParam.getNote())) {
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        ConnectionParam connectionParam = DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)datasourceParam);
        Result<Object> isConnection = this.checkConnection(datasourceParam.getType(), connectionParam);
        if (Status.SUCCESS.getCode() != isConnection.getCode().intValue()) {
            this.putMsg((Result)result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
            return result;
        }
        DataSource dataSource = new DataSource();
        Date now = new Date();
        dataSource.setName(datasourceParam.getName().trim());
        dataSource.setNote(datasourceParam.getNote());
        dataSource.setUserId(loginUser.getId().intValue());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(datasourceParam.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setCreateTime(now);
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.insert((Object)dataSource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
            this.permissionPostHandle(AuthorizationType.DATASOURCE, loginUser.getId(), Collections.singletonList(dataSource.getId()), logger);
        }
        catch (DuplicateKeyException ex) {
            logger.error("Create datasource error.", (Throwable)ex);
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Result<Object> updateDataSource(int id, User loginUser, BaseDataSourceParamDTO dataSourceParam) {
        Result<Object> isConnection;
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)dataSourceParam);
        Result<Object> result = new Result<Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.canOperatorPermissions(loginUser, new Object[]{dataSource.getId()}, AuthorizationType.DATASOURCE, "datasource:update")) {
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!dataSource.getName().trim().equals(dataSource.getName()) && this.checkName(dataSource.getName())) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
            return result;
        }
        if (this.checkDescriptionLength(dataSourceParam.getNote())) {
            this.putMsg((Result)result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)dataSourceParam);
        String password = connectionParam.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            String oldConnectionParams = dataSource.getConnectionParams();
            ObjectNode oldParams = JSONUtils.parseObject((String)oldConnectionParams);
            connectionParam.setPassword(oldParams.path("password").asText());
        }
        if ((isConnection = this.checkConnection(dataSource.getType(), (ConnectionParam)connectionParam)).isFailed()) {
            return isConnection;
        }
        Date now = new Date();
        dataSource.setName(dataSourceParam.getName().trim());
        dataSource.setNote(dataSourceParam.getNote());
        dataSource.setUserName(loginUser.getUserName());
        dataSource.setType(dataSource.getType());
        dataSource.setConnectionParams(JSONUtils.toJsonString((Object)connectionParam));
        dataSource.setUpdateTime(now);
        try {
            this.dataSourceMapper.updateById((Object)dataSource);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            logger.error("Update datasource error.", (Throwable)ex);
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        }
        return result;
    }

    private boolean checkName(String name) {
        List queryDataSource = this.dataSourceMapper.queryDataSourceByName(name.trim());
        return queryDataSource != null && !queryDataSource.isEmpty();
    }

    @Override
    public Map<String, Object> queryDataSource(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        BaseDataSourceParamDTO baseDataSourceParamDTO = DataSourceUtils.buildDatasourceParamDTO((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
        baseDataSourceParamDTO.setId(dataSource.getId());
        baseDataSourceParamDTO.setName(dataSource.getName());
        baseDataSourceParamDTO.setNote(dataSource.getNote());
        result.put("data", baseDataSourceParamDTO);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryDataSourceListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        IPage dataSourceList = null;
        Page dataSourcePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            dataSourceList = this.dataSourceMapper.selectPaging((IPage)dataSourcePage, UserType.ADMIN_USER.equals((Object)loginUser.getUserType()) ? 0 : loginUser.getId(), searchVal);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.DATASOURCE, loginUser.getId(), logger);
            if (ids.isEmpty()) {
                result.setData(pageInfo);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                return result;
            }
            dataSourceList = this.dataSourceMapper.selectPagingByIds(dataSourcePage, new ArrayList(ids), searchVal);
        }
        List dataSources = dataSourceList != null ? dataSourceList.getRecords() : new ArrayList();
        this.handlePasswd(dataSources);
        pageInfo.setTotal((int)(dataSourceList != null ? dataSourceList.getTotal() : 0L));
        pageInfo.setTotalList(dataSources);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void handlePasswd(List<DataSource> dataSourceList) {
        for (DataSource dataSource : dataSourceList) {
            String connectionParams = dataSource.getConnectionParams();
            ObjectNode object = JSONUtils.parseObject((String)connectionParams);
            object.put("password", this.getHiddenPassword());
            dataSource.setConnectionParams(object.toString());
        }
    }

    private String getHiddenPassword() {
        return "******";
    }

    @Override
    public Map<String, Object> queryDataSourceList(User loginUser, Integer type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List datasourceList = null;
        if (loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            datasourceList = this.dataSourceMapper.queryDataSourceByType(0, type);
        } else {
            Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.DATASOURCE, loginUser.getId(), logger);
            if (ids.isEmpty()) {
                result.put("data", Collections.emptyList());
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                return result;
            }
            datasourceList = this.dataSourceMapper.selectBatchIds(ids).stream().filter(dataSource -> dataSource.getType().getCode() == type.intValue()).collect(Collectors.toList());
        }
        result.put("data", datasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyDataSourceName(String name) {
        Result<Object> result = new Result<Object>();
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(name);
        if (dataSourceList != null && !dataSourceList.isEmpty()) {
            this.putMsg((Result)result, Status.DATASOURCE_EXIST, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result<Object> checkConnection(DbType type, ConnectionParam connectionParam) {
        Result<Object> result2 = new Result<Object>();
        try (Connection connection = DataSourceClientProvider.getInstance().getConnection(type, connectionParam);){
            if (connection == null) {
                this.putMsg((Result)result2, Status.CONNECTION_TEST_FAILURE, new Object[0]);
                Result<Object> result = result2;
                return result;
            }
            this.putMsg((Result)result2, Status.SUCCESS, new Object[0]);
            Result<Object> throwable4 = result2;
            return throwable4;
        }
        catch (Exception e) {
            String message = Optional.of(e).map(Throwable::getCause).map(Throwable::getMessage).orElse(e.getMessage());
            logger.error("datasource test connection error, dbType:{}, connectionParam:{}, message:{}.", new Object[]{type, connectionParam, message});
            return new Result<Object>(Status.CONNECTION_TEST_FAILURE.getCode(), message);
        }
    }

    @Override
    public Result<Object> connectionTest(int id) {
        DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
        if (dataSource == null) {
            Result<Object> result = new Result<Object>();
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        return this.checkConnection(dataSource.getType(), DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams()));
    }

    @Override
    @Transactional
    public Result<Object> delete(User loginUser, int datasourceId) {
        Result<Object> result = new Result<Object>();
        try {
            DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(datasourceId));
            if (dataSource == null) {
                logger.error("resource id {} not exist", (Object)datasourceId);
                this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            if (!this.canOperatorPermissions(loginUser, new Object[]{dataSource.getId()}, AuthorizationType.DATASOURCE, "datasource:delete")) {
                this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
                return result;
            }
            this.dataSourceMapper.deleteById((Serializable)Integer.valueOf(datasourceId));
            this.datasourceUserMapper.deleteByDatasourceId(datasourceId);
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            logger.error("delete datasource error", (Throwable)e);
            throw new RuntimeException("delete datasource error");
        }
        return result;
    }

    @Override
    public Map<String, Object> unauthDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List datasourceList = this.canOperatorPermissions(loginUser, null, AuthorizationType.DATASOURCE, null) ? this.dataSourceMapper.queryDatasourceExceptUserId(userId.intValue()) : this.dataSourceMapper.selectByMap(Collections.singletonMap("user_id", loginUser.getId()));
        ArrayList resultList = new ArrayList();
        if (datasourceList != null && !datasourceList.isEmpty()) {
            HashSet datasourceSet = new HashSet(datasourceList);
            List authedDataSourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
            if (authedDataSourceList != null && !authedDataSourceList.isEmpty()) {
                HashSet authedDataSourceSet = new HashSet(authedDataSourceList);
                datasourceSet.removeAll(authedDataSourceSet);
            }
            resultList = new ArrayList(datasourceSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authedDatasource(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List authedDatasourceList = this.dataSourceMapper.queryAuthedDatasource(userId.intValue());
        result.put("data", authedDatasourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getTables(Integer datasourceId) {
        ResultSet tables;
        Connection connection;
        ArrayList<String> tableList;
        HashMap<String, Object> result;
        block14: {
            HashMap<String, Object> e2;
            block13: {
                result = new HashMap<String, Object>();
                DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)datasourceId);
                tableList = null;
                BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
                if (null == connectionParam) {
                    this.putMsg(result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
                    return result;
                }
                connection = DataSourceUtils.getConnection((DbType)dataSource.getType(), (ConnectionParam)connectionParam);
                tables = null;
                try {
                    if (null == connection) {
                        this.putMsg(result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
                        HashMap<String, Object> hashMap = result;
                        return hashMap;
                    }
                    DatabaseMetaData metaData = connection.getMetaData();
                    String schema = null;
                    try {
                        schema = metaData.getConnection().getSchema();
                    }
                    catch (SQLException e2) {
                        logger.error("cant not get the schema : {}", (Object)e2.getMessage(), (Object)e2);
                    }
                    tables = metaData.getTables(connectionParam.getDatabase(), this.getDbSchemaPattern(dataSource.getType(), schema, connectionParam), "%", TABLE_TYPES);
                    if (null == tables) {
                        this.putMsg(result, Status.GET_DATASOURCE_TABLES_ERROR, new Object[0]);
                        e2 = result;
                        DataSourceServiceImpl.closeResult(tables);
                        break block13;
                    }
                    tableList = new ArrayList<String>();
                    while (tables.next()) {
                        String name = tables.getString(TABLE_NAME);
                        tableList.add(name);
                    }
                    DataSourceServiceImpl.closeResult(tables);
                    break block14;
                }
                catch (Exception e3) {
                    logger.error(e3.toString(), (Throwable)e3);
                    this.putMsg(result, Status.GET_DATASOURCE_TABLES_ERROR, new Object[0]);
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
            }
            DataSourceServiceImpl.releaseConnection(connection);
            return e2;
        }
        DataSourceServiceImpl.releaseConnection(connection);
        List<ParamsOptions> options = this.getParamsOptions(tableList);
        result.put("data", options);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
        finally {
            DataSourceServiceImpl.closeResult(tables);
            DataSourceServiceImpl.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getTableColumns(Integer datasourceId, String tableName) {
        ArrayList<String> columnList;
        HashMap<String, Object> result;
        block14: {
            ResultSet rs;
            Connection connection;
            block13: {
                HashMap<String, Object> hashMap;
                block12: {
                    result = new HashMap<String, Object>();
                    DataSource dataSource = (DataSource)this.dataSourceMapper.selectById((Serializable)datasourceId);
                    BaseConnectionParam connectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
                    if (null == connectionParam) {
                        this.putMsg(result, Status.DATASOURCE_CONNECT_FAILED, new Object[0]);
                        return result;
                    }
                    connection = DataSourceUtils.getConnection((DbType)dataSource.getType(), (ConnectionParam)connectionParam);
                    columnList = new ArrayList<String>();
                    rs = null;
                    try {
                        String database = connectionParam.getDatabase();
                        if (null == connection) {
                            HashMap<String, Object> hashMap2 = result;
                            return hashMap2;
                        }
                        DatabaseMetaData metaData = connection.getMetaData();
                        if (dataSource.getType() == DbType.ORACLE) {
                            database = null;
                        }
                        if ((rs = metaData.getColumns(database, null, tableName, "%")) == null) {
                            hashMap = result;
                            DataSourceServiceImpl.closeResult(rs);
                            break block12;
                        }
                        while (rs.next()) {
                            columnList.add(rs.getString(COLUMN_NAME));
                        }
                        DataSourceServiceImpl.closeResult(rs);
                        break block13;
                    }
                    catch (Exception e) {
                        logger.error(e.toString(), (Throwable)e);
                        break block14;
                    }
                }
                DataSourceServiceImpl.releaseConnection(connection);
                return hashMap;
            }
            DataSourceServiceImpl.releaseConnection(connection);
            break block14;
            finally {
                DataSourceServiceImpl.closeResult(rs);
                DataSourceServiceImpl.releaseConnection(connection);
            }
        }
        List<ParamsOptions> options = this.getParamsOptions(columnList);
        result.put("data", options);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<ParamsOptions> getParamsOptions(List<String> columnList) {
        ArrayList<ParamsOptions> options = null;
        if (CollectionUtils.isNotEmpty(columnList)) {
            options = new ArrayList<ParamsOptions>();
            for (String column : columnList) {
                ParamsOptions childrenOption = new ParamsOptions(column, (Object)column, false);
                options.add(childrenOption);
            }
        }
        return options;
    }

    private String getDbSchemaPattern(DbType dbType, String schema, BaseConnectionParam connectionParam) {
        if (dbType == null) {
            return null;
        }
        String schemaPattern = null;
        switch (dbType) {
            case HIVE: {
                schemaPattern = connectionParam.getDatabase();
                break;
            }
            case ORACLE: {
                schemaPattern = connectionParam.getUser();
                if (null == schemaPattern) break;
                schemaPattern = schemaPattern.toUpperCase();
                break;
            }
            case SQLSERVER: {
                schemaPattern = "dbo";
                break;
            }
            case CLICKHOUSE: 
            case PRESTO: {
                if (StringUtils.isEmpty((CharSequence)schema)) break;
                schemaPattern = schema;
                break;
            }
        }
        return schemaPattern;
    }

    private static void releaseConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error("Connection release error", (Throwable)e);
            }
        }
    }

    private static void closeResult(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.error("ResultSet close error", (Throwable)e);
            }
        }
    }
}

